/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.CodeEngine;
import com.ibm.cloud.code_engine.code_engine.v2.model.App;
import com.ibm.cloud.code_engine.code_engine.v2.model.AppList;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListAppsOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class AppsPager {
    protected boolean hasNext;
    protected ListAppsOptions options;
    protected CodeEngine client;
    protected PageContext pageContext;

    protected AppsPager() {
    }

    public AppsPager(CodeEngine client, ListAppsOptions options) {
        if (options.start() != null) {
            throw new IllegalArgumentException("The options 'start' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<App> getNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListAppsOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.start(this.pageContext.getNext());
        }
        this.options = builder.build();
        AppList result = (AppList)((Object)this.client.listApps(this.options).execute().getResult());
        String next = null;
        if (result.getNext() != null) {
            next = result.getNext().getStart();
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getApps();
    }

    public List<App> getAll() {
        ArrayList<App> results = new ArrayList<App>();
        while (this.hasNext()) {
            List<App> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private String next;

        private PageContext() {
        }

        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }
}

