/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class BuildParamPrototype
extends GenericModel {
    protected String key;
    protected String name;
    protected String reference;
    protected String type;
    protected String value;

    protected BuildParamPrototype() {
    }

    protected BuildParamPrototype(Builder builder) {
        Validator.notNull((Object)builder.type, (String)"type cannot be null");
        this.key = builder.key;
        this.name = builder.name;
        this.reference = builder.reference;
        this.type = builder.type;
        this.value = builder.value;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String key() {
        return this.key;
    }

    public String name() {
        return this.name;
    }

    public String reference() {
        return this.reference;
    }

    public String type() {
        return this.type;
    }

    public String value() {
        return this.value;
    }

    public static class Builder {
        private String key;
        private String name;
        private String reference;
        private String type;
        private String value;

        private Builder(BuildParamPrototype buildParamPrototype) {
            this.key = buildParamPrototype.key;
            this.name = buildParamPrototype.name;
            this.reference = buildParamPrototype.reference;
            this.type = buildParamPrototype.type;
            this.value = buildParamPrototype.value;
        }

        public Builder() {
        }

        public Builder(String type) {
            this.type = type;
        }

        public BuildParamPrototype build() {
            return new BuildParamPrototype(this);
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }
    }

    public static interface Type {
        public static final String LITERAL = "literal";
        public static final String CONFIG_MAP_KEY_REFERENCE = "config_map_key_reference";
        public static final String SECRET_KEY_REFERENCE = "secret_key_reference";
    }
}

