/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class ListSecretsOptions
extends GenericModel {
    protected String projectId;
    protected String format;
    protected Long limit;
    protected String start;

    protected ListSecretsOptions() {
    }

    protected ListSecretsOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        this.projectId = builder.projectId;
        this.format = builder.format;
        this.limit = builder.limit;
        this.start = builder.start;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String format() {
        return this.format;
    }

    public Long limit() {
        return this.limit;
    }

    public String start() {
        return this.start;
    }

    public static class Builder {
        private String projectId;
        private String format;
        private Long limit;
        private String start;

        private Builder(ListSecretsOptions listSecretsOptions) {
            this.projectId = listSecretsOptions.projectId;
            this.format = listSecretsOptions.format;
            this.limit = listSecretsOptions.limit;
            this.start = listSecretsOptions.start;
        }

        public Builder() {
        }

        public Builder(String projectId) {
            this.projectId = projectId;
        }

        public ListSecretsOptions build() {
            return new ListSecretsOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder start(String start) {
            this.start = start;
            return this;
        }
    }

    public static interface Format {
        public static final String GENERIC = "generic";
        public static final String SSH_AUTH = "ssh_auth";
        public static final String REGISTRY = "registry";
        public static final String BASIC_AUTH = "basic_auth";
        public static final String TLS = "tls";
        public static final String SERVICE_ACCESS = "service_access";
        public static final String SERVICE_OPERATOR = "service_operator";
    }
}

