/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.CodeEngine;
import com.ibm.cloud.code_engine.code_engine.v2.model.Function;
import com.ibm.cloud.code_engine.code_engine.v2.model.FunctionList;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListFunctionsOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class FunctionsPager {
    protected boolean hasNext;
    protected ListFunctionsOptions options;
    protected CodeEngine client;
    protected PageContext pageContext;

    protected FunctionsPager() {
    }

    public FunctionsPager(CodeEngine client, ListFunctionsOptions options) {
        if (options.start() != null) {
            throw new IllegalArgumentException("The options 'start' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<Function> getNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListFunctionsOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.start(this.pageContext.getNext());
        }
        this.options = builder.build();
        FunctionList result = (FunctionList)((Object)this.client.listFunctions(this.options).execute().getResult());
        String next = null;
        if (result.getNext() != null) {
            next = result.getNext().getStart();
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getFunctions();
    }

    public List<Function> getAll() {
        ArrayList<Function> results = new ArrayList<Function>();
        while (this.hasNext()) {
            List<Function> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private String next;

        private PageContext() {
        }

        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }
}

