/*
 * (C) Copyright IBM Corp. 2023.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.ibm.cloud.code_engine.code_engine.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;

/**
 * V1Context.
 */
public class V1Context extends GenericModel {

  protected String cluster;
  protected String namespace;
  protected String user;

  protected V1Context() { }

  /**
   * Gets the cluster.
   *
   * Cluster is the name of the cluster for this context.
   *
   * @return the cluster
   */
  public String getCluster() {
    return cluster;
  }

  /**
   * Gets the namespace.
   *
   * Namespace is the default namespace to use on unspecified requests
   * +optional.
   *
   * @return the namespace
   */
  public String getNamespace() {
    return namespace;
  }

  /**
   * Gets the user.
   *
   * AuthInfo is the name of the authInfo for this context.
   *
   * @return the user
   */
  public String getUser() {
    return user;
  }
}

