/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.CodeEngine;
import com.ibm.cloud.code_engine.code_engine.v2.model.Job;
import com.ibm.cloud.code_engine.code_engine.v2.model.JobList;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListJobsOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class JobsPager {
    protected boolean hasNext;
    protected ListJobsOptions options;
    protected CodeEngine client;
    protected PageContext pageContext;

    protected JobsPager() {
    }

    public JobsPager(CodeEngine client, ListJobsOptions options) {
        if (options.start() != null) {
            throw new IllegalArgumentException("The options 'start' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<Job> getNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListJobsOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.start(this.pageContext.getNext());
        }
        this.options = builder.build();
        JobList result = (JobList)((Object)this.client.listJobs(this.options).execute().getResult());
        String next = null;
        if (result.getNext() != null) {
            next = result.getNext().getStart();
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getJobs();
    }

    public List<Job> getAll() {
        ArrayList<Job> results = new ArrayList<Job>();
        while (this.hasNext()) {
            List<Job> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private String next;

        private PageContext() {
        }

        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }
}

