/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.model.ComponentRef;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class CreateBindingOptions
extends GenericModel {
    protected String projectId;
    protected ComponentRef component;
    protected String prefix;
    protected String secretName;

    protected CreateBindingOptions() {
    }

    protected CreateBindingOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notNull((Object)((Object)builder.component), (String)"component cannot be null");
        Validator.notNull((Object)builder.prefix, (String)"prefix cannot be null");
        Validator.notNull((Object)builder.secretName, (String)"secretName cannot be null");
        this.projectId = builder.projectId;
        this.component = builder.component;
        this.prefix = builder.prefix;
        this.secretName = builder.secretName;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public ComponentRef component() {
        return this.component;
    }

    public String prefix() {
        return this.prefix;
    }

    public String secretName() {
        return this.secretName;
    }

    public static class Builder {
        private String projectId;
        private ComponentRef component;
        private String prefix;
        private String secretName;

        private Builder(CreateBindingOptions createBindingOptions) {
            this.projectId = createBindingOptions.projectId;
            this.component = createBindingOptions.component;
            this.prefix = createBindingOptions.prefix;
            this.secretName = createBindingOptions.secretName;
        }

        public Builder() {
        }

        public Builder(String projectId, ComponentRef component, String prefix, String secretName) {
            this.projectId = projectId;
            this.component = component;
            this.prefix = prefix;
            this.secretName = secretName;
        }

        public CreateBindingOptions build() {
            return new CreateBindingOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder component(ComponentRef component) {
            this.component = component;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder secretName(String secretName) {
            this.secretName = secretName;
            return this;
        }
    }
}

