/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.model.EnvVarPrototype;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateFunctionOptions
extends GenericModel {
    protected String projectId;
    protected String codeReference;
    protected String name;
    protected String runtime;
    protected Boolean codeBinary;
    protected String codeMain;
    protected String codeSecret;
    protected String managedDomainMappings;
    protected Boolean runComputeResourceTokenEnabled;
    protected List<EnvVarPrototype> runEnvVariables;
    protected Long scaleConcurrency;
    protected String scaleCpuLimit;
    protected Long scaleDownDelay;
    protected Long scaleMaxExecutionTime;
    protected String scaleMemoryLimit;

    protected CreateFunctionOptions() {
    }

    protected CreateFunctionOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notNull((Object)builder.codeReference, (String)"codeReference cannot be null");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.runtime, (String)"runtime cannot be null");
        this.projectId = builder.projectId;
        this.codeReference = builder.codeReference;
        this.name = builder.name;
        this.runtime = builder.runtime;
        this.codeBinary = builder.codeBinary;
        this.codeMain = builder.codeMain;
        this.codeSecret = builder.codeSecret;
        this.managedDomainMappings = builder.managedDomainMappings;
        this.runComputeResourceTokenEnabled = builder.runComputeResourceTokenEnabled;
        this.runEnvVariables = builder.runEnvVariables;
        this.scaleConcurrency = builder.scaleConcurrency;
        this.scaleCpuLimit = builder.scaleCpuLimit;
        this.scaleDownDelay = builder.scaleDownDelay;
        this.scaleMaxExecutionTime = builder.scaleMaxExecutionTime;
        this.scaleMemoryLimit = builder.scaleMemoryLimit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String codeReference() {
        return this.codeReference;
    }

    public String name() {
        return this.name;
    }

    public String runtime() {
        return this.runtime;
    }

    public Boolean codeBinary() {
        return this.codeBinary;
    }

    public String codeMain() {
        return this.codeMain;
    }

    public String codeSecret() {
        return this.codeSecret;
    }

    public String managedDomainMappings() {
        return this.managedDomainMappings;
    }

    public Boolean runComputeResourceTokenEnabled() {
        return this.runComputeResourceTokenEnabled;
    }

    public List<EnvVarPrototype> runEnvVariables() {
        return this.runEnvVariables;
    }

    public Long scaleConcurrency() {
        return this.scaleConcurrency;
    }

    public String scaleCpuLimit() {
        return this.scaleCpuLimit;
    }

    public Long scaleDownDelay() {
        return this.scaleDownDelay;
    }

    public Long scaleMaxExecutionTime() {
        return this.scaleMaxExecutionTime;
    }

    public String scaleMemoryLimit() {
        return this.scaleMemoryLimit;
    }

    public static class Builder {
        private String projectId;
        private String codeReference;
        private String name;
        private String runtime;
        private Boolean codeBinary;
        private String codeMain;
        private String codeSecret;
        private String managedDomainMappings;
        private Boolean runComputeResourceTokenEnabled;
        private List<EnvVarPrototype> runEnvVariables;
        private Long scaleConcurrency;
        private String scaleCpuLimit;
        private Long scaleDownDelay;
        private Long scaleMaxExecutionTime;
        private String scaleMemoryLimit;

        private Builder(CreateFunctionOptions createFunctionOptions) {
            this.projectId = createFunctionOptions.projectId;
            this.codeReference = createFunctionOptions.codeReference;
            this.name = createFunctionOptions.name;
            this.runtime = createFunctionOptions.runtime;
            this.codeBinary = createFunctionOptions.codeBinary;
            this.codeMain = createFunctionOptions.codeMain;
            this.codeSecret = createFunctionOptions.codeSecret;
            this.managedDomainMappings = createFunctionOptions.managedDomainMappings;
            this.runComputeResourceTokenEnabled = createFunctionOptions.runComputeResourceTokenEnabled;
            this.runEnvVariables = createFunctionOptions.runEnvVariables;
            this.scaleConcurrency = createFunctionOptions.scaleConcurrency;
            this.scaleCpuLimit = createFunctionOptions.scaleCpuLimit;
            this.scaleDownDelay = createFunctionOptions.scaleDownDelay;
            this.scaleMaxExecutionTime = createFunctionOptions.scaleMaxExecutionTime;
            this.scaleMemoryLimit = createFunctionOptions.scaleMemoryLimit;
        }

        public Builder() {
        }

        public Builder(String projectId, String codeReference, String name, String runtime) {
            this.projectId = projectId;
            this.codeReference = codeReference;
            this.name = name;
            this.runtime = runtime;
        }

        public CreateFunctionOptions build() {
            return new CreateFunctionOptions(this);
        }

        public Builder addRunEnvVariables(EnvVarPrototype runEnvVariables) {
            Validator.notNull((Object)((Object)runEnvVariables), (String)"runEnvVariables cannot be null");
            if (this.runEnvVariables == null) {
                this.runEnvVariables = new ArrayList<EnvVarPrototype>();
            }
            this.runEnvVariables.add(runEnvVariables);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder codeReference(String codeReference) {
            this.codeReference = codeReference;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        public Builder codeBinary(Boolean codeBinary) {
            this.codeBinary = codeBinary;
            return this;
        }

        public Builder codeMain(String codeMain) {
            this.codeMain = codeMain;
            return this;
        }

        public Builder codeSecret(String codeSecret) {
            this.codeSecret = codeSecret;
            return this;
        }

        public Builder managedDomainMappings(String managedDomainMappings) {
            this.managedDomainMappings = managedDomainMappings;
            return this;
        }

        public Builder runComputeResourceTokenEnabled(Boolean runComputeResourceTokenEnabled) {
            this.runComputeResourceTokenEnabled = runComputeResourceTokenEnabled;
            return this;
        }

        public Builder runEnvVariables(List<EnvVarPrototype> runEnvVariables) {
            this.runEnvVariables = runEnvVariables;
            return this;
        }

        public Builder scaleConcurrency(long scaleConcurrency) {
            this.scaleConcurrency = scaleConcurrency;
            return this;
        }

        public Builder scaleCpuLimit(String scaleCpuLimit) {
            this.scaleCpuLimit = scaleCpuLimit;
            return this;
        }

        public Builder scaleDownDelay(long scaleDownDelay) {
            this.scaleDownDelay = scaleDownDelay;
            return this;
        }

        public Builder scaleMaxExecutionTime(long scaleMaxExecutionTime) {
            this.scaleMaxExecutionTime = scaleMaxExecutionTime;
            return this;
        }

        public Builder scaleMemoryLimit(String scaleMemoryLimit) {
            this.scaleMemoryLimit = scaleMemoryLimit;
            return this;
        }
    }

    public static interface ManagedDomainMappings {
        public static final String LOCAL = "local";
        public static final String LOCAL_PRIVATE = "local_private";
        public static final String LOCAL_PUBLIC = "local_public";
    }
}

