/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.model.StorageData;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class CreatePersistentDataStoreOptions
extends GenericModel {
    protected String projectId;
    protected String name;
    protected String storageType;
    protected StorageData data;

    protected CreatePersistentDataStoreOptions() {
    }

    protected CreatePersistentDataStoreOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.storageType, (String)"storageType cannot be null");
        this.projectId = builder.projectId;
        this.name = builder.name;
        this.storageType = builder.storageType;
        this.data = builder.data;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String name() {
        return this.name;
    }

    public String storageType() {
        return this.storageType;
    }

    public StorageData data() {
        return this.data;
    }

    public static class Builder {
        private String projectId;
        private String name;
        private String storageType;
        private StorageData data;

        private Builder(CreatePersistentDataStoreOptions createPersistentDataStoreOptions) {
            this.projectId = createPersistentDataStoreOptions.projectId;
            this.name = createPersistentDataStoreOptions.name;
            this.storageType = createPersistentDataStoreOptions.storageType;
            this.data = createPersistentDataStoreOptions.data;
        }

        public Builder() {
        }

        public Builder(String projectId, String name, String storageType) {
            this.projectId = projectId;
            this.name = name;
            this.storageType = storageType;
        }

        public CreatePersistentDataStoreOptions build() {
            return new CreatePersistentDataStoreOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder data(StorageData data) {
            this.data = data;
            return this;
        }
    }

    public static interface StorageType {
        public static final String OBJECT_STORAGE = "object_storage";
    }
}

