/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.CodeEngine;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListPersistentDataStoreOptions;
import com.ibm.cloud.code_engine.code_engine.v2.model.PersistentDataStore;
import com.ibm.cloud.code_engine.code_engine.v2.model.PersistentDataStoreList;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class PersistentDataStorePager {
    protected boolean hasNext;
    protected ListPersistentDataStoreOptions options;
    protected CodeEngine client;
    protected PageContext pageContext;

    protected PersistentDataStorePager() {
    }

    public PersistentDataStorePager(CodeEngine client, ListPersistentDataStoreOptions options) {
        if (options.start() != null) {
            throw new IllegalArgumentException("The options 'start' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<PersistentDataStore> getNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListPersistentDataStoreOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.start(this.pageContext.getNext());
        }
        this.options = builder.build();
        PersistentDataStoreList result = (PersistentDataStoreList)((Object)this.client.listPersistentDataStore(this.options).execute().getResult());
        String next = null;
        if (result.getNext() != null) {
            next = result.getNext().getStart();
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getPersistentDataStores();
    }

    public List<PersistentDataStore> getAll() {
        ArrayList<PersistentDataStore> results = new ArrayList<PersistentDataStore>();
        while (this.hasNext()) {
            List<PersistentDataStore> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private String next;

        private PageContext() {
        }

        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }
}

