/*
 * (C) Copyright IBM Corp. 2025.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;

/**
 * Describes the model of the enforcement status of a CBR status.
 */
public class EnforcementStatus extends GenericModel {

  public interface Enforcement {
    /** applied. */
    String APPLIED = "applied";
    /** out_of_sync. */
    String OUT_OF_SYNC = "out_of_sync";
    /** none. */
    String NONE = "none";
    /** unknown. */
    String UNKNOWN = "unknown";
  }

  protected String enforcement;
  @SerializedName("last_synced_at")
  protected String lastSyncedAt;

  protected EnforcementStatus() { }

  /**
   * Gets the enforcement.
   *
   * @return the enforcement
   */
  public String getEnforcement() {
    return enforcement;
  }

  /**
   * Gets the lastSyncedAt.
   *
   * @return the lastSyncedAt
   */
  public String getLastSyncedAt() {
    return lastSyncedAt;
  }
}

