/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.Map;

public class ReplaceSecretOptions
extends GenericModel {
    protected String projectId;
    protected String name;
    protected String ifMatch;
    protected Map<String, String> data;
    protected String format;

    protected ReplaceSecretOptions() {
    }

    protected ReplaceSecretOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.name, (String)"name cannot be empty");
        Validator.notNull((Object)builder.ifMatch, (String)"ifMatch cannot be null");
        this.projectId = builder.projectId;
        this.name = builder.name;
        this.ifMatch = builder.ifMatch;
        this.data = builder.data;
        this.format = builder.format;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String name() {
        return this.name;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public Map<String, String> data() {
        return this.data;
    }

    public String format() {
        return this.format;
    }

    public static class Builder {
        private String projectId;
        private String name;
        private String ifMatch;
        private Map<String, String> data;
        private String format;

        private Builder(ReplaceSecretOptions replaceSecretOptions) {
            this.projectId = replaceSecretOptions.projectId;
            this.name = replaceSecretOptions.name;
            this.ifMatch = replaceSecretOptions.ifMatch;
            this.data = replaceSecretOptions.data;
            this.format = replaceSecretOptions.format;
        }

        public Builder() {
        }

        public Builder(String projectId, String name, String ifMatch) {
            this.projectId = projectId;
            this.name = name;
            this.ifMatch = ifMatch;
        }

        public ReplaceSecretOptions build() {
            return new ReplaceSecretOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder data(Map<String, String> data) {
            this.data = data;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }
    }

    public static interface Format {
        public static final String GENERIC = "generic";
        public static final String SSH_AUTH = "ssh_auth";
        public static final String BASIC_AUTH = "basic_auth";
        public static final String TLS = "tls";
        public static final String SERVICE_ACCESS = "service_access";
        public static final String REGISTRY = "registry";
        public static final String OTHER = "other";
    }
}

