/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.http;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.protocol.HttpContext;

public final class SNISSLConnectionSocketFactory {
    private static Logger LOG = Logger.getLogger(SNISSLConnectionSocketFactory.class.getName());
    private static final SNISSLConnectionSocketFactory singleton = new SNISSLConnectionSocketFactory();
    private LayeredConnectionSocketFactory sslSocketFactory;

    private SNISSLConnectionSocketFactory() {
        SSLContext sslcontext = SSLContexts.createSystemDefault();
        this.sslSocketFactory = new SSLConnectionSocketFactory(sslcontext){

            public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
                if (socket instanceof SSLSocket) {
                    try {
                        Method method = socket.getClass().getMethod("a", String.class);
                        method.invoke((Object)socket, host.getHostName());
                    }
                    catch (Exception e) {
                        LOG.log(Level.FINE, "not an IBM JDK 7, ignoring SNI workaround");
                    }
                }
                ConnectException ex = null;
                for (int i = 1; i < 4; ++i) {
                    try {
                        return super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
                    }
                    catch (ConnectException ex1) {
                        ex = ex1;
                        LOG.log(Level.WARNING, "Exception connecting to DoCloud: '{0}'. Retrying ({1})...", new Object[]{ex.getMessage(), i});
                        continue;
                    }
                }
                throw ex;
            }
        };
    }

    public static LayeredConnectionSocketFactory getSSLSocketFactory() {
        return SNISSLConnectionSocketFactory.singleton.sslSocketFactory;
    }
}

