/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.impl;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageHandler {
    public static final String MESSAGE_PREFIX = "message.prefix";
    public static final String KEY_CODE_SUFFIX = ".code";
    public static final String KEY_DESCRIPTION_SUFFIX = ".description";
    private static final Logger logger = Logger.getLogger(MessageHandler.class.getName());
    private final String bundleName;
    private final boolean safeMode;
    private final ClassLoader loader;

    public MessageHandler(String bundleName) {
        this(bundleName, true, null);
    }

    public MessageHandler(String bundleName, ClassLoader loader) {
        this(bundleName, true, loader);
    }

    public MessageHandler(String bundleName, boolean safeMode, ClassLoader loader) {
        this.bundleName = bundleName;
        this.safeMode = safeMode;
        this.loader = loader;
    }

    private static ULocale getLocale(String localeName) {
        if (localeName == null || localeName.trim().length() < 1) {
            return ULocale.getDefault();
        }
        try {
            return new ULocale(localeName.trim());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to create locale " + localeName + " : " + e.getLocalizedMessage(), e);
            logger.log(Level.WARNING, "Use default locale " + ULocale.getDefault().getDisplayName());
            return ULocale.getDefault();
        }
    }

    private ResourceBundle getBundle(ULocale locale, String bundleName) {
        try {
            if (locale != null) {
                if (this.loader == null) {
                    return ResourceBundle.getBundle(bundleName, locale.toLocale());
                }
                return ResourceBundle.getBundle(bundleName, locale.toLocale(), this.loader);
            }
            if (this.loader == null) {
                return ResourceBundle.getBundle(bundleName);
            }
            return ResourceBundle.getBundle(bundleName, Locale.getDefault(), this.loader);
        }
        catch (RuntimeException e) {
            if (!this.safeMode) {
                throw e;
            }
            logger.log(Level.SEVERE, "Failed to find resource bundle: " + bundleName, e);
            return null;
        }
    }

    public ResourceBundle getResourceBundle(String localeName) {
        ULocale locale = MessageHandler.getLocale(localeName);
        return this.getBundle(locale, this.bundleName);
    }

    private String prefixMessage(ResourceBundle bundle, String key) {
        String value = bundle.getString(key);
        String prefix = null;
        try {
            prefix = bundle.getString(MESSAGE_PREFIX);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String code = null;
        try {
            code = bundle.getString(key + KEY_CODE_SUFFIX);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder msg = new StringBuilder();
        if (prefix != null) {
            msg.append(prefix.trim());
        }
        if (code != null) {
            for (int i = code.trim().length(); i < 5; ++i) {
                msg.append('0');
            }
            msg.append(code.trim());
        }
        if (msg.length() > 0) {
            msg.append(": ");
        }
        msg.append(value);
        return msg.toString();
    }

    public String getLocalizedMessageWithLocale(String localeName, String key, Object ... args) {
        String value = null;
        ResourceBundle bundle = this.getResourceBundle(localeName);
        if (bundle != null) {
            try {
                value = this.prefixMessage(bundle, key);
            }
            catch (RuntimeException e) {
                if (!this.safeMode) {
                    throw e;
                }
                logger.log(Level.WARNING, "Failed to find resource key: " + key);
            }
        }
        if (value == null) {
            StringBuilder v = new StringBuilder();
            if (bundle == null) {
                v.append('!');
                v.append(this.bundleName);
                v.append(": ");
            }
            v.append(key);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    v.append(" {");
                    v.append(i);
                    v.append('}');
                }
            }
            value = v.toString();
        }
        if (args != null && args.length > 0) {
            return MessageFormat.format((String)value, (Object[])args);
        }
        return value;
    }

    public String getLocalizedMessage(String key, Object ... args) {
        return this.getLocalizedMessageWithLocale(null, key, args);
    }
}

