/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ibm.optim.oaas.client.InternalException;
import com.ibm.optim.oaas.client.InvalidClientIdException;
import com.ibm.optim.oaas.client.InvalidParameterException;
import com.ibm.optim.oaas.client.OaasRuntimeException;
import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.ParsingException;
import com.ibm.optim.oaas.client.ResourceAccessException;
import com.ibm.optim.oaas.client.SecurityException;
import com.ibm.optim.oaas.client.ServerExceptionData;
import com.ibm.optim.oaas.client.impl.ClientMessageCodes;
import com.ibm.optim.oaas.client.impl.DeletionResponseImpl;
import com.ibm.optim.oaas.client.impl.DeletionStatus;
import com.ibm.optim.oaas.client.impl.ServerExceptionDataImpl;
import com.ibm.optim.oaas.client.job.UndefinedSubscriptionException;
import com.ibm.optim.oaas.client.job.impl.JobMessageCodes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class RestClient {
    private static final long GZIP_CONTENT_LENGTH_THRESHOLD = 512L;
    private static final Logger logger = Logger.getLogger(RestClient.class.getName());
    private static final Level logLevel = Level.FINE;
    protected final String server_url;
    private String authToken;
    private String clientid;
    private String secret;
    protected final CloseableHttpClient httpClient;
    protected final ObjectMapper mapper;
    protected boolean compression = true;
    protected int retryOn413Secs = 0;

    public RestClient(CloseableHttpClient client, String url, String token) {
        if (url != null) {
            url = url.trim();
        }
        if (url != null && !url.endsWith("/")) {
            url = url + "/";
        }
        this.server_url = url;
        this.httpClient = client;
        this.mapper = new ObjectMapper();
        this.authToken = token;
    }

    public RestClient(CloseableHttpClient client, String url, String clientid, String secret) {
        if (url != null) {
            url = url.trim();
        }
        if (url != null && !url.endsWith("/")) {
            url = url + "/";
        }
        this.server_url = url;
        this.httpClient = client;
        this.mapper = new ObjectMapper();
        this.clientid = clientid;
        this.secret = secret;
    }

    public String getBaseUrl() {
        return this.server_url;
    }

    public boolean isCompressionEnabled() {
        return this.compression;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    protected HttpClientContext getHttpContext() {
        HttpClientContext context = HttpClientContext.create();
        return context;
    }

    protected void setJsonMedia(HttpRequestBase request) {
        request.addHeader("Accept", "application/json");
        if (!request.getMethod().equalsIgnoreCase("DELETE")) {
            request.addHeader("Content-Type", "application/json");
        }
    }

    protected void setTextMedia(HttpRequestBase request) {
        request.addHeader("Accept", "text/plain");
        request.addHeader("Content-Type", "text/plain");
    }

    private void setOptionalCompressedEntity(HttpEntityEnclosingRequestBase request, HttpEntity entity) {
        if (this.compression && (entity.getContentLength() < 0L || entity.getContentLength() > 512L)) {
            GzipCompressingEntity gzipped = new GzipCompressingEntity(entity);
            if (logger.isLoggable(logLevel)) {
                logger.log(logLevel, request.getURI().toASCIIString() + ": compressing json entity " + this.toString((HttpEntity)gzipped));
            }
            request.setEntity((HttpEntity)gzipped);
        } else {
            if (logger.isLoggable(logLevel)) {
                logger.log(logLevel, request.getURI().toASCIIString() + ": not compressing json entity " + this.toString(entity));
            }
            request.setEntity(entity);
        }
    }

    private String toString(HttpEntity entity) {
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        this.put(obj, entity.getContentEncoding());
        this.put(obj, entity.getContentType());
        return obj.toString();
    }

    protected void setJsonEntity(HttpEntityEnclosingRequestBase request, Object obj) throws OperationException {
        try {
            this.setOptionalCompressedEntity(request, (HttpEntity)new StringEntity(this.mapper.writeValueAsString(obj), "UTF-8"));
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    protected void setTextEntity(HttpEntityEnclosingRequestBase request, String obj) throws OperationException {
        try {
            this.setOptionalCompressedEntity(request, (HttpEntity)new StringEntity(obj, "UTF-8"));
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    protected String createResource(String path) {
        return this.server_url + path;
    }

    protected String getIdFromLocation(CloseableHttpResponse response) {
        String value;
        int index;
        Header header = response.getFirstHeader("Location");
        if (header != null && (index = (value = header.toString()).lastIndexOf("/")) != -1) {
            return value.substring(index + 1);
        }
        return null;
    }

    protected void handleStatus(HttpRequestBase request, CloseableHttpResponse response) throws OperationException {
        try {
            this.handleStatusImpl(request, response);
        }
        catch (OperationException e) {
            ServerExceptionData data = e.getServerExceptionData();
            if (data != null) {
                if (ClientMessageCodes.AKCJC5004E_PARSING_EXCEPTION.name().equals(data.getCode())) {
                    throw new ParsingException(e, e.getServerExceptionData().getMessage());
                }
                if (ClientMessageCodes.AKCJC5005E_INVALID_PARAMETER_EXCEPTION.name().equals(data.getCode())) {
                    throw new InvalidParameterException(data.getParameters().toArray(), e);
                }
                if (ClientMessageCodes.AKCJC5047E_INVALID_CLIENT_ID_EXCEPTION.name().equals(data.getCode())) {
                    throw new InvalidClientIdException(data.getParameters().toArray(), e);
                }
                if (ClientMessageCodes.AKCJC5040E_NOT_ALLOWED_EXCEPTION.name().equals(data.getCode())) {
                    throw new ResourceAccessException(data.getParameters().toArray(), e);
                }
                if (JobMessageCodes.AKCJC5110E_UNDEFINED_SUBSCRIPTION_EXCEPTION.name().equals(data.getCode())) {
                    throw new UndefinedSubscriptionException(data.getParameters().toArray(), e);
                }
                if (ClientMessageCodes.AKCJC5041E_TOKEN_NOT_PROVIDED.name().equals(data.getCode())) {
                    throw new SecurityException(ClientMessageCodes.AKCJC5041E_TOKEN_NOT_PROVIDED.name(), (Throwable)e, data.getParameters().toArray());
                }
            }
            throw e;
        }
    }

    protected void handleStatusImpl(HttpRequestBase request, CloseableHttpResponse response) throws OperationException {
        boolean isException;
        String gatewayMessage = null;
        ServerExceptionData ex = null;
        Header exceptionHeader = response.getFirstHeader(ServerExceptionDataImpl.HTTP_X_EXCEPTION);
        boolean bl = isException = exceptionHeader != null && !exceptionHeader.getValue().isEmpty() && exceptionHeader.getValue().equalsIgnoreCase("true") && response.getEntity() != null;
        if (isException) {
            try {
                ex = (ServerExceptionData)this.mapper.readValue(response.getEntity().getContent(), ServerExceptionDataImpl.class);
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
            }
        } else if (response.getEntity() != null) {
            String content = null;
            try {
                JsonNode json;
                content = EntityUtils.toString((HttpEntity)response.getEntity());
                if (content != null && content.length() != 0 && (json = this.mapper.readTree(content)) != null && json.get("moreInformation") != null) {
                    gatewayMessage = json.get("moreInformation").asText();
                }
            }
            catch (IOException | ParseException e) {
                logger.warning("Failed to parse json entity on error: " + e.getLocalizedMessage());
                logger.fine(content);
            }
        }
        if (gatewayMessage != null) {
            ClientMessageCodes.AKCJC5010E_OPERATION_GATEWAY_EXCEPTION.log(response.getStatusLine().getStatusCode(), request.getMethod(), request.getURI().toString(), gatewayMessage);
            throw new OperationException(request.getMethod(), request.getURI().toString(), response.getStatusLine().getStatusCode(), gatewayMessage);
        }
        ClientMessageCodes.AKCJC5001E_OPERATION_EXCEPTION.log(response.getStatusLine().getStatusCode(), request.getMethod(), request.getURI().toString());
        throw new OperationException(request.getMethod(), request.getURI().toString(), response.getStatusLine().getStatusCode(), ex);
    }

    protected String buildURI(String uri, Object ... params) throws OperationException {
        try {
            URIBuilder builder = new URIBuilder(uri);
            int i = 0;
            while (i + 1 < params.length) {
                if (params[i + 1] != null) {
                    builder.addParameter(params[i].toString(), params[i + 1].toString());
                }
                i += 2;
            }
            return builder.build().toString();
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <E> E getList(String uri, TypeReference<E> type) throws OperationException {
        HttpGet request = new HttpGet(uri);
        this.setJsonMedia((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    if (response.getEntity() != null) {
                        Object object = this.mapper.readValue(response.getEntity().getContent(), type);
                        return (E)object;
                    }
                    E e = null;
                    return e;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            E e = null;
            return e;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <E> E getList(String uri, TypeReference<E> type, E defaultValue) throws OperationException {
        HttpGet request = new HttpGet(uri);
        this.setJsonMedia((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    if (response.getEntity() != null) {
                        Object object = this.mapper.readValue(response.getEntity().getContent(), type);
                        return (E)object;
                    }
                    E e = null;
                    return e;
                }
                case 204: {
                    E e = defaultValue;
                    return e;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            E e = null;
            return e;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <E> E get(String uri, TypeReference<E> type, boolean mustExists) throws OperationException {
        HttpGet request = new HttpGet(uri);
        this.setJsonMedia((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    if (response.getEntity() != null) {
                        Object object = this.mapper.readValue(response.getEntity().getContent(), type);
                        return (E)object;
                    }
                    E e = null;
                    return e;
                }
                case 404: {
                    if (mustExists) break;
                    E e = null;
                    return e;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            E e = null;
            return e;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <E> E get(String uri, Class<E> type, boolean mustExists) throws OperationException {
        HttpGet request = new HttpGet(uri);
        this.setJsonMedia((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    if (response.getEntity() != null) {
                        Object object = this.mapper.readValue(response.getEntity().getContent(), type);
                        return (E)object;
                    }
                    E e = null;
                    return e;
                }
                case 204: 
                case 404: {
                    if (mustExists) break;
                    E e = null;
                    return e;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            E e = null;
            return e;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return null;
        }
    }

    protected void put(String uri, Object obj) throws OperationException {
        HttpPut request = new HttpPut(uri);
        this.setJsonMedia((HttpRequestBase)request);
        if (obj != null) {
            this.setJsonEntity((HttpEntityEnclosingRequestBase)request, obj);
        }
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 204: {
                    return;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            return;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return;
        }
    }

    protected void putText(String uri, String obj) throws OperationException {
        HttpPut request = new HttpPut(uri);
        this.setTextMedia((HttpRequestBase)request);
        if (obj != null) {
            this.setTextEntity((HttpEntityEnclosingRequestBase)request, obj);
        }
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 204: {
                    return;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            return;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return;
        }
    }

    protected void post(String uri, Object obj) throws OperationException {
        HttpPost request = new HttpPost(uri);
        this.setJsonMedia((HttpRequestBase)request);
        if (obj != null) {
            this.setJsonEntity((HttpEntityEnclosingRequestBase)request, obj);
        }
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 204: {
                    return;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            return;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String createMultiPart(String uri, String[] name, String[] filename, boolean[] asJson, Object[] obj) throws OperationException {
        HttpPost request = new HttpPost(uri);
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (int i = 0; i < name.length; ++i) {
                if (obj[i] == null) continue;
                if (asJson[i]) {
                    builder.addTextBody(name[i], this.mapper.writeValueAsString(obj[i]), ContentType.create((String)"text/plain", (Charset)Charset.forName("UTF-8")));
                    continue;
                }
                if (obj[i] instanceof File) {
                    builder.addBinaryBody(name[i], (File)obj[i], ContentType.APPLICATION_OCTET_STREAM, filename[i]);
                    continue;
                }
                if (!(obj[i] instanceof InputStream)) continue;
                builder.addBinaryBody(name[i], (InputStream)obj[i], ContentType.APPLICATION_OCTET_STREAM, filename[i]);
            }
            this.setOptionalCompressedEntity((HttpEntityEnclosingRequestBase)request, builder.build());
            try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
                switch (response.getStatusLine().getStatusCode()) {
                    case 201: {
                        String id = this.getIdFromLocation(response);
                        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                        String string = id;
                        return string;
                    }
                }
                this.handleStatus((HttpRequestBase)request, response);
                String string = null;
                return string;
            }
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return null;
        }
    }

    protected void postText(String uri, String obj) throws OperationException {
        HttpPost request = new HttpPost(uri);
        this.setTextMedia((HttpRequestBase)request);
        if (obj != null) {
            this.setTextEntity((HttpEntityEnclosingRequestBase)request, obj);
        }
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 204: {
                    return;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            return;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return;
        }
    }

    protected void throwOperationException(HttpUriRequest request, Exception e) throws OperationException {
        if (e instanceof OaasRuntimeException) {
            throw (OaasRuntimeException)e;
        }
        ClientMessageCodes.AKCJC5001E_OPERATION_EXCEPTION.log(0, request.getMethod(), request.getURI().toString());
        throw new OperationException(request.getMethod(), request.getURI().toString(), 0, e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String create(String uri, Object obj) throws OperationException {
        HttpPost request = new HttpPost(uri);
        this.setJsonMedia((HttpRequestBase)request);
        if (obj != null) {
            this.setJsonEntity((HttpEntityEnclosingRequestBase)request, obj);
        }
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 201: {
                    String id = this.getIdFromLocation(response);
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                    String string = id;
                    return string;
                }
                case 413: {
                    if (this.retryOn413Secs <= 0) break;
                    response.addHeader("Retry-After", Integer.toString(this.retryOn413Secs));
                    break;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            String string = null;
            return string;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return null;
        }
    }

    private String toString(HttpUriRequest request) {
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.put("method", request.getMethod());
        obj.put("uri", request.getURI().toASCIIString());
        if (request instanceof HttpEntityEnclosingRequestBase) {
            ObjectNode e = JsonNodeFactory.instance.objectNode();
            HttpEntityEnclosingRequestBase req = (HttpEntityEnclosingRequestBase)request;
            if (req.getEntity() != null) {
                this.put(e, req.getEntity().getContentEncoding());
                this.put(e, req.getEntity().getContentType());
                obj.set("entity", (JsonNode)e);
            }
        }
        for (Header header : request.getAllHeaders()) {
            this.put(obj, header);
        }
        return obj.toString();
    }

    private void put(ObjectNode obj, Header header) {
        if (header != null) {
            obj.put(header.getName(), header.getValue());
        }
    }

    protected void delete(String uri) throws OperationException {
        HttpDelete request = new HttpDelete(uri);
        this.setJsonMedia((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 200: 
                case 204: 
                case 404: {
                    return;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            return;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DeletionStatus deleteWithStatus(String uri) throws OperationException {
        HttpDelete request = new HttpDelete(uri);
        this.setJsonMedia((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 204: 
                case 404: {
                    DeletionStatus deletionStatus = null;
                    return deletionStatus;
                }
                case 200: {
                    if (response.getEntity() == null) break;
                    DeletionStatus deletionStatus = ((DeletionResponseImpl)this.mapper.readValue(response.getEntity().getContent(), DeletionResponseImpl.class)).getStatus();
                    return deletionStatus;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            DeletionStatus deletionStatus = null;
            return deletionStatus;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void getFile(String uri, File archive) throws IOException, OperationException {
        request = new HttpGet(uri);
        request.addHeader("Accept", "application/octet-stream");
        try {
            response = this.execute((HttpUriRequest)request);
            var5_7 = null;
            try {
                switch (response.getStatusLine().getStatusCode()) {
                    case 200: {
                        os = new BufferedOutputStream(new FileOutputStream(archive));
                        is = null;
                        try {
                            is = response.getEntity().getContent();
                            buffer = new byte[1024];
                            while ((length = is.read(buffer)) > 0) {
                                os.write(buffer, 0, length);
                            }
                            if (is == null) ** GOTO lbl19
                        }
                        catch (EOFException var8_13) {
                            if (is != null) {
                                is.close();
                            }
                            if (os != null) {
                                os.close();
                                ** break;
                            }
lbl29:
                            // 3 sources

                            break;
                            catch (Throwable var10_15) {
                                if (is != null) {
                                    is.close();
                                }
                                if (os != null) {
                                    os.close();
                                }
                                throw var10_15;
                            }
                        }
                        is.close();
lbl19:
                        // 2 sources

                        if (os != null) {
                            os.close();
                            ** break;
                        }
lbl22:
                        // 3 sources

                        break;
                    }
                    default: {
                        this.handleStatus((HttpRequestBase)request, response);
                        break;
                    }
                }
            }
            catch (Throwable var6_10) {
                var5_7 = var6_10;
                throw var6_10;
            }
            finally {
                if (response != null) {
                    if (var5_7 != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getStream(String uri, OutputStream ostream) throws IOException, OperationException {
        HttpGet request = new HttpGet(uri);
        request.addHeader("Accept", "application/octet-stream");
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    BufferedOutputStream os = new BufferedOutputStream(ostream);
                    InputStream is = null;
                    try {
                        int length;
                        is = response.getEntity().getContent();
                        byte[] buffer = new byte[1024];
                        while ((length = is.read(buffer)) > 0) {
                            ((OutputStream)os).write(buffer, 0, length);
                        }
                        break;
                    }
                    finally {
                        is.close();
                        ((OutputStream)os).close();
                    }
                }
                default: {
                    this.handleStatus((HttpRequestBase)request, response);
                    break;
                }
            }
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getStream(String uri, String mediaType) throws IOException, OperationException {
        HttpGet request = new HttpGet(uri);
        request.addHeader("Accept", mediaType);
        try (CloseableHttpResponse response = null;){
            response = this.execute((HttpUriRequest)request);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    CloseResponseInputStream res = new CloseResponseInputStream(response.getEntity().getContent(), response);
                    response = null;
                    CloseResponseInputStream closeResponseInputStream = res;
                    return closeResponseInputStream;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            InputStream inputStream = null;
            return inputStream;
        }
    }

    protected InputStream getStream(String uri) throws IOException, OperationException {
        return this.getStream(uri, "application/octet-stream");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T getStream(String uri, ObjectMapper mapper, TypeReference<T> type) throws IOException, OperationException {
        HttpGet request = new HttpGet(uri);
        request.addHeader("Accept", "application/octet-stream");
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    Object object = mapper.readValue(response.getEntity().getContent(), type);
                    return (T)object;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            T t = null;
            return t;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T getStream(String uri, ObjectMapper mapper, Class<T> type) throws IOException, OperationException {
        HttpGet request = new HttpGet(uri);
        request.addHeader("Accept", "application/octet-stream");
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    Object object = mapper.readValue(response.getEntity().getContent(), type);
                    return (T)object;
                }
            }
            this.handleStatus((HttpRequestBase)request, response);
            T t = null;
            return t;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return null;
        }
    }

    protected CloseableHttpResponse execute(HttpUriRequest req) throws ClientProtocolException, IOException {
        if (logger.isLoggable(logLevel)) {
            logger.log(logLevel, "Executing request: " + this.toString(req));
        }
        if (this.authToken != null) {
            req.setHeader("Authorization", this.authToken);
        }
        if (this.clientid != null) {
            req.setHeader("X-IBM-Client-Id", this.clientid);
        }
        if (this.secret != null) {
            req.setHeader("X-IBM-Client-Secret", this.secret);
        }
        CloseableHttpResponse response = this.httpClient.execute(req);
        return response;
    }

    protected void putFile(String uri, File archive) throws OperationException {
        HttpPut request = new HttpPut(uri);
        try {
            request.addHeader("Content-Type", "application/octet-stream");
            this.setOptionalCompressedEntity((HttpEntityEnclosingRequestBase)request, (HttpEntity)new FileEntity(archive));
            try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
                switch (response.getStatusLine().getStatusCode()) {
                    case 204: {
                        return;
                    }
                }
                this.handleStatus((HttpRequestBase)request, response);
                return;
            }
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return;
        }
    }

    protected void putStream(String uri, InputStream is) throws OperationException {
        HttpPut request = new HttpPut(uri);
        try {
            request.addHeader("Content-Type", "application/octet-stream");
            this.setOptionalCompressedEntity((HttpEntityEnclosingRequestBase)request, (HttpEntity)new InputStreamEntity(is, -1L));
            try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
                switch (response.getStatusLine().getStatusCode()) {
                    case 204: {
                        return;
                    }
                }
                this.handleStatus((HttpRequestBase)request, response);
                return;
            }
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return;
        }
    }

    protected void putStream(String uri, ObjectMapper mapper, Object obj) throws OperationException {
        HttpPut request = new HttpPut(uri);
        try {
            request.addHeader("Content-Type", "application/octet-stream");
            this.setOptionalCompressedEntity((HttpEntityEnclosingRequestBase)request, (HttpEntity)new JsonEntity(mapper, obj));
            try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
                switch (response.getStatusLine().getStatusCode()) {
                    case 204: {
                        return;
                    }
                }
                this.handleStatus((HttpRequestBase)request, response);
                return;
            }
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return;
        }
    }

    static class JsonEntity
    extends AbstractHttpEntity {
        Object obj;
        ObjectMapper mapper;

        public JsonEntity(ObjectMapper mapper, Object obj) {
            this.obj = obj;
            this.mapper = mapper;
        }

        public boolean isRepeatable() {
            return true;
        }

        public long getContentLength() {
            return -1L;
        }

        public boolean isStreaming() {
            return false;
        }

        public InputStream getContent() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream outstream) throws IOException {
            this.mapper.writeValue(outstream, this.obj);
        }
    }

    private static class CloseResponseInputStream
    extends BufferedInputStream {
        CloseableHttpResponse _response;

        public CloseResponseInputStream(InputStream in, CloseableHttpResponse response) {
            super(in);
            this._response = response;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this._response.close();
        }
    }
}

