/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.job;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.job.AttachmentContentWriter;
import com.ibm.optim.oaas.client.job.AttachmentNotFoundException;
import com.ibm.optim.oaas.client.job.JobNotFoundException;
import com.ibm.optim.oaas.client.job.JobRequestBuilder;
import com.ibm.optim.oaas.client.job.SubscriptionException;
import com.ibm.optim.oaas.client.job.ValidationException;
import com.ibm.optim.oaas.client.job.model.Job;
import com.ibm.optim.oaas.client.job.model.JobAttachment;
import com.ibm.optim.oaas.client.job.model.JobAttachmentCreationData;
import com.ibm.optim.oaas.client.job.model.JobAttachmentType;
import com.ibm.optim.oaas.client.job.model.JobCreationData;
import com.ibm.optim.oaas.client.job.model.JobExecutionStatus;
import com.ibm.optim.oaas.client.job.model.JobFailureInfo;
import com.ibm.optim.oaas.client.job.model.JobLogItem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public interface JobClient {
    public void deleteAllJobs() throws OperationException;

    public List<? extends Job> getAllJobs() throws OperationException;

    public String createJob(JobCreationData var1) throws OperationException, SubscriptionException, ValidationException;

    public String copyJob(String var1, JobCreationData var2, boolean var3) throws OperationException, SubscriptionException, ValidationException, JobNotFoundException;

    public String recreateJob(String var1, JobCreationData var2, boolean var3) throws OperationException, SubscriptionException, ValidationException, JobNotFoundException;

    public Job getJob(String var1) throws OperationException, JobNotFoundException;

    public boolean deleteJob(String var1) throws OperationException;

    public JobExecutionStatus getJobExecutionStatus(String var1) throws OperationException, JobNotFoundException;

    public void executeJob(String var1) throws OperationException, JobNotFoundException, SubscriptionException, ValidationException;

    public void abortJob(String var1) throws OperationException, JobNotFoundException;

    public void killJob(String var1) throws OperationException, JobNotFoundException;

    public List<? extends JobAttachment> getJobAttachments(String var1) throws OperationException, JobNotFoundException;

    public List<? extends JobAttachment> getJobAttachments(String var1, JobAttachmentType var2) throws OperationException, JobNotFoundException;

    public void deleteJobAttachments(String var1) throws OperationException, JobNotFoundException;

    public String createJobAttachment(String var1, JobAttachmentCreationData var2) throws OperationException, JobNotFoundException, SubscriptionException, ValidationException;

    public JobAttachment getJobAttachment(String var1, String var2) throws OperationException, JobNotFoundException, AttachmentNotFoundException;

    public boolean deleteJobAttachment(String var1, String var2) throws OperationException, JobNotFoundException;

    public void uploadJobAttachment(String var1, String var2, File var3) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException, SubscriptionException;

    public void uploadJobAttachment(String var1, String var2, InputStream var3) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException, SubscriptionException;

    public void uploadJobAttachment(String var1, String var2, AttachmentContentWriter var3) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException, SubscriptionException;

    public void uploadJobAttachment(String var1, String var2, ObjectMapper var3, Object var4) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException, SubscriptionException;

    public void downloadJobAttachment(String var1, String var2, File var3) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException;

    public void downloadJobAttachment(String var1, String var2, OutputStream var3) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException;

    public <T> T downloadJobAttachment(String var1, String var2, ObjectMapper var3, TypeReference<T> var4) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException;

    public <T> T downloadJobAttachment(String var1, String var2, ObjectMapper var3, Class<T> var4) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException;

    public InputStream downloadJobAttachment(String var1, String var2) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException;

    public void downloadLog(String var1, File var2) throws IOException, OperationException, JobNotFoundException;

    public void downloadLog(String var1, OutputStream var2) throws IOException, OperationException, JobNotFoundException;

    public InputStream downloadLog(String var1) throws IOException, OperationException, JobNotFoundException;

    public JobFailureInfo getFailureInfo(String var1) throws OperationException, JobNotFoundException;

    public List<? extends JobLogItem> getJobLogItems(String var1) throws OperationException, JobNotFoundException;

    public List<? extends JobLogItem> getJobLogItems(String var1, long var2) throws OperationException, JobNotFoundException;

    public List<? extends JobLogItem> getJobLogItems(String var1, long var2, boolean var4) throws OperationException, JobNotFoundException;

    public JobCreationData newJobCreationData();

    public JobAttachmentCreationData newInputJobAttachment(String var1);

    public JobRequestBuilder newRequest();
}

