/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.job.impl;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.job.JobException;
import com.ibm.optim.oaas.client.job.JobExecutor;
import com.ibm.optim.oaas.client.job.JobInput;
import com.ibm.optim.oaas.client.job.JobOutput;
import com.ibm.optim.oaas.client.job.JobRequest;
import com.ibm.optim.oaas.client.job.JobResponse;
import com.ibm.optim.oaas.client.job.impl.JobClientImpl;
import com.ibm.optim.oaas.client.job.impl.JobLogOutputImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobCreationDataImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;

public class JobRequestImpl
implements JobRequest {
    public static final DateFormat UTC_ISO8601_DATE_FORMAT;
    private JobClientImpl client;
    private JobCreationDataImpl data;
    private List<JobInput> input;
    private List<JobOutput> output = new ArrayList<JobOutput>();
    private List<JobLogOutputImpl> logoutput = new ArrayList<JobLogOutputImpl>();
    private boolean delete;
    private long timeout;
    private String jobId;
    private OutputStream livelog;
    private DateFormat livelogDateFormat = UTC_ISO8601_DATE_FORMAT;
    private String copy;
    private boolean shallow;
    private String recreate;
    private final CountDownLatch set = new CountDownLatch(1);
    private volatile boolean submitted = false;
    private boolean batchSubmitMode;

    public JobRequestImpl(JobClientImpl client, JobCreationDataImpl data, List<JobInput> input, List<JobOutput> output, List<JobLogOutputImpl> logoutput, boolean delete, long timeout, OutputStream livelog, DateFormat livelogDateFormat, String copy, boolean shallow, String recreate, boolean batchSubmitMode) {
        this.client = client;
        this.data = data;
        this.input = input;
        this.output = output;
        this.logoutput = logoutput;
        this.delete = delete;
        this.timeout = timeout;
        this.livelog = livelog;
        if (livelogDateFormat != null) {
            this.livelogDateFormat = livelogDateFormat;
        }
        this.copy = copy;
        this.shallow = shallow;
        this.recreate = recreate;
        this.batchSubmitMode = batchSubmitMode;
    }

    @Override
    public JobClientImpl getClient() {
        return this.client;
    }

    @Override
    public JobCreationDataImpl getData() {
        return this.data;
    }

    public List<JobInput> getInput() {
        return this.input;
    }

    public List<JobOutput> getOutput() {
        return this.output;
    }

    public List<JobLogOutputImpl> getLogOutput() {
        return this.logoutput;
    }

    @Override
    public boolean isDeleteOnCompletion() {
        return this.delete;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public OutputStream getLivelog() {
        return this.livelog;
    }

    @Override
    public Future<JobResponse> execute(JobExecutor executor) throws OperationException, IOException, InterruptedException, JobException {
        return executor.execute(this);
    }

    @Override
    public Future<JobResponse> create(JobExecutor executor) throws OperationException, IOException, InterruptedException, JobException {
        return executor.create(this, null);
    }

    @Override
    public String getJobId() {
        if (this.submitted) {
            try {
                this.set.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.jobId;
    }

    public void setJobId(String jobid) {
        this.jobId = jobid;
        this.set.countDown();
    }

    @Override
    public DateFormat getLivelogDateFormat() {
        return this.livelogDateFormat;
    }

    @Override
    public String getCopyJobId() {
        return this.copy;
    }

    @Override
    public boolean getShallowCopy() {
        return this.shallow;
    }

    @Override
    public String getRecreateJobId() {
        return this.recreate;
    }

    void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public boolean isBatchSubmitMode() {
        return this.batchSubmitMode;
    }

    static {
        TimeZone tz = TimeZone.getTimeZone((String)"UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(tz);
        UTC_ISO8601_DATE_FORMAT = df;
    }
}

