/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.job.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.StringWriter;

class JsonObjectPrinter {
    private StringWriter sw = new StringWriter();
    private int nbProperties = 0;
    private boolean isObjectEnded = false;

    public JsonObjectPrinter() {
        this.sw.append('{');
    }

    public void addProperty(String name, JsonParser parser) {
        try {
            if (this.nbProperties > 0) {
                this.sw.append(",");
            }
            ++this.nbProperties;
            this.sw.append("\"" + name + "\":");
            JsonToken token = parser.getCurrentToken();
            if (token == JsonToken.VALUE_STRING) {
                this.sw.append('\"');
                this.sw.append(parser.getValueAsString());
                this.sw.append('\"');
            } else {
                this.sw.append(parser.getValueAsString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void objectEnd() {
        this.sw.append('}');
        this.isObjectEnded = true;
    }

    public String toString() {
        return this.sw.toString() + (this.isObjectEnded ? "" : "...");
    }
}

