/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.job.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.ibm.optim.oaas.client.job.impl.JsonObjectPrinter;
import com.ibm.optim.oaas.client.job.impl.JsonReaderMessageCodes;
import com.ibm.optim.oaas.client.job.impl.JsonResultsReaderException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonResultsReader {
    private final File jsonResultsFile;
    private final List<TableDescriptor> tablesDescriptor = new ArrayList<TableDescriptor>();
    private final List<String> tablesName = new ArrayList<String>();
    private final Map<String, TableDescriptor> tablesDescriptorByName = new LinkedHashMap<String, TableDescriptor>();

    public JsonResultsReader(File jsonResultsFile) throws IOException, JsonResultsReaderException {
        this.jsonResultsFile = jsonResultsFile;
        this.buildSchema();
    }

    public List<String> getTablesName() {
        return this.tablesName;
    }

    public List<TableDescriptor> getTablesDescriptor() {
        return this.tablesDescriptor;
    }

    public TableDescriptor getTableDescriptor(String tableName) {
        return this.tablesDescriptorByName.get(tableName);
    }

    public TableRowIterator getAllTablesRowsIterator() throws IOException, JsonResultsReaderException {
        if (this.jsonResultsFile != null && this.jsonResultsFile.exists()) {
            return new TableRowIteratorImpl(this);
        }
        return null;
    }

    private void addTableDescriptor(TableDescriptor tableDesc) {
        this.tablesDescriptorByName.put(tableDesc.getName(), tableDesc);
        this.tablesDescriptor.add(tableDesc);
        this.tablesName.add(tableDesc.getName());
    }

    private void buildSchema() throws IOException, JsonResultsReaderException {
        if (this.jsonResultsFile != null && this.jsonResultsFile.exists()) {
            JsonFactory factory = new JsonFactory();
            JsonParser jsonParser = factory.createParser(this.jsonResultsFile);
            while (jsonParser.nextToken() != JsonToken.END_OBJECT && jsonParser.hasCurrentToken()) {
                if (jsonParser.getCurrentToken() != JsonToken.FIELD_NAME) continue;
                String tableName = jsonParser.getCurrentName();
                TableDescriptorImpl tableDesc = new TableDescriptorImpl(tableName);
                this.addTableDescriptor(tableDesc);
                this.buildTableSchema(tableDesc, jsonParser);
            }
        }
    }

    private void buildTableSchema(TableDescriptorImpl tableDesc, JsonParser jsonParser) throws IOException, JsonResultsReaderException {
        JsonToken token = jsonParser.nextToken();
        if (token == JsonToken.START_ARRAY) {
            boolean firstRow = true;
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                if (firstRow) {
                    this.buildSchemaFromObject(tableDesc, jsonParser);
                }
                firstRow = false;
            }
        } else if (token == JsonToken.START_OBJECT) {
            this.buildSchemaFromObject(tableDesc, jsonParser);
        } else {
            throw new JsonResultsReaderException(JsonReaderMessageCodes.AKCJC6001E_INVALID_FORMAT_EXCEPTION.name(), JsonToken.START_ARRAY, jsonParser.getCurrentToken());
        }
    }

    private void buildSchemaFromObject(TableDescriptorImpl tableDesc, JsonParser jsonParser) throws IOException, JsonResultsReaderException {
        if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
            JsonObjectPrinter jop = new JsonObjectPrinter();
            int columnIndex = 0;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                ColumnDescriptorImpl<Object> columnDesc;
                String columnName = jsonParser.getCurrentName();
                JsonToken node = jsonParser.nextToken();
                jop.addProperty(columnName, jsonParser);
                if (node == JsonToken.VALUE_NUMBER_INT) {
                    columnDesc = new ColumnDescriptorImpl<Integer>(columnIndex, columnName, Integer.class);
                } else if (node == JsonToken.VALUE_NUMBER_FLOAT) {
                    columnDesc = new ColumnDescriptorImpl<Float>(columnIndex, columnName, Float.class);
                } else if (node == JsonToken.VALUE_STRING) {
                    columnDesc = new ColumnDescriptorImpl<String>(columnIndex, columnName, String.class);
                } else if (node == JsonToken.VALUE_TRUE || node == JsonToken.VALUE_FALSE) {
                    columnDesc = new ColumnDescriptorImpl<Boolean>(columnIndex, columnName, Boolean.class);
                } else {
                    throw new JsonResultsReaderException(JsonReaderMessageCodes.AKCJC6002E_UNEXPECTED_TYPE_EXCEPTION.name(), columnName, tableDesc.getName(), jop);
                }
                ++columnIndex;
                tableDesc.addColumnDescriptor(columnDesc);
            }
        } else {
            throw new JsonResultsReaderException(JsonReaderMessageCodes.AKCJC6001E_INVALID_FORMAT_EXCEPTION.name(), JsonToken.START_OBJECT, jsonParser.getCurrentToken());
        }
    }

    private static class TableRowIteratorImpl
    implements TableRowIterator {
        private final JsonResultsReader reader;
        private final JsonParser jsonParser;
        private TableRow currentRow = null;
        private TableDescriptor currentTableDesc = null;
        private ParsingEntity state = ParsingEntity.ROOT;

        public TableRowIteratorImpl(JsonResultsReader reader) throws IOException, JsonResultsReaderException {
            this.reader = reader;
            JsonFactory factory = new JsonFactory();
            this.jsonParser = factory.createParser(reader.jsonResultsFile);
            this.currentRow = this.buildNextTableRow();
        }

        @Override
        public boolean hasNext() {
            return this.currentRow != null;
        }

        @Override
        public TableRow next() throws IOException, JsonResultsReaderException {
            TableRow result = this.currentRow;
            this.currentRow = this.buildNextTableRow();
            return result;
        }

        private TableRowImpl buildNextTableRow() throws IOException, JsonResultsReaderException {
            switch (this.state) {
                case ROOT: {
                    while (this.jsonParser.nextToken() != JsonToken.END_OBJECT && this.jsonParser.hasCurrentToken()) {
                        if (this.jsonParser.getCurrentToken() != JsonToken.FIELD_NAME) continue;
                        String tableName = this.jsonParser.getCurrentName();
                        this.currentTableDesc = this.reader.getTableDescriptor(tableName);
                        if (this.currentTableDesc == null) {
                            throw new JsonResultsReaderException(JsonReaderMessageCodes.AKCJC6003E_UNKNOWN_TABLE_NAME_EXCEPTION.name(), tableName);
                        }
                        this.state = ParsingEntity.TABLE;
                        return this.buildNextTableRow();
                    }
                    return null;
                }
                case TABLE: {
                    JsonToken token = this.jsonParser.nextToken();
                    if (token == JsonToken.START_ARRAY) {
                        this.state = ParsingEntity.ROW_SET;
                        return this.buildNextTableRow();
                    }
                    if (token == JsonToken.START_OBJECT) {
                        this.state = ParsingEntity.ROW;
                        TableRowImpl row = this.buildNextTableRow();
                        this.state = ParsingEntity.ROOT;
                        return row;
                    }
                    throw new JsonResultsReaderException(JsonReaderMessageCodes.AKCJC6001E_INVALID_FORMAT_EXCEPTION.name(), JsonToken.START_ARRAY, this.jsonParser.getCurrentToken());
                }
                case ROW_SET: {
                    if (this.jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        this.state = ParsingEntity.ROW;
                        TableRowImpl row = this.buildNextTableRow();
                        this.state = ParsingEntity.ROW_SET;
                        return row;
                    }
                    this.state = ParsingEntity.ROOT;
                    return this.buildNextTableRow();
                }
            }
            if (this.jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
                JsonObjectPrinter jop = new JsonObjectPrinter();
                TableRowImpl row = new TableRowImpl(this.currentTableDesc);
                while (this.jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    String columnName = this.jsonParser.getCurrentName();
                    JsonToken node = this.jsonParser.nextToken();
                    jop.addProperty(columnName, this.jsonParser);
                    if (node == JsonToken.VALUE_NUMBER_INT) {
                        row.setColumnValue(columnName, this.jsonParser.getIntValue());
                        continue;
                    }
                    if (node == JsonToken.VALUE_NUMBER_FLOAT) {
                        row.setColumnValue(columnName, this.jsonParser.getDoubleValue());
                        continue;
                    }
                    if (node == JsonToken.VALUE_STRING) {
                        row.setColumnValue(columnName, this.jsonParser.getText());
                        continue;
                    }
                    if (node == JsonToken.VALUE_TRUE || node == JsonToken.VALUE_FALSE) {
                        row.setColumnValue(columnName, this.jsonParser.getBooleanValue());
                        continue;
                    }
                    throw new JsonResultsReaderException(JsonReaderMessageCodes.AKCJC6002E_UNEXPECTED_TYPE_EXCEPTION.name(), columnName, this.currentTableDesc.getName(), jop);
                }
                return row;
            }
            throw new JsonResultsReaderException(JsonReaderMessageCodes.AKCJC6001E_INVALID_FORMAT_EXCEPTION.name(), JsonToken.START_OBJECT, this.jsonParser.getCurrentToken());
        }

        private static enum ParsingEntity {
            ROOT,
            TABLE,
            ROW_SET,
            ROW;

        }
    }

    public static interface TableRowIterator {
        public boolean hasNext();

        public TableRow next() throws IOException, JsonResultsReaderException;
    }

    private static class TableRowImpl
    implements TableRow {
        private final TableDescriptor tableDesc;
        private final Object[] values;

        public TableRowImpl(TableDescriptor tableDesc) {
            this.tableDesc = tableDesc;
            List<ColumnDescriptor<?>> columnsDescriptor = tableDesc.getColumnsDescriptor();
            this.values = new Object[columnsDescriptor.size()];
        }

        @Override
        public TableDescriptor getTableDesc() {
            return this.tableDesc;
        }

        public void setColumnValue(String columnName, Object value) {
            ColumnDescriptor<?> colDesc = this.tableDesc.getColumnDescriptor(columnName);
            this.values[colDesc.getIndex()] = value;
        }

        @Override
        public Object getColumnValue(int index) {
            return this.values[index];
        }

        @Override
        public Object getColumnValue(String columnName) {
            ColumnDescriptor<?> colDesc = this.tableDesc.getColumnDescriptor(columnName);
            return this.values[colDesc.getIndex()];
        }
    }

    public static interface TableRow {
        public TableDescriptor getTableDesc();

        public Object getColumnValue(int var1);

        public Object getColumnValue(String var1);
    }

    private class ColumnDescriptorImpl<T>
    implements ColumnDescriptor<T> {
        private final int index;
        private final String name;
        private final Class<T> type;

        public ColumnDescriptorImpl(int index, String name, Class<T> type) {
            this.name = name;
            this.index = index;
            this.type = type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }
    }

    public static interface ColumnDescriptor<T> {
        public int getIndex();

        public String getName();

        public Class<?> getType();
    }

    private class TableDescriptorImpl
    implements TableDescriptor {
        private final String name;
        private final List<ColumnDescriptor<?>> columnsDescriptor;
        private final List<String> columnsName = new ArrayList<String>();
        private final Map<String, ColumnDescriptor<?>> columnsDescriptorByName = new LinkedHashMap();

        public TableDescriptorImpl(String name) {
            this.name = name;
            this.columnsDescriptor = new ArrayList();
        }

        public void addColumnDescriptor(ColumnDescriptor<?> desc) {
            this.columnsDescriptor.add(desc);
            this.columnsName.add(desc.getName());
            this.columnsDescriptorByName.put(desc.getName(), desc);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<ColumnDescriptor<?>> getColumnsDescriptor() {
            return this.columnsDescriptor;
        }

        @Override
        public ColumnDescriptor<?> getColumnDescriptor(int index) {
            return this.columnsDescriptor.get(index);
        }

        @Override
        public ColumnDescriptor<?> getColumnDescriptor(String columnName) {
            return this.columnsDescriptorByName.get(columnName);
        }

        @Override
        public List<String> getColumnsName() {
            return this.columnsName;
        }
    }

    public static interface TableDescriptor {
        public String getName();

        public List<ColumnDescriptor<?>> getColumnsDescriptor();

        public ColumnDescriptor<?> getColumnDescriptor(int var1);

        public ColumnDescriptor<?> getColumnDescriptor(String var1);

        public List<String> getColumnsName();
    }
}

