/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;

public class PowerFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$power");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$power");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$power");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$power");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        DoubleNode result = null;
        JsonNode argNumber = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argNumber = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount != 2) throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : (argCount == 1 ? ERR_BAD_CONTEXT : ERR_ARG3BADTYPE));
        if (!useContext) {
            argNumber = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        JsonNode argExponent = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
        if (argNumber == null) return result;
        if (!argNumber.isNumber()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        if (argExponent == null) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        if (!argExponent.isNumber()) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        double power = Math.pow(argNumber.doubleValue(), argExponent.doubleValue());
        if (power != Double.POSITIVE_INFINITY && power != Double.NEGATIVE_INFINITY && power != Double.NaN) {
            return new DoubleNode(power);
        }
        String msg = String.format("The power function has resulted in a value that cannot be represented as a number: base=\"%s\", exponent=\"%s\"", argNumber.asText(), argExponent.asText());
        throw new EvaluateRuntimeException(msg);
    }

    @Override
    public String getSignature() {
        return "<n-n:n>";
    }
}

