/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;

public class SubstringBeforeFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$substringBefore");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$substringBefore");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$substringBefore");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$substringBefore");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        JsonNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount == 1 || argCount == 2) {
            if (!useContext) {
                argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if (argCount == 1) {
                if (argString == null || argString.isTextual()) {
                    throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
                }
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
            JsonNode argChars = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
            if (argChars == null) {
                if (argString == null) {
                    return null;
                }
                if (argString.isTextual()) {
                    return new TextNode(argString.textValue());
                }
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
            if (argString != null) {
                String chars;
                if (!argString.isTextual()) {
                    throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                }
                if (!argChars.isTextual()) {
                    throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
                }
                String str = argString.textValue();
                int index = str.indexOf(chars = argChars.textValue());
                result = index != -1 ? new TextNode(str.substring(0, index)) : new TextNode(str);
            }
        } else {
            throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG3BADTYPE);
        }
        return result;
    }

    @Override
    public String getSignature() {
        return "<s-s:s>";
    }
}

