/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.NonNumericArrayIndexException;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.generated.MappingExpressionBaseVisitor;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.BooleanUtils;
import com.api.jsonata4java.expressions.utils.Constants;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.api.jsonata4java.expressions.utils.NumberUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.apache.commons.text.StringEscapeUtils;

public class ExpressionsVisitor
extends MappingExpressionBaseVisitor<JsonNode> {
    private static final String CLASS = ExpressionsVisitor.class.getName();
    public static String ERR_NEGATE_NON_NUMERIC = "Cannot negate a non-numeric value";
    public static String ERR_SEQ_LHS_INTEGER = "The left side of the range operator (..) must evaluate to an integer";
    public static String ERR_SEQ_RHS_INTEGER = "The right side of the range operator (..) must evaluate to an integer";
    public static String ERR_MSG_INVALID_PATH_ENTRY = String.format("The literal value %s cannot be used as a step within a path expression", (Object[])null);
    private static final Logger LOG = Logger.getLogger(CLASS);
    JsonNodeFactory factory = JsonNodeFactory.instance;
    private Map<String, DeclaredFunction> functionMap = new HashMap<String, DeclaredFunction>();
    private Stack<JsonNode> stack = new Stack();
    ParseTreeProperty<Integer> values = new ParseTreeProperty();
    private Map<String, JsonNode> variableMap = new HashMap<String, JsonNode>();

    private static boolean areJsonNodesEqual(JsonNode left, JsonNode right) {
        if (left.isFloatingPointNumber() || right.isFloatingPointNumber()) {
            return left.asDouble() == right.asDouble();
        }
        if (left.isIntegralNumber() && right.isIntegralNumber()) {
            return left.asLong() == right.asLong();
        }
        if (left.isNull()) {
            return right.isNull();
        }
        if (right.isNull()) {
            return left.isNull();
        }
        if (left.isTextual() && right.isTextual()) {
            return left.asText().equals(right.asText());
        }
        if (left.isArray() && right.isArray()) {
            return false;
        }
        if (left.isObject() && right.isObject()) {
            return false;
        }
        if (left.isBoolean() && right.isBoolean()) {
            return left == right;
        }
        return false;
    }

    public static String castString(JsonNode node) throws EvaluateRuntimeException {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case STRING: {
                return node.textValue();
            }
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(node);
        }
        catch (JsonProcessingException e) {
            throw new EvaluateRuntimeException("Failed to cast value " + node + " to a string. Reason: " + e.getMessage());
        }
    }

    private static ArrayNode ensureArray(JsonNode input) {
        if (input == null) {
            return null;
        }
        if (input.isArray()) {
            return (ArrayNode)input;
        }
        return JsonNodeFactory.instance.arrayNode().add(input);
    }

    private static boolean isWholeNumber(double n) {
        return n == Math.rint(n) && !Double.isInfinite(n) && !Double.isNaN(n);
    }

    private static boolean isWholeNumber(JsonNode n) {
        if (n == null) {
            return false;
        }
        if (n.isInt() || n.isLong()) {
            return true;
        }
        return (n.isFloat() || n.isDouble()) && (double)n.asInt() == n.asDouble();
    }

    private static String sanitise(String str) {
        if (str.startsWith("`") && str.endsWith("`") || str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'")) {
            str = str.substring(1, str.length() - 1);
        }
        str = StringEscapeUtils.unescapeJson(str);
        return str;
    }

    private static JsonNode unwrapArray(JsonNode input) {
        if (input == null) {
            return null;
        }
        if (input.isArray()) {
            if (input.size() == 1) {
                return input.get(0);
            }
            return input;
        }
        return input;
    }

    public ExpressionsVisitor(JsonNode rootContext) {
        if (rootContext != null) {
            this.stack.push(rootContext);
            this.variableMap.put("$", rootContext);
        }
    }

    public Map<String, DeclaredFunction> getFunctionMap() {
        return this.functionMap;
    }

    public Stack<JsonNode> getStack() {
        return this.stack;
    }

    public int getValue(ParseTree node) {
        return this.values.get(node);
    }

    public Map<String, JsonNode> getVariableMap() {
        return this.variableMap;
    }

    private List<Integer> resolveIndexes(List<Integer> input, int sizeOfSourceArray) {
        ArrayList<Integer> resolvedIndexes = new ArrayList<Integer>();
        for (int i : input) {
            if (i < 0) {
                resolvedIndexes.add(sizeOfSourceArray + i);
                continue;
            }
            resolvedIndexes.add(i);
        }
        Collections.sort(resolvedIndexes);
        return resolvedIndexes;
    }

    private JsonNode resolvePath(JsonNode lhs, MappingExpressionParser.ExprContext rhsCtx) {
        JsonNode output;
        String METHOD = "resolvePath";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "resolvePath", new Object[]{lhs, rhsCtx.getText()});
        }
        if (lhs == null) {
            output = null;
        } else if (lhs.isArray()) {
            SelectorArrayNode arr;
            output = arr = new SelectorArrayNode(this.factory);
            for (JsonNode lhsE : lhs) {
                JsonNode rhsE = this.resolvePath(lhsE, rhsCtx);
                if (rhsE == null) continue;
                arr.addAsSelectionGroup(rhsE);
            }
        } else {
            this.stack.push(lhs);
            output = (JsonNode)this.visit(rhsCtx);
            this.stack.pop();
        }
        SelectorArrayNode result = output;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "resolvePath", result);
        }
        return result;
    }

    public void setValue(ParseTree node, int value) {
        this.values.put(node, value);
    }

    @Override
    public JsonNode visitAddsub_op(MappingExpressionParser.Addsub_opContext ctx) {
        double result;
        JsonNode leftNode = (JsonNode)this.visit(ctx.expr(0));
        JsonNode rightNode = (JsonNode)this.visit(ctx.expr(1));
        if (leftNode == null || rightNode == null) {
            return null;
        }
        if (!leftNode.isNumber() || !rightNode.isNumber()) {
            throw new EvaluateRuntimeException(ctx.op.getText() + " expects two numeric arguments");
        }
        double left = leftNode.asDouble();
        double right = rightNode.asDouble();
        if (ctx.op.getType() == 30) {
            result = left + right;
        } else if (ctx.op.getType() == 31) {
            result = left - right;
        } else {
            throw new EvaluateRuntimeException("Unrecognised token " + ctx.op.getText());
        }
        if (ExpressionsVisitor.isWholeNumber(result)) {
            return new LongNode((long)result);
        }
        return new DoubleNode(result);
    }

    @Override
    public JsonNode visitArray(MappingExpressionParser.ArrayContext ctx) {
        ArrayNode output;
        String METHOD = "visitArray";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitArray", new Object[]{ctx.getText()});
        }
        if (ctx.expr().size() != 2) {
            throw new EvaluateRuntimeException("invalid array expression");
        }
        ArrayNode sourceArray = ExpressionsVisitor.ensureArray((JsonNode)this.visit(ctx.expr(0)));
        if (sourceArray == null) {
            return null;
        }
        MappingExpressionParser.ExprContext indexContext = ctx.expr(1);
        ArrayList<Integer> indexesToReturn = new ArrayList<Integer>();
        boolean isPredicate = false;
        for (int i = 0; i < sourceArray.size(); ++i) {
            JsonNode e = sourceArray.get(i);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.logp(Level.FINEST, CLASS, "visitArray", "Evaluating array index expression '" + indexContext.getText() + "' against element at index " + i + " ('" + e + "') of source array");
            }
            this.stack.push(e);
            JsonNode indexesInContext = (JsonNode)this.visit(indexContext);
            this.stack.pop();
            if (indexesInContext == null) {
                isPredicate = true;
                continue;
            }
            if (indexesInContext.isBoolean()) {
                isPredicate = true;
                if (indexesInContext != BooleanNode.TRUE) continue;
                indexesToReturn.add(i);
                continue;
            }
            indexesInContext = ExpressionsVisitor.ensureArray(indexesInContext);
            for (JsonNode indexInContext : indexesInContext) {
                if (indexInContext.isIntegralNumber()) {
                    indexesToReturn.add(indexInContext.asInt());
                    continue;
                }
                if (indexInContext.isFloatingPointNumber()) {
                    indexesToReturn.add((int)Math.floor(indexInContext.asDouble()));
                    continue;
                }
                throw new NonNumericArrayIndexException();
            }
            break;
        }
        if (!isPredicate && sourceArray instanceof SelectorArrayNode) {
            SelectorArrayNode sourceArraySel = (SelectorArrayNode)sourceArray;
            SelectorArrayNode resultAsSel = new SelectorArrayNode(this.factory);
            output = resultAsSel;
            block2: for (JsonNode group : sourceArraySel.getSelectionGroups()) {
                List<Integer> resolvedIndexes = this.resolveIndexes(indexesToReturn, group.size());
                for (int index : resolvedIndexes) {
                    if (group.isArray()) {
                        JsonNode atIndex = group.get(index);
                        if (atIndex == null) continue block2;
                        resultAsSel.addAsSelectionGroup(atIndex);
                        continue;
                    }
                    if (index != 0) continue;
                    resultAsSel.addAsSelectionGroup(group);
                }
            }
        } else {
            output = this.factory.arrayNode();
            List<Integer> resolvedIndexes = this.resolveIndexes(indexesToReturn, sourceArray.size());
            for (int index : resolvedIndexes) {
                if (index < 0 || index >= sourceArray.size()) continue;
                output.add(sourceArray.get(index));
            }
        }
        if (output.size() == 0) {
            return null;
        }
        JsonNode result = output;
        result = ExpressionsVisitor.unwrapArray(result);
        result = ExpressionsVisitor.unwrapArray(result);
        return result;
    }

    @Override
    public JsonNode visitArray_constructor(MappingExpressionParser.Array_constructorContext ctx) {
        String METHOD = "visitArray_constructor";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitArray_constructor", new Object[]{ctx.getText(), ctx.depth()});
        }
        ArrayNode output = this.factory.arrayNode();
        if (ctx.exprOrSeqList() != null) {
            for (MappingExpressionParser.ExprOrSeqContext expr : ctx.exprOrSeqList().exprOrSeq()) {
                if (expr.seq() == null) {
                    JsonNode result = (JsonNode)this.visit(expr);
                    output.add(result);
                    continue;
                }
                ArrayNode seq = (ArrayNode)this.visit(expr);
                if (seq == null) continue;
                output.addAll(seq);
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitArray_constructor", output.toString());
        }
        return output;
    }

    @Override
    public JsonNode visitBoolean(MappingExpressionParser.BooleanContext ctx) {
        BooleanNode result = null;
        if (ctx.op.getType() == 9) {
            result = BooleanNode.TRUE;
        } else if (ctx.op.getType() == 10) {
            result = BooleanNode.FALSE;
        }
        return result;
    }

    @Override
    public JsonNode visitComp_op(MappingExpressionParser.Comp_opContext ctx) {
        BooleanNode result = null;
        JsonNode left = (JsonNode)this.visit(ctx.expr(0));
        JsonNode right = (JsonNode)this.visit(ctx.expr(1));
        if (left == null && right == null) {
            return BooleanNode.FALSE;
        }
        if (ctx.op.getType() == 33) {
            if (left == null && right != null) {
                return BooleanNode.FALSE;
            }
            if (left != null && right == null) {
                return BooleanNode.FALSE;
            }
            result = ExpressionsVisitor.areJsonNodesEqual(left, right) ? BooleanNode.TRUE : BooleanNode.FALSE;
        } else if (ctx.op.getType() == 34) {
            if (left == null && right != null) {
                return BooleanNode.TRUE;
            }
            if (left != null && right == null) {
                return BooleanNode.TRUE;
            }
            result = ExpressionsVisitor.areJsonNodesEqual(left, right) ? BooleanNode.FALSE : BooleanNode.TRUE;
        } else if (ctx.op.getType() == 35) {
            if (left == null || left.isNull() || right == null || right.isNull()) {
                throw new EvaluateRuntimeException("The expressions either side of operator \"<\" must evaluate to numeric or string values");
            }
            result = left.isFloatingPointNumber() || right.isFloatingPointNumber() ? (left.asDouble() < right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE) : (left.isIntegralNumber() && right.isIntegralNumber() ? (left.asLong() < right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE) : (left.asText().compareTo(right.asText()) == -1 ? BooleanNode.TRUE : BooleanNode.FALSE));
        } else if (ctx.op.getType() == 37) {
            if (left == null || left.isNull() || right == null || right.isNull()) {
                throw new EvaluateRuntimeException("The expressions either side of operator \">\" must evaluate to numeric or string values");
            }
            result = left.isFloatingPointNumber() || right.isFloatingPointNumber() ? (left.asDouble() > right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE) : (left.isIntegralNumber() && right.isIntegralNumber() ? (left.asLong() > right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE) : (left.asText().compareTo(right.asText()) == 1 ? BooleanNode.TRUE : BooleanNode.FALSE));
        } else if (ctx.op.getType() == 36) {
            if (left == null || left.isNull() || right == null || right.isNull()) {
                throw new EvaluateRuntimeException("The expressions either side of operator \"<=\" must evaluate to numeric or string values");
            }
            result = left.isFloatingPointNumber() || right.isFloatingPointNumber() ? (left.asDouble() <= right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE) : (left.isIntegralNumber() && right.isIntegralNumber() ? (left.asLong() <= right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE) : (left.asText().compareTo(right.asText()) != 1 ? BooleanNode.TRUE : BooleanNode.FALSE));
        } else if (ctx.op.getType() == 38) {
            if (left == null || left.isNull() || right == null || right.isNull()) {
                throw new EvaluateRuntimeException("The expressions either side of operator \">=\" must evaluate to numeric or string values");
            }
            result = left.isFloatingPointNumber() || right.isFloatingPointNumber() ? (left.asDouble() >= right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE) : (left.isIntegralNumber() && right.isIntegralNumber() ? (left.asLong() >= right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE) : (left.asText().compareTo(right.asText()) != -1 ? BooleanNode.TRUE : BooleanNode.FALSE));
        }
        return result;
    }

    @Override
    public JsonNode visitConcat_op(MappingExpressionParser.Concat_opContext ctx) {
        JsonNode left = (JsonNode)this.visit(ctx.expr(0));
        JsonNode right = (JsonNode)this.visit(ctx.expr(1));
        String leftStr = left == null ? "" : ExpressionsVisitor.castString(left);
        String rightStr = right == null ? "" : ExpressionsVisitor.castString(right);
        TextNode result = new TextNode(leftStr + rightStr);
        return result;
    }

    @Override
    public JsonNode visitConditional(MappingExpressionParser.ConditionalContext ctx) {
        JsonNode cond = (JsonNode)this.visit(ctx.expr(0));
        return BooleanUtils.convertJsonNodeToBoolean(cond) ? (JsonNode)this.visit(ctx.expr(1)) : (JsonNode)this.visit(ctx.expr(2));
    }

    @Override
    public JsonNode visitContext_ref(MappingExpressionParser.Context_refContext ctx) {
        JsonNode result = null;
        if (ctx.getChildCount() > 0) {
            ParseTree child0 = ctx.getChild(0);
            if (child0 instanceof TerminalNodeImpl) {
                if (((TerminalNodeImpl)child0).symbol.getText().equals("$")) {
                    JsonNode context = this.variableMap.get("$");
                    CommonToken token = null;
                    MappingExpressionParser.ArrayContext expr = null;
                    switch (context.getNodeType()) {
                        case BINARY: 
                        case POJO: {
                            break;
                        }
                        case ARRAY: {
                            child0 = FunctionUtils.getArrayConstructorContext(ctx, (ArrayNode)context);
                            ctx.children.set(0, child0);
                            expr = new MappingExpressionParser.ArrayContext(ctx);
                            for (int i = 0; i < ctx.children.size(); ++i) {
                                expr.children.add(ctx.children.get(i));
                            }
                            break;
                        }
                        case BOOLEAN: {
                            token = context.asBoolean() ? CommonTokenFactory.DEFAULT.create(9, context.asText()) : CommonTokenFactory.DEFAULT.create(10, context.asText());
                            TerminalNodeImpl tn = new TerminalNodeImpl(token);
                            MappingExpressionParser.BooleanContext nc = new MappingExpressionParser.BooleanContext(ctx);
                            nc.addAnyChild(tn);
                            child0 = nc;
                            break;
                        }
                        case MISSING: 
                        case NULL: {
                            token = CommonTokenFactory.DEFAULT.create(15, null);
                            TerminalNodeImpl tn = new TerminalNodeImpl(token);
                            child0 = tn;
                            break;
                        }
                        case NUMBER: {
                            token = CommonTokenFactory.DEFAULT.create(22, context.asText());
                            TerminalNodeImpl tn = new TerminalNodeImpl(token);
                            child0 = tn;
                            break;
                        }
                        case OBJECT: {
                            child0 = FunctionUtils.getObjectConstructorContext(ctx, (ObjectNode)context);
                            break;
                        }
                        default: {
                            token = CommonTokenFactory.DEFAULT.create(11, context.asText());
                            TerminalNodeImpl tn = new TerminalNodeImpl(token);
                            child0 = tn;
                            break;
                        }
                    }
                    result = (JsonNode)this.visit(expr);
                }
            } else {
                result = (JsonNode)this.visit(ctx);
            }
        }
        return result;
    }

    @Override
    public JsonNode visitEach_function(MappingExpressionParser.Each_functionContext ctx) {
        ArrayNode resultArray = new ArrayNode(JsonNodeFactory.instance);
        List<MappingExpressionParser.ExprListContext> exprListContext = ctx.exprList();
        MappingExpressionParser.ExprListContext exprList = exprListContext.get(0);
        MappingExpressionParser.ExprContext objCtx = exprList.expr(0);
        JsonNode element = (JsonNode)this.visit(objCtx);
        MappingExpressionParser.ExprListContext fctBody = null;
        if (exprListContext.size() > 1) {
            fctBody = exprListContext.get(1);
        }
        MappingExpressionParser.VarListContext varList = ctx.varList();
        TerminalNode functionid = ctx.FUNCTIONID();
        TerminalNode varid = ctx.VAR_ID();
        if (varid != null) {
            Function function = Constants.FUNCTIONS.get(varid.getText());
            if (function != null) {
                MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                resultArray.add(FunctionUtils.processFctCallVariables(this, function, varid, callCtx, element));
            } else {
                DeclaredFunction fct = this.functionMap.get(functionid.getText());
                if (fct == null) {
                    throw new EvaluateRuntimeException("Expected function variable reference " + varid.getText() + " to resolve to a declared function.");
                }
            }
        } else {
            DeclaredFunction fct = new DeclaredFunction(varList, fctBody);
            Iterator<String> it = element.fieldNames();
            while (it.hasNext()) {
                String key = it.next();
                JsonNode value = element.get(key);
                resultArray.add(fct.invoke(this, FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, key, value)));
            }
        }
        return resultArray;
    }

    @Override
    public JsonNode visitFct_chain(MappingExpressionParser.Fct_chainContext ctx) {
        JsonNode result = null;
        MappingExpressionParser.ExprContext exprObj = ctx.expr(1);
        if (!(exprObj instanceof MappingExpressionParser.Function_callContext)) {
            throw new EvaluateRuntimeException("Expected a function but got " + ctx.expr(1).getText());
        }
        this.stack.push((JsonNode)this.visit(ctx.expr(0)));
        result = (JsonNode)this.visit(ctx.expr(1));
        this.stack.pop();
        return result;
    }

    @Override
    public JsonNode visitFilter_function(MappingExpressionParser.Filter_functionContext ctx) {
        TerminalNode varid;
        ArrayNode resultArray = new ArrayNode(JsonNodeFactory.instance);
        MappingExpressionParser.VarListContext varList = ctx.varList();
        List<MappingExpressionParser.ExprListContext> exprListContext = ctx.exprList();
        MappingExpressionParser.ExprListContext exprList = exprListContext.get(0);
        boolean useContext = ctx.getParent() instanceof MappingExpressionParser.Fct_chainContext || ctx.getParent() instanceof MappingExpressionParser.PathContext;
        JsonNode arrayObj = null;
        arrayObj = useContext ? FunctionUtils.getContextVariable(this) : (JsonNode)this.visit(exprList.expr(0));
        if (arrayObj == null || !arrayObj.isArray()) {
            throw new EvaluateRuntimeException(String.format("Argument 1 of function %s does not match function signature", "$filter"));
        }
        ArrayNode mapArray = (ArrayNode)arrayObj;
        MappingExpressionParser.ExprListContext fctBody = null;
        if (exprListContext.size() > (useContext ? 0 : 1)) {
            fctBody = exprListContext.get(useContext ? 0 : 1);
        }
        if ((varid = ctx.VAR_ID()) != null) {
            Function function = Constants.FUNCTIONS.get(varid.getText());
            if (function != null) {
                for (int i = 0; i < mapArray.size(); ++i) {
                    MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                    JsonNode element = mapArray.get(i);
                    JsonNode fctResult = FunctionUtils.processFctCallVariables(this, function, varid, callCtx, element);
                    if (fctResult == null || !fctResult.asBoolean()) continue;
                    resultArray.add(element);
                }
            } else {
                DeclaredFunction fct = this.functionMap.get(varid.getText());
                if (fct == null) {
                    throw new EvaluateRuntimeException("Expected function variable reference " + varid.getText() + " to resolve to a declared function.");
                }
                int varCount = fct.getVariableCount();
                for (int i = 0; i < mapArray.size(); ++i) {
                    JsonNode element = mapArray.get(i);
                    MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                    switch (varCount) {
                        case 1: {
                            evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, element);
                            break;
                        }
                        case 2: {
                            evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, element);
                            evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                            break;
                        }
                        case 3: {
                            evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, element);
                            evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                            evc = FunctionUtils.addArrayExprVarContext(ctx, evc, mapArray);
                        }
                    }
                    JsonNode fctResult = fct.invoke(this, evc);
                    if (fctResult == null || !fctResult.asBoolean()) continue;
                    resultArray.add(element);
                }
            }
        } else {
            DeclaredFunction fct = new DeclaredFunction(varList, fctBody);
            int varCount = fct.getVariableCount();
            for (int i = 0; i < mapArray.size(); ++i) {
                JsonNode element = mapArray.get(i);
                MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                switch (varCount) {
                    case 1: {
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, element);
                        break;
                    }
                    case 2: {
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, element);
                        evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                        break;
                    }
                    case 3: {
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, element);
                        evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                        evc = FunctionUtils.addArrayExprVarContext(ctx, evc, mapArray);
                    }
                }
                JsonNode fctResult = fct.invoke(this, evc);
                if (fctResult == null || !fctResult.asBoolean()) continue;
                resultArray.add(element);
            }
        }
        return resultArray;
    }

    @Override
    public JsonNode visitFunction_call(MappingExpressionParser.Function_callContext ctx) {
        JsonNode result = null;
        String functionName = ctx.VAR_ID().getText();
        Function function = Constants.FUNCTIONS.get(functionName);
        if (function != null) {
            result = function.invoke(this, ctx);
        } else {
            DeclaredFunction declFct = this.functionMap.get(functionName);
            if (declFct == null) {
                throw new EvaluateRuntimeException("Unknown function: " + functionName);
            }
            result = declFct.invoke(this, ctx);
        }
        return result;
    }

    @Override
    public JsonNode visitFunction_decl(MappingExpressionParser.Function_declContext ctx) {
        JsonNode result = null;
        result = (JsonNode)this.visit(ctx);
        return result;
    }

    @Override
    public JsonNode visitFunction_exec(MappingExpressionParser.Function_execContext ctx) {
        int exprListCount;
        JsonNode result = null;
        List<TerminalNode> varListCtx = ctx.varList().VAR_ID();
        List<MappingExpressionParser.ExprContext> exprValuesCtx = ctx.exprValues().exprList().expr();
        int varListCount = varListCtx.size();
        if (varListCount != (exprListCount = exprValuesCtx.size())) {
            throw new EvaluateRuntimeException("Expected equal counts for varibles (" + varListCount + ") and values (" + exprListCount + ")");
        }
        for (int i = 0; i < varListCount; ++i) {
            String varID = varListCtx.get(i).getText();
            JsonNode value = (JsonNode)this.visit(exprValuesCtx.get(i));
            this.variableMap.put(varID, value);
        }
        MappingExpressionParser.ExprListContext exprListCtx = ctx.exprList();
        result = (JsonNode)this.visit(exprListCtx);
        return result;
    }

    @Override
    public JsonNode visitId(MappingExpressionParser.IdContext ctx) {
        JsonNode context;
        String METHOD = "visitId";
        try {
            context = this.stack.peek();
        }
        catch (EmptyStackException ex) {
            return null;
        }
        String id = ExpressionsVisitor.sanitise(ctx.ID().getText());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitId", new Object[]{ctx.getText(), id, "(stack: " + context + ")"});
        }
        JsonNode result = context == null ? null : context.get(id);
        result = ExpressionsVisitor.unwrapArray(result);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitId", result);
        }
        return result;
    }

    @Override
    public JsonNode visitLogand(MappingExpressionParser.LogandContext ctx) {
        BooleanNode result = null;
        JsonNode left = (JsonNode)this.visit(ctx.expr(0));
        JsonNode right = (JsonNode)this.visit(ctx.expr(1));
        if (left == null || right == null) {
            return null;
        }
        result = BooleanUtils.convertJsonNodeToBoolean(left) && BooleanUtils.convertJsonNodeToBoolean(right) ? BooleanNode.TRUE : BooleanNode.FALSE;
        return result;
    }

    @Override
    public JsonNode visitLogor(MappingExpressionParser.LogorContext ctx) {
        BooleanNode result = null;
        JsonNode left = (JsonNode)this.visit(ctx.expr(0));
        JsonNode right = (JsonNode)this.visit(ctx.expr(1));
        if (left == null || right == null) {
            return null;
        }
        result = BooleanUtils.convertJsonNodeToBoolean(left) || BooleanUtils.convertJsonNodeToBoolean(right) ? BooleanNode.TRUE : BooleanNode.FALSE;
        return result;
    }

    @Override
    public JsonNode visitMap_function(MappingExpressionParser.Map_functionContext ctx) {
        TerminalNode varid;
        ArrayNode resultArray = new ArrayNode(JsonNodeFactory.instance);
        MappingExpressionParser.VarListContext varList = ctx.varList();
        List<MappingExpressionParser.ExprListContext> exprListContext = ctx.exprList();
        MappingExpressionParser.ExprListContext exprList = exprListContext.get(0);
        boolean useContext = ctx.getParent() instanceof MappingExpressionParser.Fct_chainContext || ctx.getParent() instanceof MappingExpressionParser.PathContext;
        JsonNode arrayObj = null;
        arrayObj = useContext ? FunctionUtils.getContextVariable(this) : (JsonNode)this.visit(exprList.expr(0));
        if (arrayObj == null || !arrayObj.isArray()) {
            throw new EvaluateRuntimeException(String.format("Argument 1 of function %s does not match function signature", "$filter"));
        }
        ArrayNode mapArray = (ArrayNode)arrayObj;
        MappingExpressionParser.ExprListContext fctBody = null;
        if (exprListContext.size() > (useContext ? 0 : 1)) {
            fctBody = exprListContext.get(useContext ? 0 : 1);
        }
        if ((varid = ctx.VAR_ID()) != null) {
            Function function = Constants.FUNCTIONS.get(varid.getText());
            if (function != null) {
                for (int i = 0; i < mapArray.size(); ++i) {
                    MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                    JsonNode element = mapArray.get(i);
                    resultArray.add(FunctionUtils.processFctCallVariables(this, function, varid, callCtx, element));
                }
            } else {
                DeclaredFunction fct = this.functionMap.get(varid.getText());
                if (fct == null) {
                    throw new EvaluateRuntimeException("Expected function variable reference " + varid.getText() + " to resolve to a declared function.");
                }
                int varCount = fct.getVariableCount();
                for (int i = 0; i < mapArray.size(); ++i) {
                    JsonNode element = mapArray.get(i);
                    MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                    switch (varCount) {
                        case 1: {
                            evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, element);
                            break;
                        }
                        case 2: {
                            evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, element);
                            evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                            break;
                        }
                        case 3: {
                            evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, element);
                            evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                            evc = FunctionUtils.addArrayExprVarContext(ctx, evc, mapArray);
                        }
                    }
                    resultArray.add(fct.invoke(this, evc));
                }
            }
        } else {
            DeclaredFunction fct = new DeclaredFunction(varList, fctBody);
            int varCount = fct.getVariableCount();
            for (int i = 0; i < mapArray.size(); ++i) {
                JsonNode element = mapArray.get(i);
                MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                switch (varCount) {
                    case 1: {
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, element);
                        break;
                    }
                    case 2: {
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, element);
                        evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                        break;
                    }
                    case 3: {
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, element);
                        evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                        evc = FunctionUtils.addArrayExprVarContext(ctx, evc, mapArray);
                    }
                }
                resultArray.add(fct.invoke(this, evc));
            }
        }
        return resultArray;
    }

    @Override
    public JsonNode visitMembership(MappingExpressionParser.MembershipContext ctx) {
        String METHOD = "visitMembership";
        JsonNode left = (JsonNode)this.visit(ctx.expr(0));
        JsonNode right = (JsonNode)this.visit(ctx.expr(1));
        if (left == null || right == null) {
            return null;
        }
        right = ExpressionsVisitor.ensureArray(right);
        BooleanNode result = BooleanNode.FALSE;
        Iterator<JsonNode> elements = right.elements();
        while (elements.hasNext()) {
            JsonNode curElement = elements.next();
            if (!ExpressionsVisitor.areJsonNodesEqual(left, curElement)) continue;
            result = BooleanNode.TRUE;
            break;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.logp(Level.FINEST, CLASS, "visitMembership", "is " + left + " (" + (Object)((Object)left.getNodeType()) + ") in " + right + " (" + (Object)((Object)right.getNodeType()) + ")? -> " + result);
        }
        return result;
    }

    @Override
    public JsonNode visitMuldiv_op(MappingExpressionParser.Muldiv_opContext ctx) {
        double result;
        JsonNode leftNode = (JsonNode)this.visit(ctx.expr(0));
        JsonNode rightNode = (JsonNode)this.visit(ctx.expr(1));
        if (leftNode == null || rightNode == null) {
            return null;
        }
        if (!leftNode.isNumber() || !rightNode.isNumber()) {
            throw new EvaluateRuntimeException(ctx.op.getText() + " expects two numeric arguments");
        }
        double left = leftNode.asDouble();
        double right = rightNode.asDouble();
        if (ctx.op.getType() == 28) {
            result = left * right;
        } else if (ctx.op.getType() == 29) {
            result = left / right;
        } else if (ctx.op.getType() == 32) {
            result = left % right;
        } else {
            throw new EvaluateRuntimeException("Unrecognised token " + ctx.op.getText());
        }
        if (ExpressionsVisitor.isWholeNumber(result)) {
            return new LongNode((long)result);
        }
        return new DoubleNode(result);
    }

    @Override
    public JsonNode visitNull(MappingExpressionParser.NullContext ctx) {
        return NullNode.getInstance();
    }

    @Override
    public JsonNode visitNumber(MappingExpressionParser.NumberContext ctx) {
        return NumberUtils.convertNumberToValueNode(ctx.NUMBER().getText());
    }

    @Override
    public JsonNode visitObject_constructor(MappingExpressionParser.Object_constructorContext ctx) {
        ObjectNode object = this.factory.objectNode();
        if (ctx.fieldList() == null) {
            return object;
        }
        List keys = ctx.fieldList().STRING().stream().map(k -> k.getText()).map(k -> ExpressionsVisitor.sanitise(k)).collect(Collectors.toList());
        List values = ctx.fieldList().expr().stream().map(e -> (JsonNode)this.visit((ParseTree)e)).collect(Collectors.toList());
        if (keys.size() != values.size()) {
            throw new EvaluateRuntimeException("Object key/value count mismatch!");
        }
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            JsonNode value = (JsonNode)values.get(i);
            object.set(key, value);
        }
        return object;
    }

    @Override
    public JsonNode visitParens(MappingExpressionParser.ParensContext ctx) {
        JsonNode result = null;
        List<MappingExpressionParser.ExprContext> expressions = ctx.expr();
        for (int i = 0; i < expressions.size(); ++i) {
            result = (JsonNode)this.visit(ctx.expr(i));
        }
        if (result instanceof SelectorArrayNode) {
            ArrayNode newResult = this.factory.arrayNode();
            newResult.addAll((SelectorArrayNode)result);
            result = newResult;
        }
        return result;
    }

    @Override
    public JsonNode visitPath(MappingExpressionParser.PathContext ctx) {
        String METHOD = "visitPath";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitPath", ctx.getText());
        }
        MappingExpressionParser.ExprContext lhsCtx = ctx.expr(0);
        MappingExpressionParser.ExprContext rhsCtx = ctx.expr(1);
        JsonNode lhs = (JsonNode)this.visit(lhsCtx);
        if (lhs == null || lhs.isNull()) {
            return null;
        }
        switch (lhs.getNodeType()) {
            case BOOLEAN: 
            case NULL: 
            case NUMBER: {
                throw new EvaluateRuntimeException(String.format("The literal value %s cannot be used as a step within a path expression", lhs.toString()));
            }
        }
        JsonNode rhs = this.resolvePath(lhs, rhsCtx);
        Object result = rhs == null ? null : (rhs instanceof SelectorArrayNode && rhs.size() == 0 ? null : rhs);
        result = ExpressionsVisitor.unwrapArray(result);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitPath", result);
        }
        return result;
    }

    @Override
    public JsonNode visitReduce_function(MappingExpressionParser.Reduce_functionContext ctx) {
        TerminalNode varid;
        JsonNode result = null;
        MappingExpressionParser.VarListContext varList = ctx.varList();
        List<MappingExpressionParser.ExprListContext> exprListContext = ctx.exprList();
        MappingExpressionParser.ExprListContext exprList = exprListContext.get(0);
        boolean useContext = ctx.getParent() instanceof MappingExpressionParser.Fct_chainContext || ctx.getParent() instanceof MappingExpressionParser.PathContext;
        JsonNode arrayObj = null;
        arrayObj = useContext ? FunctionUtils.getContextVariable(this) : (JsonNode)this.visit(exprList.expr(0));
        if (arrayObj == null || !arrayObj.isArray()) {
            throw new EvaluateRuntimeException(String.format("Argument 1 of function %s does not match function signature", "$filter"));
        }
        ArrayNode mapArray = (ArrayNode)arrayObj;
        MappingExpressionParser.ExprListContext fctBody = null;
        if (exprListContext.size() > (useContext ? 0 : 1)) {
            fctBody = exprListContext.get(useContext ? 0 : 1);
        }
        int startIndex = 1;
        MappingExpressionParser.ExprOrSeqContext init = null;
        JsonNode prevResult = mapArray.get(0);
        List<MappingExpressionParser.ExprOrSeqContext> exprSeqList = ctx.exprOrSeq();
        if (exprSeqList.size() > 0) {
            init = exprSeqList.get(0);
            prevResult = (JsonNode)this.visit(init);
            startIndex = 0;
        }
        if ((varid = ctx.VAR_ID()) != null) {
            Function function = Constants.FUNCTIONS.get(varid.getText());
            if (function != null) {
                for (int i = startIndex; i < mapArray.size(); ++i) {
                    MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                    JsonNode element = mapArray.get(i);
                    prevResult = FunctionUtils.processFctCallVariables(this, function, varid, callCtx, prevResult, element);
                }
            } else {
                DeclaredFunction fct = this.functionMap.get(varid.getText());
                if (fct == null) {
                    throw new EvaluateRuntimeException("Expected function variable reference " + varid.getText() + " to resolve to a declared function.");
                }
                for (int i = startIndex; i < mapArray.size(); ++i) {
                    JsonNode element = mapArray.get(i);
                    MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                    evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, prevResult, element);
                    prevResult = fct.invoke(this, evc);
                }
            }
        } else {
            DeclaredFunction fct = new DeclaredFunction(varList, fctBody);
            for (int i = startIndex; i < mapArray.size(); ++i) {
                JsonNode element = mapArray.get(i);
                MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, prevResult, element);
                prevResult = fct.invoke(this, evc);
            }
        }
        result = prevResult;
        return result;
    }

    @Override
    public JsonNode visitRoot_path(MappingExpressionParser.Root_pathContext ctx) {
        String METHOD = "visitRoot_path";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitRoot_path", ctx.getText());
        }
        MappingExpressionParser.ExprContext lhsCtx = ctx.expr();
        Stack<JsonNode> tmpStack = new Stack<JsonNode>();
        for (int stackSize = this.stack.size(); stackSize > 1; --stackSize) {
            tmpStack.push(this.stack.pop());
        }
        JsonNode result = (JsonNode)this.visit(lhsCtx);
        while (!tmpStack.isEmpty()) {
            this.stack.push((JsonNode)tmpStack.pop());
        }
        result = ExpressionsVisitor.unwrapArray(result);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitRoot_path", result);
        }
        return result;
    }

    @Override
    public JsonNode visitSeq(MappingExpressionParser.SeqContext ctx) {
        JsonNode start = (JsonNode)this.visit(ctx.expr(0));
        JsonNode end = (JsonNode)this.visit(ctx.expr(1));
        if (start == null || end == null) {
            return null;
        }
        if (!ExpressionsVisitor.isWholeNumber(start)) {
            throw new EvaluateRuntimeException(ERR_SEQ_LHS_INTEGER);
        }
        if (!ExpressionsVisitor.isWholeNumber(end)) {
            throw new EvaluateRuntimeException(ERR_SEQ_RHS_INTEGER);
        }
        ArrayNode result = this.factory.arrayNode();
        for (int i = start.asInt(); i <= end.asInt(); ++i) {
            result.add(new LongNode(i));
        }
        return result;
    }

    @Override
    public JsonNode visitSift_function(MappingExpressionParser.Sift_functionContext ctx) {
        TerminalNode varid;
        ObjectNode resultObject = new ObjectNode(JsonNodeFactory.instance);
        MappingExpressionParser.VarListContext varList = ctx.varList();
        List<MappingExpressionParser.ExprListContext> exprListContext = ctx.exprList();
        MappingExpressionParser.ExprListContext exprList = exprListContext.get(0);
        boolean useContext = ctx.getParent() instanceof MappingExpressionParser.Fct_chainContext || ctx.getParent() instanceof MappingExpressionParser.PathContext;
        JsonNode objNode = null;
        objNode = useContext ? FunctionUtils.getContextVariable(this) : (JsonNode)this.visit(exprList.expr(0));
        if (objNode == null || !objNode.isObject()) {
            throw new EvaluateRuntimeException(String.format("Argument 1 of function %s does not match function signature", "$filter"));
        }
        ObjectNode object = (ObjectNode)objNode;
        MappingExpressionParser.ExprListContext fctBody = null;
        if (exprListContext.size() > (useContext ? 0 : 1)) {
            fctBody = exprListContext.get(useContext ? 0 : 1);
        }
        if ((varid = ctx.VAR_ID()) != null) {
            Function function = Constants.FUNCTIONS.get(varid.getText());
            JsonNode fctResult = null;
            if (function != null) {
                Iterator<String> it = object.fieldNames();
                while (it.hasNext()) {
                    MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                    String key = it.next();
                    JsonNode field = object.get(key);
                    fctResult = FunctionUtils.processFctCallVariables(this, function, varid, callCtx, field, key, object);
                    if (fctResult == null || !fctResult.asBoolean()) continue;
                    resultObject.set(key, field);
                }
            } else {
                DeclaredFunction fct = this.functionMap.get(varid.getText());
                if (fct == null) {
                    throw new EvaluateRuntimeException("Expected function variable reference " + varid.getText() + " to resolve to a declared function.");
                }
                int varCount = fct.getVariableCount();
                Iterator<String> it = object.fieldNames();
                while (it.hasNext()) {
                    String key = it.next();
                    JsonNode field = object.get(key);
                    MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                    switch (varCount) {
                        case 1: {
                            evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, field);
                            break;
                        }
                        case 2: {
                            evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, field);
                            evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                            break;
                        }
                        case 3: {
                            evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, field);
                            evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                            evc = FunctionUtils.addObjectExprVarContext(ctx, evc, object);
                        }
                    }
                    if ((fctResult = fct.invoke(this, evc)) == null || !fctResult.asBoolean()) continue;
                    resultObject.set(key, field);
                }
            }
        } else {
            DeclaredFunction fct = new DeclaredFunction(varList, fctBody);
            int varCount = fct.getVariableCount();
            Iterator<String> it = object.fieldNames();
            while (it.hasNext()) {
                JsonNode fctResult;
                String key = it.next();
                JsonNode field = object.get(key);
                MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                switch (varCount) {
                    case 1: {
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, field);
                        break;
                    }
                    case 2: {
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, field);
                        evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                        break;
                    }
                    case 3: {
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, field);
                        evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                        evc = FunctionUtils.addObjectExprVarContext(ctx, evc, object);
                    }
                }
                if ((fctResult = fct.invoke(this, evc)) == null || !fctResult.asBoolean()) continue;
                resultObject.set(key, field);
            }
        }
        return resultObject;
    }

    @Override
    public JsonNode visitString(MappingExpressionParser.StringContext ctx) {
        String val = ctx.getText();
        val = ExpressionsVisitor.sanitise(val);
        return TextNode.valueOf(val);
    }

    @Override
    public JsonNode visitTo_array(MappingExpressionParser.To_arrayContext ctx) {
        JsonNode result = null;
        MappingExpressionParser.ExprContext expr = ctx.expr();
        if (expr instanceof MappingExpressionParser.PathContext) {
            JsonNode tmpResult = (JsonNode)this.visit(expr);
            if (tmpResult instanceof SelectorArrayNode) {
                result = tmpResult;
            } else {
                result = JsonNodeFactory.instance.arrayNode();
                ((ArrayNode)result).add((JsonNode)this.visit(expr));
            }
        } else {
            result = (JsonNode)this.visit(expr);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode visitUnary_op(MappingExpressionParser.Unary_opContext ctx) {
        void var2_6;
        Object var2_2 = null;
        JsonNode operand = (JsonNode)this.visit(ctx.expr());
        if (ctx.op.getType() != 31) return var2_6;
        if (operand == null) {
            return null;
        }
        if (operand.isFloatingPointNumber()) {
            DoubleNode doubleNode = new DoubleNode(-operand.asDouble());
            return var2_6;
        } else {
            if (!operand.isIntegralNumber()) throw new EvaluateRuntimeException(ERR_NEGATE_NON_NUMERIC);
            LongNode longNode = new LongNode(-operand.asLong());
        }
        return var2_6;
    }

    @Override
    public JsonNode visitVar_assign(MappingExpressionParser.Var_assignContext ctx) {
        String varName = ctx.VAR_ID().getText();
        JsonNode result = null;
        MappingExpressionParser.ExprContext expr = ctx.expr();
        if (expr instanceof MappingExpressionParser.Function_declContext) {
            MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)expr;
            MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
            MappingExpressionParser.ExprListContext exprList = fctDeclCtx.exprList();
            DeclaredFunction fct = new DeclaredFunction(varList, exprList);
            this.functionMap.put(varName, fct);
        } else {
            result = (JsonNode)this.visit(expr);
            this.variableMap.put(varName, result);
        }
        return result;
    }

    @Override
    public JsonNode visitVar_recall(MappingExpressionParser.Var_recallContext ctx) {
        String varName = ctx.getText();
        JsonNode result = this.variableMap.get(varName);
        if (result == null) {
            throw new EvaluateRuntimeException(varName + " is unknown (e.g., unassigned variable)");
        }
        return result;
    }

    public static class SelectorArrayNode
    extends ArrayNode {
        private List<JsonNode> selectionGroups = new ArrayList<JsonNode>();

        public SelectorArrayNode(JsonNodeFactory nc) {
            super(nc);
        }

        public void addAsSelectionGroup(JsonNode group) {
            if (group.isArray()) {
                this.addAll((ArrayNode)group);
            } else {
                this.add(group);
            }
            this.selectionGroups.add(group);
        }

        public List<JsonNode> getSelectionGroups() {
            return Collections.unmodifiableList(this.selectionGroups);
        }
    }
}

