/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Iterator;

public class MinFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$min");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$min");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$min");
    public static final String ERR_ARG_TYPE = String.format("Argument 1 of function \"%s\" must be an array of \"number\"", "$min");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode result = null;
        NullNode argArray = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argArray = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount != 1) throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG2BADTYPE);
        if (!useContext) {
            argArray = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argArray == null) return result;
        if (!argArray.isArray()) throw new EvaluateRuntimeException(ERR_ARG_TYPE);
        ArrayNode items = (ArrayNode)argArray;
        if (items.size() <= 0) throw new EvaluateRuntimeException(ERR_ARG_TYPE);
        JsonNode min = null;
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            JsonNode item = (JsonNode)iterator.next();
            if (!item.isNumber()) throw new EvaluateRuntimeException(ERR_ARG_TYPE);
            if (min != null && !(item.asDouble() < min.asDouble())) continue;
            min = item;
        }
        return min;
    }

    @Override
    public String getSignature() {
        return "<a<n>:n>";
    }
}

