/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.api.jsonata4java.expressions.utils.NumberUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;

public class NumberFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$number");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$number");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$number");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode result = null;
        JsonNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount != 1) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        if (!useContext) {
            argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argString == null) return result;
        if (argString.isObject()) {
            throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        }
        if (argString.isTextual()) {
            return NumberUtils.convertNumberToValueNode(argString.asText());
        }
        if (argString.isNumber()) {
            return argString;
        }
        if (!argString.isArray()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
    }

    @Override
    public String getSignature() {
        return "<(nsb)-:n>";
    }
}

