/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions;

import com.api.jsonata4java.expressions.BufferingErrorListener;
import com.api.jsonata4java.expressions.EvaluateException;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.ParseException;
import com.api.jsonata4java.expressions.generated.MappingExpressionLexer;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ErrorNodeImpl;
import org.antlr.v4.runtime.tree.ParseTree;

public class Expressions {
    ParseTree tree = null;
    String expression = null;
    ExpressionsVisitor _eval = new ExpressionsVisitor((JsonNode)JsonNodeFactory.instance.objectNode());

    public static List<String> getRefsInExpression(Pattern refPattern, String expression) {
        Matcher matcher = refPattern.matcher(expression);
        LinkedList<String> matches = new LinkedList<String>();
        while (matcher.find()) {
            matches.add(matcher.group(1));
        }
        return matches;
    }

    public Expressions(ParseTree aTree, String anExpression) {
        this.tree = aTree;
        this.expression = anExpression;
    }

    public static Expressions parse(String mappingExpression) throws ParseException {
        ANTLRInputStream input = new ANTLRInputStream(mappingExpression);
        MappingExpressionLexer lexer = new MappingExpressionLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        MappingExpressionParser parser = new MappingExpressionParser((TokenStream)tokens);
        MappingExpressionParser.ExprContext tree = null;
        BufferingErrorListener errorListener = new BufferingErrorListener();
        try {
            parser.removeErrorListeners();
            lexer.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)errorListener);
            lexer.addErrorListener((ANTLRErrorListener)errorListener);
            tree = parser.expr();
            if (errorListener.heardErrors()) {
                ParseTree error;
                if (tree != null && tree.getChildCount() > 0 && (error = tree.getChild(0)) instanceof ErrorNodeImpl && ((ErrorNodeImpl)error).getSymbol().getType() == 27) {
                    throw new EvaluateRuntimeException("The symbol \"~>\" cannot be used as a unary operator");
                }
                throw new ParseException(errorListener.getErrorsAsString());
            }
        }
        catch (RecognitionException e) {
            throw new ParseException(e.getMessage());
        }
        return new Expressions((ParseTree)tree, mappingExpression);
    }

    public JsonNode evaluate(JsonNode rootContext, long timeoutMS, int maxDepth) throws EvaluateException {
        ExpressionsVisitor eval;
        JsonNode result = null;
        this._eval = eval = new ExpressionsVisitor(rootContext);
        if (timeoutMS <= 0L) {
            throw new EvaluateException("The timeoutMS must be a positive number. Received " + timeoutMS);
        }
        if (maxDepth <= 0) {
            throw new EvaluateException("The maxDepth must be a positive number. Received " + maxDepth);
        }
        this._eval.timeboxExpression(timeoutMS, maxDepth);
        try {
            result = this._eval.visit(this.tree);
        }
        catch (EvaluateRuntimeException e) {
            throw new EvaluateException(e.getMessage(), e);
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    public JsonNode evaluate(JsonNode rootContext) throws EvaluateException {
        ExpressionsVisitor eval;
        JsonNode result = null;
        this._eval = eval = new ExpressionsVisitor(rootContext);
        try {
            result = this._eval.visit(this.tree);
        }
        catch (EvaluateRuntimeException e) {
            throw new EvaluateException(e.getMessage(), e);
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    public ExpressionsVisitor getExpr() {
        return this._eval;
    }

    public void setExpr(ExpressionsVisitor expr) {
        this._eval = expr;
    }

    public ParseTree getTree() {
        return this.tree;
    }

    public void setTree(ParseTree parsetree) {
        this.tree = parsetree;
    }

    public void timeboxExpression(long timeoutMS, int maxDepth) {
        this._eval.timeboxExpression(timeoutMS, maxDepth);
    }

    public String toString() {
        return this.expression;
    }
}

