/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.ArrayUtils;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;

public class ZipFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$zip");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$zip");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        ArrayNode inputArrays = JsonNodeFactory.instance.arrayNode();
        JsonNode argObject = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argObject = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount > 0) {
            int i;
            int minSize = Integer.MAX_VALUE;
            ArrayNode a = null;
            if (useContext) {
                a = ArrayUtils.ensureArray(argObject);
                if (a.size() < minSize) {
                    minSize = a.size();
                }
                inputArrays.add(a);
            }
            int n = i = useContext ? 1 : 0;
            while (i < argCount) {
                a = ArrayUtils.ensureArray(expressionVisitor.visit(ctx.exprValues().exprList().expr(useContext ? i - 1 : i)));
                if (a.size() < minSize) {
                    minSize = a.size();
                }
                inputArrays.add(a);
                ++i;
            }
            for (int j = 0; j < minSize; ++j) {
                ArrayNode cell = JsonNodeFactory.instance.arrayNode();
                for (int i2 = 0; i2 < inputArrays.size(); ++i2) {
                    cell.add(((ArrayNode)inputArrays.get(i2)).get(j));
                }
                result.add(cell);
            }
        } else {
            throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        }
        ArrayNode temp = JsonNodeFactory.instance.arrayNode();
        temp.add(result);
        result = temp;
        return result;
    }

    @Override
    public String getSignature() {
        return "<a+:a>";
    }
}

