/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;

public class MergeFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$merge");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$merge");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$merge");
    public static String ERR_ARG1_MUST_BE_OBJECT_ARRAY = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$merge");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        JsonNode argArray = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argArray = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount != 1) throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG2BADTYPE);
        if (!useContext) {
            argArray = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        String key = null;
        if (argArray == null) {
            return null;
        }
        if (argArray.isArray()) {
            ArrayNode array = (ArrayNode)argArray;
            int i = 0;
            while (i < array.size()) {
                JsonNode obj = array.get(i);
                if (!obj.isObject()) throw new EvaluateRuntimeException(ERR_ARG1_MUST_BE_OBJECT_ARRAY);
                ObjectNode cell = (ObjectNode)obj;
                Iterator<String> it = cell.fieldNames();
                while (it.hasNext()) {
                    key = it.next();
                    result.set(key, cell.get(key));
                }
                ++i;
            }
            return result;
        }
        if (!argArray.isObject()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        return (ObjectNode)argArray;
    }

    @Override
    public String getSignature() {
        return "<a<0>-:o>";
    }
}

