/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.Constants;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ReduceFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$spread");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$spread");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$spread");
    public static String ERR_ARG1_MUST_BE_ARRAY_OF_OBJECTS = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$spread");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode prevResult;
        block9: {
            MappingExpressionParser.ExprContext varid;
            ArrayNode mapArray;
            MappingExpressionParser.ExprListContext exprList;
            boolean useContext;
            block8: {
                useContext = ctx.getParent() instanceof MappingExpressionParser.Fct_chainContext || ctx.getParent() instanceof MappingExpressionParser.PathContext;
                JsonNode arrNode = null;
                MappingExpressionParser.ExprValuesContext valuesCtx = ctx.exprValues();
                exprList = valuesCtx.exprList();
                arrNode = useContext ? FunctionUtils.getContextVariable(expressionVisitor) : expressionVisitor.visit(exprList.expr(0));
                if (arrNode == null || !arrNode.isArray()) {
                    throw new EvaluateRuntimeException(String.format("Argument 1 of function %s does not match function signature", "$filter"));
                }
                mapArray = (ArrayNode)arrNode;
                int startIndex = 1;
                MappingExpressionParser.NumberContext init = null;
                prevResult = mapArray.get(0);
                MappingExpressionParser.ExprContext initCtx = exprList.expr(useContext ? 1 : 2);
                if (initCtx != null) {
                    init = (MappingExpressionParser.NumberContext)initCtx;
                    prevResult = expressionVisitor.visit(init);
                    startIndex = 0;
                }
                if (!((varid = exprList.expr(useContext ? 0 : 1)) instanceof MappingExpressionParser.Var_recallContext)) break block8;
                TerminalNode VAR_ID = ((MappingExpressionParser.Var_recallContext)varid).VAR_ID();
                String varID = varid.getText();
                Function function = Constants.FUNCTIONS.get(varid.getText());
                if (function != null) {
                    for (int i = startIndex; i < mapArray.size(); ++i) {
                        MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                        JsonNode element = mapArray.get(i);
                        prevResult = FunctionUtils.processFctCallVariables(expressionVisitor, function, VAR_ID, callCtx, prevResult, element);
                    }
                } else {
                    DeclaredFunction fct = expressionVisitor.functionMap.get(varID);
                    if (fct == null) {
                        throw new EvaluateRuntimeException("Expected function variable reference " + varID + " to resolve to a declared function.");
                    }
                    for (int i = startIndex; i < mapArray.size(); ++i) {
                        JsonNode element = mapArray.get(i);
                        MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, prevResult, element);
                        prevResult = fct.invoke(expressionVisitor, evc);
                    }
                }
                break block9;
            }
            if (!(varid instanceof MappingExpressionParser.Function_declContext)) break block9;
            MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)exprList.expr(useContext ? 0 : 1);
            MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
            MappingExpressionParser.ExprListContext fctBody = fctDeclCtx.exprList();
            DeclaredFunction fct = new DeclaredFunction(varList, fctBody);
            for (int i = startIndex; i < mapArray.size(); ++i) {
                JsonNode element = mapArray.get(i);
                MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, prevResult, element);
                prevResult = fct.invoke(expressionVisitor, evc);
            }
        }
        return prevResult;
    }

    @Override
    public String getSignature() {
        return "<x-:a<o>";
    }

    public void addObject(ArrayNode result, ObjectNode obj) {
        Iterator<String> it = obj.fieldNames();
        while (it.hasNext()) {
            String key = it.next();
            ObjectNode cell = JsonNodeFactory.instance.objectNode();
            cell.set(key, obj.get(key));
            result.add(cell);
        }
    }
}

