/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;

public class SpreadFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$spread");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$spread");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$spread");
    public static String ERR_ARG1_MUST_BE_ARRAY_OF_OBJECTS = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$spread");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        JsonNode argObject = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argObject = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        boolean argIsArray = false;
        if (argCount != 1) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        if (!useContext) {
            argObject = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argObject.isObject()) {
            ObjectNode obj = (ObjectNode)argObject;
            if (obj.size() <= 0) return null;
            this.addObject(result, obj);
        } else if (argObject.isArray()) {
            argIsArray = true;
            ArrayNode objArray = (ArrayNode)argObject;
            if (objArray.size() == 0) {
                return null;
            }
            for (int i = 0; i < objArray.size(); ++i) {
                JsonNode node = objArray.get(i);
                if (node.isObject()) {
                    ObjectNode obj = (ObjectNode)node;
                    this.addObject(result, obj);
                    continue;
                }
                result.add(node);
            }
        } else {
            result.add(argObject);
        }
        if (argIsArray) return result;
        JsonNode test = ExpressionsVisitor.unwrapArray(result);
        if (!test.isArray()) return test;
        return (ArrayNode)test;
    }

    @Override
    public String getSignature() {
        return "<x-:a<o>";
    }

    public void addObject(ArrayNode result, ObjectNode obj) {
        Iterator<String> it = obj.fieldNames();
        while (it.hasNext()) {
            String key = it.next();
            ObjectNode cell = JsonNodeFactory.instance.objectNode();
            cell.set(key, obj.get(key));
            result.add(cell);
        }
    }
}

