/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.JS4JDate;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.utils.Constants;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class FrameEnvironment {
    private Map<String, DeclaredFunction> _declFunctionMap = new HashMap<String, DeclaredFunction>();
    FrameEnvironment _enclosingFrame = null;
    private boolean _isAsync = false;
    private Map<String, Function> _jsonataFunctionMap = new HashMap<String, Function>();
    private Stack<JsonNode> _stack = new Stack();
    private JS4JDate _timestamp = null;
    private Map<String, JsonNode> _variableMap = new HashMap<String, JsonNode>();

    public FrameEnvironment(FrameEnvironment enclosingFrame) {
        this._enclosingFrame = enclosingFrame;
        this._declFunctionMap = new HashMap<String, DeclaredFunction>();
        this._jsonataFunctionMap = new HashMap<String, Function>();
        this._variableMap = new HashMap<String, JsonNode>();
        if (enclosingFrame == null) {
            this._timestamp = new JS4JDate();
        }
    }

    public boolean async() {
        return this._isAsync;
    }

    public void clearContext() {
        if (this._enclosingFrame != null) {
            Stack<JsonNode> stack = this._enclosingFrame.getContextStack();
            stack.clear();
            return;
        }
        this._stack.clear();
    }

    public Stack<JsonNode> getContextStack() {
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.getContextStack();
        }
        return this._stack;
    }

    public DeclaredFunction getDeclaredFunction(String fctName) {
        DeclaredFunction retFct = this._declFunctionMap.get(fctName);
        if (retFct != null || this._declFunctionMap.containsKey(fctName)) {
            return retFct;
        }
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.getDeclaredFunction(fctName);
        }
        return null;
    }

    public Function getJsonataFunction(String fctName) {
        Function fct = this._jsonataFunctionMap.get(fctName);
        if (fct != null || this._jsonataFunctionMap.containsKey(fctName)) {
            return fct;
        }
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.getJsonataFunction(fctName);
        }
        fct = Constants.FUNCTIONS.get(fctName);
        if (fct != null) {
            return fct;
        }
        return null;
    }

    public JsonNode getVariable(String varName) {
        if ("$".equals(varName)) {
            JsonNode result = this.getContextStack().peek();
            return result;
        }
        if ("$$".equals(varName)) {
            Stack<JsonNode> stack = this.getContextStack();
            if (stack.isEmpty()) {
                return null;
            }
            JsonNode result = (JsonNode)this.getContextStack().get(0);
            return result;
        }
        JsonNode retVar = this._variableMap.get(varName);
        if (retVar != null || this._variableMap.containsKey(varName)) {
            return retVar;
        }
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.getVariable(varName);
        }
        return null;
    }

    public boolean isEmptyContext() {
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.isEmptyContext();
        }
        return this._stack.isEmpty();
    }

    public Long millis() {
        if (this._timestamp != null) {
            return this._timestamp.getTime();
        }
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.millis();
        }
        return null;
    }

    public String now() {
        if (this._timestamp != null) {
            return this._timestamp.toString();
        }
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.now();
        }
        return null;
    }

    public JsonNode peekContext() {
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.peekContext();
        }
        if (this.isEmptyContext()) {
            return null;
        }
        return this._stack.peek();
    }

    public JsonNode popContext() {
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.popContext();
        }
        return this._stack.pop();
    }

    public JsonNode pushContext(JsonNode context) {
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.pushContext(context);
        }
        return this._stack.push(context);
    }

    public void setAsync(boolean isAsync) {
        this._isAsync = isAsync;
    }

    public void setDeclaredFunction(String fctName, DeclaredFunction fctValue) throws EvaluateRuntimeException {
        if (fctName == null) {
            throw new EvaluateRuntimeException("function name is null.");
        }
        if (fctValue == null) {
            throw new EvaluateRuntimeException("function value is null.");
        }
        this._declFunctionMap.put(fctName, fctValue);
    }

    public void setJsonataFunction(String fctName, Function fctValue) throws EvaluateRuntimeException {
        if (fctName == null) {
            throw new EvaluateRuntimeException("function name is null.");
        }
        if (fctValue == null) {
            throw new EvaluateRuntimeException("function value is null.");
        }
        this._jsonataFunctionMap.put(fctName, fctValue);
    }

    public void setVariable(String varName, JsonNode varValue) throws EvaluateRuntimeException {
        if (varName == null) {
            throw new EvaluateRuntimeException("variable name is null.");
        }
        this._variableMap.put(varName, varValue);
    }

    public int sizeContext() {
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.sizeContext();
        }
        return this._stack.size();
    }
}

