/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;

public class TypeFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$type");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$type");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$type");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        NullNode arg = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = TypeFunction.getArgumentCount(ctx);
        if (useContext) {
            arg = FunctionUtils.getContextVariable(expressionVisitor);
            if (arg != null && !arg.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount == 1) {
            MappingExpressionParser.ExprValuesContext valuesCtx;
            MappingExpressionParser.ExprListContext exprList;
            List<MappingExpressionParser.ExprContext> exprCtxList;
            if (!useContext) {
                arg = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if ((exprCtxList = (exprList = (valuesCtx = ctx.exprValues()).exprList()).expr()).size() > 0) {
                MappingExpressionParser.ExprContext exprCtx = exprCtxList.get(0);
                if (exprCtx instanceof MappingExpressionParser.Function_callContext) {
                    result = new TextNode("function");
                } else if (exprCtx instanceof MappingExpressionParser.Var_recallContext && exprCtx.getChildCount() > 0) {
                    String varID = exprCtx.getChild(0).getText();
                    DeclaredFunction declFct = expressionVisitor.getDeclaredFunction(varID);
                    if (declFct != null) {
                        result = new TextNode("function");
                    } else {
                        Function fct = expressionVisitor.getJsonataFunction(varID);
                        if (fct != null) {
                            result = new TextNode("function");
                        } else {
                            arg = expressionVisitor.getVariable(varID);
                        }
                    }
                }
            }
            if (result == null) {
                if (arg != null) {
                    switch (arg.getNodeType()) {
                        case ARRAY: {
                            result = new TextNode("array");
                            break;
                        }
                        case OBJECT: {
                            result = new TextNode("object");
                            break;
                        }
                        case STRING: {
                            result = new TextNode("string");
                            break;
                        }
                        case NUMBER: {
                            result = new TextNode("number");
                            break;
                        }
                        case BOOLEAN: {
                            result = new TextNode("boolean");
                            break;
                        }
                        case BINARY: {
                            break;
                        }
                        case NULL: {
                            result = new TextNode("null");
                            break;
                        }
                        case POJO: {
                            result = new TextNode("undefined");
                            break;
                        }
                        case MISSING: {
                            result = new TextNode("undefined");
                            break;
                        }
                        default: {
                            result = new TextNode("undefined");
                            break;
                        }
                    }
                } else {
                    result = null;
                }
            }
        } else if (argCount != 0) {
            throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<x:n>";
    }
}

