/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.FrameEnvironment;
import com.api.jsonata4java.expressions.NonNumericArrayIndexException;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.generated.MappingExpressionBaseVisitor;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.BooleanUtils;
import com.api.jsonata4java.expressions.utils.Constants;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.api.jsonata4java.expressions.utils.NumberUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.apache.commons.text.StringEscapeUtils;

public class ExpressionsVisitor
extends MappingExpressionBaseVisitor<JsonNode> {
    private static final String _pattern = "#0.##";
    private static final DecimalFormat _decimalFormat = new DecimalFormat("#0.##");
    private static final String CLASS = ExpressionsVisitor.class.getName();
    public static final String ERR_MSG_INVALID_PATH_ENTRY = String.format("The literal value %s cannot be used as a step within a path expression", (Object[])null);
    public static final String ERR_NEGATE_NON_NUMERIC = "Cannot negate a non-numeric value";
    public static final String ERR_SEQ_LHS_INTEGER = "The left side of the range operator (..) must evaluate to an integer";
    public static final String ERR_SEQ_RHS_INTEGER = "The right side of the range operator (..) must evaluate to an integer";
    public static final String ERR_TOO_BIG = "The size of the sequence allocated by the range operator (..) must not exceed 1e6.  Attempted to allocate ";
    private static final Logger LOG = Logger.getLogger(CLASS);
    private static final Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private FrameEnvironment _environment = null;
    private boolean checkRuntime = false;
    private int currentDepth = 0;
    private JsonNodeFactory factory = JsonNodeFactory.instance;
    private boolean firstStep = false;
    private boolean firstStepCons = false;
    private Deque<Boolean> inArrayConstructStack = new LinkedList<Boolean>();
    private boolean keepArray = false;
    private boolean lastStep = false;
    private boolean lastStepCons = false;
    private int maxDepth = -1;
    private long maxTime = 0L;
    private long startTime = System.currentTimeMillis();
    private List<ParseTree> steps = new ArrayList<ParseTree>();
    private ParseTreeProperty<Integer> values = new ParseTreeProperty();
    private String lastVisited = "";

    private static boolean areJsonNodesEqual(JsonNode left, JsonNode right) {
        if (left.isFloatingPointNumber() || right.isFloatingPointNumber()) {
            return left.asDouble() == right.asDouble();
        }
        if (left.isDouble() || right.isDouble()) {
            return left.asDouble() == right.asDouble();
        }
        if (left.isIntegralNumber() && right.isIntegralNumber()) {
            return left.asLong() == right.asLong();
        }
        if (left.isLong() && right.isLong()) {
            return left.asLong() == right.asLong();
        }
        if (left.isNull()) {
            return right.isNull();
        }
        if (right.isNull()) {
            return left.isNull();
        }
        if (left.isTextual() && right.isTextual()) {
            return left.asText().equals(right.asText());
        }
        if (left.isArray() && right.isArray()) {
            return left.equals(right);
        }
        if (left.isObject() && right.isObject()) {
            return left.equals(right);
        }
        if (left.isBoolean() && right.isBoolean()) {
            return left == right;
        }
        return false;
    }

    public static String castString(JsonNode node, boolean prettify) throws EvaluateRuntimeException {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case STRING: {
                return node.textValue();
            }
            case NUMBER: {
                if (!node.isDouble()) break;
                Double dValue = node.asDouble();
                if (Double.isInfinite(dValue) || Double.isNaN(dValue)) {
                    throw new EvaluateRuntimeException("Attempting to invoke string function on Infinity or NaN");
                }
                String test = dValue.toString();
                String strVal = "";
                int index = test.indexOf("E");
                String expStr = ".e+";
                if (index >= 0) {
                    int len;
                    int minusSize = dValue < 0.0 ? 1 : 0;
                    int exp = new Integer(test.substring(index + 1));
                    if (exp < 0) {
                        expStr = ".e";
                    }
                    if ((len = test.indexOf(".")) - minusSize + Math.abs(exp) <= 21) {
                        if (exp > 0) {
                            strVal = _decimalFormat.format(dValue);
                            return strVal;
                        }
                        if (exp > -7) {
                            strVal = new BigDecimal(dValue, new MathContext(15)).toString().toLowerCase();
                            if (strVal.indexOf(".") >= 0) {
                                while (strVal.endsWith("0") && strVal.length() > 0) {
                                    strVal = strVal.substring(0, strVal.length() - 1);
                                }
                            }
                            return strVal;
                        }
                    }
                    strVal = test.indexOf(".0E") > 0 ? test.substring(0, len) + expStr.substring(1) + test.substring(index + 1) : test.substring(0, index) + expStr + test.substring(index + 1);
                } else if (prettify) {
                    strVal = _decimalFormat.format(dValue);
                } else {
                    strVal = new BigDecimal(dValue, new MathContext(15)).toString().toLowerCase();
                    if (strVal.indexOf(".") >= 0) {
                        while (strVal.endsWith("0") && strVal.length() > 0) {
                            strVal = strVal.substring(0, strVal.length() - 1);
                        }
                    }
                }
                return strVal;
            }
        }
        try {
            if (prettify) {
                JsonElement jsonElt = JsonParser.parseString(objectMapper.writeValueAsString(node));
                return gson.toJson(jsonElt);
            }
            return objectMapper.writeValueAsString(node);
        }
        catch (JsonProcessingException e) {
            throw new EvaluateRuntimeException("Failed to cast value " + node + " to a string. Reason: " + e.getMessage());
        }
    }

    public static ArrayNode ensureArray(JsonNode input) {
        if (input == null) {
            return null;
        }
        if (input.isArray()) {
            return (ArrayNode)input;
        }
        return JsonNodeFactory.instance.arrayNode().add(input);
    }

    public static SelectorArrayNode ensureSelectorNodeArray(JsonNode input) {
        if (input == null) {
            return null;
        }
        if (input.isArray()) {
            if (input instanceof SelectorArrayNode) {
                return (SelectorArrayNode)input;
            }
            SelectorArrayNode result = new SelectorArrayNode(JsonNodeFactory.instance);
            for (JsonNode elt : (ArrayNode)input) {
                if (elt == null) continue;
                result.addAsSelectionGroup(elt);
            }
            return result;
        }
        SelectorArrayNode result = new SelectorArrayNode(JsonNodeFactory.instance);
        result.addAsSelectionGroup(input);
        return result;
    }

    public static ArrayNode flatten(JsonNode arg, ArrayNode flattened) {
        if (flattened == null) {
            flattened = new ArrayNode(JsonNodeFactory.instance);
        }
        if (arg.isArray()) {
            Iterator<JsonNode> it = ((ArrayNode)arg).iterator();
            while (it.hasNext()) {
                ExpressionsVisitor.flatten(it.next(), flattened);
            }
        } else {
            flattened.add(arg);
        }
        return flattened;
    }

    private static boolean isWholeNumber(double n) {
        return n == Math.rint(n) && !Double.isInfinite(n) && !Double.isNaN(n);
    }

    private static boolean isWholeNumber(JsonNode n) {
        if (n == null) {
            return false;
        }
        if (n.isInt() || n.isLong()) {
            return true;
        }
        return (n.isFloat() || n.isDouble()) && (double)n.asInt() == n.asDouble();
    }

    private static String sanitise(String str) {
        if (str.startsWith("`") && str.endsWith("`") || str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'")) {
            str = str.substring(1, str.length() - 1);
        }
        str = StringEscapeUtils.unescapeJson(str);
        return str;
    }

    public static JsonNode unwrapArray(JsonNode input) {
        if (input == null) {
            return null;
        }
        if (input.isArray()) {
            if (input.size() == 1) {
                return input.get(0);
            }
            return input;
        }
        return input;
    }

    public ExpressionsVisitor() {
        this.setEnvironment(null);
        this.setRootContext(null);
    }

    public ExpressionsVisitor(JsonNode rootContext, FrameEnvironment environment) throws EvaluateRuntimeException {
        this.setEnvironment(environment);
        this.setRootContext(rootContext);
    }

    JsonNode append(JsonNode arg1, JsonNode arg2) {
        ArrayNode tempArray;
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        if (!arg1.isArray()) {
            tempArray = new ArrayNode(JsonNodeFactory.instance);
            tempArray.add(arg1);
            arg1 = tempArray;
        }
        if (!arg2.isArray()) {
            tempArray = new ArrayNode(JsonNodeFactory.instance);
            tempArray.add(arg2);
            arg2 = tempArray;
        }
        return ((ArrayNode)arg1).add((ArrayNode)arg2);
    }

    private void checkRunaway() {
        if (this.checkRuntime && this.maxDepth != -1 && this.currentDepth > this.maxDepth) {
            throw new EvaluateRuntimeException("Stack overflow error: Check for non-terminating recursive function. Consider rewriting as tail-recursive.");
        }
        if (this.maxTime != 0L && System.currentTimeMillis() - this.startTime > this.maxTime) {
            throw new EvaluateRuntimeException("Expression evaluation timeout: Check for infinite loop");
        }
    }

    private void evaluateEntry() {
        ++this.currentDepth;
        this.checkRunaway();
    }

    private void evaluateExit() {
        --this.currentDepth;
        this.checkRunaway();
    }

    public Deque<JsonNode> getContextStack() {
        return this._environment.getContextStack();
    }

    public DeclaredFunction getDeclaredFunction(String fctName) {
        return this._environment.getDeclaredFunction(fctName);
    }

    JsonNode getDescendants() {
        JsonNode startingElt;
        JsonNode result = null;
        ArrayNode resultArray = new ArrayNode(JsonNodeFactory.instance);
        if (!this._environment.isEmptyContext() && (startingElt = this._environment.peekContext()) != null) {
            this.traverseDescendants(startingElt, resultArray);
            result = resultArray.size() == 1 ? resultArray.get(0) : resultArray;
        }
        return result;
    }

    protected FrameEnvironment getEnvironment() {
        return this._environment;
    }

    public Function getJsonataFunction(String fctName) {
        return this._environment.getJsonataFunction(fctName);
    }

    public int getValue(ParseTree node) {
        return this.values.get(node);
    }

    public JsonNode getVariable(String varName) {
        return this._environment.getVariable(varName);
    }

    boolean isSequence(JsonNode node) {
        return node != null && node instanceof SelectorArrayNode;
    }

    JsonNode lookup(JsonNode input, String key) {
        JsonNode result = null;
        if (input.isArray()) {
            result = new SelectorArrayNode(this.factory);
            for (int ii = 0; ii < input.size(); ++ii) {
                JsonNode res = this.lookup(input.get(ii), key);
                if (res == null) continue;
                if (res.isArray()) {
                    ((ArrayNode)result).addAll((ArrayNode)res);
                    continue;
                }
                ((ArrayNode)result).add(res);
            }
        } else if (input != null && input instanceof ObjectNode) {
            result = ((ObjectNode)input).get(key);
        }
        return result;
    }

    protected void processArrayContent(MappingExpressionParser.ExprOrSeqContext expr, ArrayNode output) {
        String testStr = "";
        if (expr.children != null) {
            for (ParseTree tree : expr.children) {
                JsonNode result;
                if (tree == null) {
                    System.out.println("Got null in array values.");
                    continue;
                }
                if (tree instanceof MappingExpressionParser.ExprOrSeqContext) {
                    this.processArrayContent((MappingExpressionParser.ExprOrSeqContext)tree, output);
                }
                if (tree instanceof TerminalNodeImpl && ",[]".indexOf(testStr = tree.toString()) >= 0 || (result = this.visit(tree)) == null) continue;
                if ("visitArray_constructor".equals(this.lastVisited)) {
                    output.add(result);
                    continue;
                }
                result = ExpressionsVisitor.ensureArray(result);
                output.addAll((ArrayNode)result);
            }
        }
    }

    private List<Integer> resolveIndexes(List<Integer> input, int sizeOfSourceArray) {
        ArrayList<Integer> resolvedIndexes = new ArrayList<Integer>();
        for (int i : input) {
            if (i < 0) {
                resolvedIndexes.add(sizeOfSourceArray + i);
                continue;
            }
            resolvedIndexes.add(i);
        }
        Collections.sort(resolvedIndexes);
        return resolvedIndexes;
    }

    private JsonNode resolvePath(JsonNode lhs, MappingExpressionParser.ExprContext rhsCtx) {
        SelectorArrayNode arr;
        JsonNode output;
        String METHOD = "resolvePath";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "resolvePath", new Object[]{lhs, rhsCtx.getText()});
        }
        if (lhs == null) {
            output = null;
        } else if (lhs.isArray()) {
            arr = new SelectorArrayNode(this.factory);
            output = arr;
            for (JsonNode lhsE : lhs) {
                JsonNode rhsE = this.resolvePath(lhsE, rhsCtx);
                if (rhsE == null) continue;
                arr.addAsSelectionGroup(rhsE);
            }
        } else {
            this._environment.pushContext(lhs);
            output = this.visit(rhsCtx);
            this._environment.popContext();
            if (output != null && !output.isArray()) {
                arr = new SelectorArrayNode(this.factory);
                arr.addAsSelectionGroup(output);
                output = arr;
            }
        }
        SelectorArrayNode result = output;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "resolvePath", result);
        }
        return result;
    }

    public void setDeclaredFunction(String fctName, DeclaredFunction fctValue) {
        this._environment.setDeclaredFunction(fctName, fctValue);
    }

    protected void setEnvironment(FrameEnvironment environment) {
        if (environment == null) {
            environment = new FrameEnvironment(null);
        }
        this._environment = environment;
    }

    public void setJsonataFunction(String fctName, Function fctValue) {
        this._environment.setJsonataFunction(fctName, fctValue);
    }

    protected void setRootContext(JsonNode rootContext) {
        this._environment.clearContext();
        if (rootContext != null) {
            this._environment.pushContext(rootContext);
        }
    }

    public void setValue(ParseTree node, int value) {
        this.values.put(node, value);
    }

    public void setVariable(String varName, JsonNode varValue) throws EvaluateRuntimeException {
        this._environment.setVariable(varName, varValue);
    }

    public void timeboxExpression(long timeoutMS, int maxDepth) {
        if (timeoutMS > 0L && maxDepth > 0) {
            this.maxDepth = maxDepth;
            this.maxTime = timeoutMS;
            this.checkRuntime = true;
        }
    }

    void traverseDescendants(JsonNode input, ArrayNode results) {
        block3: {
            block4: {
                if (input == null) break block3;
                if (!input.isArray()) {
                    results.add(input);
                }
                if (!input.isArray()) break block4;
                for (JsonNode member : (ArrayNode)input) {
                    this.traverseDescendants(member, results);
                }
                break block3;
            }
            if (!input.isObject()) break block3;
            Iterator<String> it = ((ObjectNode)input).fieldNames();
            while (it.hasNext()) {
                String key = it.next();
                this.traverseDescendants(((ObjectNode)input).get(key), results);
            }
        }
    }

    @Override
    public JsonNode visit(ParseTree tree) {
        JsonNode result = null;
        if (this.checkRuntime) {
            this.evaluateEntry();
        }
        if (this.steps.size() > 0 && tree.equals(this.steps.get(this.steps.size() - 1))) {
            this.lastStep = true;
        }
        result = (JsonNode)super.visit(tree);
        if (!this.keepArray && result != null && result instanceof SelectorArrayNode && result.size() == 1) {
            result = result.get(0);
        }
        if (this.checkRuntime) {
            this.evaluateExit();
        }
        return result;
    }

    @Override
    public JsonNode visitAddsub_op(MappingExpressionParser.Addsub_opContext ctx) {
        String METHOD = "visitAddsub_op";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitAddsub_op", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        JsonNode leftNode = this.visit(ctx.expr(0));
        JsonNode rightNode = this.visit(ctx.expr(1));
        if (leftNode != null && rightNode != null) {
            double dResult;
            if (!leftNode.isNumber() || !rightNode.isNumber()) {
                throw new EvaluateRuntimeException(ctx.op.getText() + " expects two numeric arguments");
            }
            double left = leftNode.asDouble();
            double right = rightNode.asDouble();
            if (ctx.op.getType() == 31) {
                dResult = left + right;
            } else if (ctx.op.getType() == 32) {
                dResult = left - right;
            } else {
                throw new EvaluateRuntimeException("Unrecognised token " + ctx.op.getText());
            }
            result = ExpressionsVisitor.isWholeNumber(dResult) ? new LongNode((long)dResult) : new DoubleNode(dResult);
        }
        this.lastVisited = "visitAddsub_op";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitAddsub_op", result == null ? "null" : result.toString());
        }
        return result;
    }

    @Override
    public JsonNode visitArray(MappingExpressionParser.ArrayContext ctx) {
        String METHOD = "visitArray";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitArray", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        if (ctx.expr().size() != 2) {
            throw new EvaluateRuntimeException("invalid array expression");
        }
        ArrayNode sourceArray = ExpressionsVisitor.ensureArray(this.visit(ctx.expr(0)));
        if (sourceArray != null) {
            MappingExpressionParser.ExprContext indexContext = ctx.expr(1);
            ArrayList<Integer> indexesToReturn = new ArrayList<Integer>();
            ArrayNode output = JsonNodeFactory.instance.arrayNode();
            boolean isPredicate = false;
            boolean haveResult = false;
            block0: for (int i = 0; !haveResult && i < sourceArray.size(); ++i) {
                JsonNode e = sourceArray.get(i);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.logp(Level.FINEST, CLASS, "visitArray", "Evaluating array index expression '" + indexContext.getText() + "' against element at index " + i + " ('" + e + "') of source array");
                }
                this._environment.pushContext(e);
                Object indexesInContext = this.factory.arrayNode();
                indexesInContext = this.visit(indexContext);
                this._environment.popContext();
                if (indexesInContext == null) {
                    isPredicate = true;
                    continue;
                }
                if (((JsonNode)indexesInContext).isBoolean()) {
                    isPredicate = true;
                    if (indexesInContext != BooleanNode.TRUE) continue;
                    indexesToReturn.add(i);
                    continue;
                }
                indexesInContext = ExpressionsVisitor.ensureArray((JsonNode)indexesInContext);
                Iterator<JsonNode> iterator = ((JsonNode)indexesInContext).iterator();
                while (iterator.hasNext()) {
                    JsonNode indexInContext = iterator.next();
                    if (indexInContext.isIntegralNumber() || indexInContext.isLong()) {
                        indexesToReturn.add(indexInContext.asInt());
                        continue;
                    }
                    if (indexInContext.isFloatingPointNumber() || indexInContext.isDouble()) {
                        indexesToReturn.add((int)Math.floor(indexInContext.asDouble()));
                        continue;
                    }
                    if (indexInContext.isBoolean()) {
                        if (indexInContext.asBoolean()) {
                            result = sourceArray;
                            haveResult = true;
                            break block0;
                        }
                        if (((JsonNode)indexesInContext).size() == 1) {
                            result = null;
                            haveResult = true;
                            break block0;
                        }
                        result = sourceArray;
                        haveResult = true;
                        break block0;
                    }
                    if (indexInContext.isArray()) {
                        ArrayNode indexArray = (ArrayNode)indexInContext;
                        boolean isOkay = false;
                        for (int j = 0; j < indexArray.size(); ++j) {
                            if (!indexArray.get(j).asBoolean()) continue;
                            isOkay = true;
                            break;
                        }
                        if (isOkay) {
                            result = sourceArray;
                            haveResult = true;
                            break block0;
                        }
                        result = null;
                        haveResult = true;
                        break block0;
                    }
                    throw new NonNumericArrayIndexException();
                }
                break;
            }
            if (!haveResult) {
                if (!isPredicate && sourceArray instanceof SelectorArrayNode) {
                    SelectorArrayNode sourceArraySel = (SelectorArrayNode)sourceArray;
                    SelectorArrayNode resultAsSel = new SelectorArrayNode(this.factory);
                    output = resultAsSel;
                    block3: for (JsonNode group : sourceArraySel.getSelectionGroups()) {
                        group = ExpressionsVisitor.ensureArray(group);
                        List<Integer> resolvedIndexes = this.resolveIndexes(indexesToReturn, group.size());
                        for (int index : resolvedIndexes) {
                            if (group.isArray()) {
                                JsonNode atIndex = group.get(index);
                                if (atIndex == null) continue block3;
                                resultAsSel.addAsSelectionGroup(atIndex);
                                continue;
                            }
                            if (index != 0) continue;
                            resultAsSel.addAsSelectionGroup(group);
                        }
                    }
                } else {
                    output = this.factory.arrayNode();
                    List<Integer> resolvedIndexes = this.resolveIndexes(indexesToReturn, sourceArray.size());
                    for (int index : resolvedIndexes) {
                        if (index < 0 || index >= sourceArray.size()) continue;
                        output.add(sourceArray.get(index));
                    }
                }
                if (output.size() != 0) {
                    result = output;
                    result = ExpressionsVisitor.unwrapArray(result);
                }
            }
        }
        this.lastVisited = "visitArray";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitArray", result == null ? "null" : result.toString());
        }
        return result;
    }

    @Override
    public JsonNode visitArray_constructor(MappingExpressionParser.Array_constructorContext ctx) {
        String METHOD = "visitArray_constructor";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitArray_constructor", new Object[]{ctx.getText(), ctx.depth()});
        }
        ArrayNode result = null;
        this.inArrayConstructStack.push(true);
        ArrayNode output = this.factory.arrayNode();
        if (ctx.exprOrSeqList() != null) {
            for (MappingExpressionParser.ExprOrSeqContext expr : ctx.exprOrSeqList().exprOrSeq()) {
                if (expr.seq() == null) {
                    this.processArrayContent(expr, output);
                    continue;
                }
                ArrayNode seq = (ArrayNode)this.visit(expr);
                if (seq == null) continue;
                output.addAll(seq);
            }
        }
        if (!this.inArrayConstructStack.isEmpty()) {
            this.inArrayConstructStack.pop();
        }
        result = output;
        this.lastVisited = "visitArray_constructor";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitArray_constructor", result == null ? "null" : ((JsonNode)result).toString());
        }
        return result;
    }

    @Override
    public JsonNode visitBoolean(MappingExpressionParser.BooleanContext ctx) {
        String METHOD = "visitBoolean";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitBoolean", new Object[]{ctx.getText(), ctx.depth()});
        }
        BooleanNode result = null;
        if (ctx.op.getType() == 12) {
            result = BooleanNode.TRUE;
        } else if (ctx.op.getType() == 13) {
            result = BooleanNode.FALSE;
        }
        this.lastVisited = "visitBoolean";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitBoolean", result == null ? "null" : ((JsonNode)result).toString());
        }
        return result;
    }

    @Override
    public JsonNode visitComp_op(MappingExpressionParser.Comp_opContext ctx) {
        String METHOD = "visitComp_op";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitComp_op", new Object[]{ctx.expr(0) == null ? "null" : ctx.expr(0).getText(), ctx.expr(1) == null ? "null" : ctx.expr(1).getText(), ctx.depth()});
        }
        Object result = null;
        JsonNode left = this.visit(ctx.expr(0));
        JsonNode right = this.visit(ctx.expr(1));
        if (left == null && right == null) {
            return BooleanNode.FALSE;
        }
        boolean lIsComparable = false;
        boolean rIsComparable = false;
        if (left != null && right != null) {
            JsonNodeType ltype = left.getNodeType();
            JsonNodeType rtype = right.getNodeType();
            lIsComparable = ltype == JsonNodeType.NULL || ltype == JsonNodeType.STRING || ltype == JsonNodeType.NUMBER;
            boolean bl = rIsComparable = rtype == JsonNodeType.NULL || rtype == JsonNodeType.STRING || rtype == JsonNodeType.NUMBER;
        }
        if (ctx.op.getType() == 34) {
            result = left == null && right != null ? BooleanNode.FALSE : (left != null && right == null ? BooleanNode.FALSE : (left.getNodeType() == right.getNodeType() ? (ExpressionsVisitor.areJsonNodesEqual(left, right) ? BooleanNode.TRUE : BooleanNode.FALSE) : (!lIsComparable || !rIsComparable ? null : BooleanNode.FALSE)));
        } else if (ctx.op.getType() == 35) {
            result = left == null && right != null ? BooleanNode.TRUE : (left != null && right == null ? BooleanNode.TRUE : (left.getNodeType() == right.getNodeType() ? (ExpressionsVisitor.areJsonNodesEqual(left, right) ? BooleanNode.FALSE : BooleanNode.TRUE) : (!lIsComparable || !rIsComparable ? null : BooleanNode.TRUE)));
        } else if (ctx.op.getType() == 36) {
            if (left == null || right == null) {
                result = null;
            } else {
                if (left.isNull() || right.isNull()) {
                    throw new EvaluateRuntimeException("The expressions either side of operator \"<\" must evaluate to numeric or string values");
                }
                if (left.isBoolean() || right.isBoolean()) {
                    result = null;
                } else if (left.isFloatingPointNumber() || right.isFloatingPointNumber()) {
                    result = left.asDouble() < right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isDouble() || right.isDouble()) {
                    result = left.asDouble() < right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isIntegralNumber() && right.isIntegralNumber()) {
                    result = left.asLong() < right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isLong() && right.isLong()) {
                    result = left.asLong() < right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (!lIsComparable || !rIsComparable) {
                    result = null;
                } else {
                    if (left.getNodeType() != right.getNodeType()) {
                        throw new EvaluateRuntimeException("The values " + left.toString() + " and " + right.toString() + " either side of operator \">\" must be of the same data type");
                    }
                    result = left.asText().compareTo(right.asText()) < 0 ? BooleanNode.TRUE : BooleanNode.FALSE;
                }
            }
        } else if (ctx.op.getType() == 38) {
            if (left == null || right == null) {
                result = null;
            } else {
                if (left.isNull() || right.isNull()) {
                    throw new EvaluateRuntimeException("The expressions either side of operator \">\" must evaluate to numeric or string values");
                }
                if (left.isBoolean() || right.isBoolean()) {
                    result = null;
                } else if (left.isFloatingPointNumber() || right.isFloatingPointNumber()) {
                    result = left.asDouble() > right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isDouble() || right.isDouble()) {
                    result = left.asDouble() > right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isIntegralNumber() && right.isIntegralNumber()) {
                    result = left.asLong() > right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isLong() && right.isLong()) {
                    result = left.asLong() > right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else {
                    if (!lIsComparable || !rIsComparable) {
                        return null;
                    }
                    if (left.getNodeType() != right.getNodeType()) {
                        throw new EvaluateRuntimeException("The values " + left.toString() + " and " + right.toString() + " either side of operator \">\" must be of the same data type");
                    }
                    result = left.asText().compareTo(right.asText()) > 0 ? BooleanNode.TRUE : BooleanNode.FALSE;
                }
            }
        } else if (ctx.op.getType() == 37) {
            if (left == null || right == null) {
                result = null;
            } else {
                if (left.isNull() || right.isNull()) {
                    throw new EvaluateRuntimeException("The expressions either side of operator \"<=\" must evaluate to numeric or string values");
                }
                if (left.isBoolean() || right.isBoolean()) {
                    result = null;
                } else if (left.isFloatingPointNumber() || right.isFloatingPointNumber()) {
                    result = left.asDouble() <= right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isDouble() || right.isDouble()) {
                    result = left.asDouble() <= right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isIntegralNumber() && right.isIntegralNumber()) {
                    result = left.asLong() <= right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isLong() && right.isLong()) {
                    result = left.asLong() <= right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (!lIsComparable || !rIsComparable) {
                    result = null;
                } else {
                    if (left.getNodeType() != right.getNodeType()) {
                        throw new EvaluateRuntimeException("The values " + left.toString() + " and " + right.toString() + " either side of operator \"<=\" must be of the same data type");
                    }
                    result = left.asText().compareTo(right.asText()) <= 0 ? BooleanNode.TRUE : BooleanNode.FALSE;
                }
            }
        } else if (ctx.op.getType() == 39) {
            if (left == null || right == null) {
                result = null;
            } else {
                if (left.isNull() || right.isNull()) {
                    throw new EvaluateRuntimeException("The expressions either side of operator \">=\" must evaluate to numeric or string values");
                }
                if (left.isBoolean() || right.isBoolean()) {
                    result = null;
                } else if (left.isFloatingPointNumber() || right.isFloatingPointNumber()) {
                    result = left.asDouble() >= right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isDouble() || right.isDouble()) {
                    result = left.asDouble() >= right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isIntegralNumber() && right.isIntegralNumber()) {
                    result = left.asLong() >= right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isLong() && right.isLong()) {
                    result = left.asLong() >= right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (!lIsComparable || !rIsComparable) {
                    result = null;
                } else {
                    if (left.getNodeType() != right.getNodeType()) {
                        throw new EvaluateRuntimeException("The values " + left.toString() + " and " + right.toString() + " either side of operator \">=\" must be of the same data type");
                    }
                    result = left.asText().compareTo(right.asText()) >= 0 ? BooleanNode.TRUE : BooleanNode.FALSE;
                }
            }
        }
        this.lastVisited = "visitComp_op";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitComp_op", result == null ? "null" : ((JsonNode)result).toString());
        }
        return result;
    }

    @Override
    public JsonNode visitConcat_op(MappingExpressionParser.Concat_opContext ctx) {
        String METHOD = "visitConcat_op";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitConcat_op", new Object[]{ctx.expr(0) == null ? "null" : ctx.expr(0).getText(), ctx.expr(1) == null ? "null" : ctx.expr(1).getText(), ctx.depth()});
        }
        TextNode result = null;
        JsonNode left = this.visit(ctx.expr(0));
        JsonNode right = this.visit(ctx.expr(1));
        String leftStr = left == null ? "" : (left != null && left.isDouble() ? ExpressionsVisitor.castString(left, false) : ExpressionsVisitor.castString(left, false));
        String rightStr = right == null ? "" : (right != null && right.isDouble() ? ExpressionsVisitor.castString(right, false) : ExpressionsVisitor.castString(right, false));
        result = new TextNode(leftStr + rightStr);
        this.lastVisited = "visitConcat_op";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitConcat_op", result == null ? "null" : ((JsonNode)result).toString());
        }
        return result;
    }

    @Override
    public JsonNode visitConditional(MappingExpressionParser.ConditionalContext ctx) {
        JsonNode cond;
        String METHOD = "visitConditional";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitConditional", new Object[]{ctx.expr(0) == null ? "null" : ctx.expr(0).getText(), ctx.expr(1) == null ? "null" : ctx.expr(1).getText(), ctx.expr(2) == null ? "null" : ctx.expr(2).getText(), ctx.depth()});
        }
        JsonNode result = null;
        result = cond = this.visit(ctx.expr(0));
        if (cond == null) {
            MappingExpressionParser.ExprContext ctx2 = ctx.expr(2);
            result = ctx2 != null ? this.visit(ctx2) : null;
        } else if (cond instanceof BooleanNode || cond instanceof NumericNode) {
            MappingExpressionParser.ExprContext ctx1 = ctx.expr(1);
            MappingExpressionParser.ExprContext ctx2 = ctx.expr(2);
            result = ctx1 != null && ctx2 != null ? (BooleanUtils.convertJsonNodeToBoolean(cond) ? this.visit(ctx.expr(1)) : this.visit(ctx.expr(2))) : (BooleanUtils.convertJsonNodeToBoolean(cond) ? (ctx1 != null ? this.visit(ctx1) : null) : (ctx2 != null ? this.visit(ctx2) : null));
        }
        this.lastVisited = "visitConditional";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitConditional", result == null ? "null" : result.toString());
        }
        return result;
    }

    @Override
    public JsonNode visitContext_ref(MappingExpressionParser.Context_refContext ctx) {
        String METHOD = "visitContext_ref";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitContext_ref", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        if (ctx.getChildCount() > 0) {
            ParseTree child0 = ctx.getChild(0);
            if (child0 instanceof TerminalNodeImpl) {
                if (((TerminalNodeImpl)child0).symbol.getText().equals("$")) {
                    JsonNode context = this.getVariable("$");
                    if (context != null) {
                        if (ctx.children.size() == 1) {
                            result = context;
                        } else {
                            CommonToken token = null;
                            MappingExpressionParser.ExprContext expr = null;
                            switch (context.getNodeType()) {
                                case BINARY: 
                                case POJO: {
                                    break;
                                }
                                case ARRAY: {
                                    child0 = FunctionUtils.getArrayConstructorContext(ctx, (ArrayNode)context);
                                    expr = new MappingExpressionParser.ArrayContext(ctx);
                                    for (int i = 0; i < ctx.children.size(); ++i) {
                                        expr.children.add(ctx.children.get(i));
                                    }
                                    expr.children.set(0, child0);
                                    result = this.visit(expr);
                                    break;
                                }
                                case BOOLEAN: {
                                    token = context.asBoolean() ? CommonTokenFactory.DEFAULT.create(12, context.asText()) : CommonTokenFactory.DEFAULT.create(13, context.asText());
                                    TerminalNodeImpl tn = new TerminalNodeImpl(token);
                                    MappingExpressionParser.BooleanContext bc = new MappingExpressionParser.BooleanContext(ctx);
                                    bc.children.set(0, tn);
                                    result = this.visit(bc);
                                    break;
                                }
                                case MISSING: 
                                case NULL: {
                                    token = CommonTokenFactory.DEFAULT.create(15, null);
                                    TerminalNodeImpl tn = new TerminalNodeImpl(token);
                                    MappingExpressionParser.NullContext nc = new MappingExpressionParser.NullContext(ctx);
                                    nc.children.set(0, tn);
                                    result = this.visit(nc);
                                    break;
                                }
                                case NUMBER: {
                                    token = CommonTokenFactory.DEFAULT.create(23, context.asText());
                                    TerminalNodeImpl tn = new TerminalNodeImpl(token);
                                    MappingExpressionParser.NumberContext nc = new MappingExpressionParser.NumberContext(ctx);
                                    nc.children.set(0, tn);
                                    result = this.visit(nc);
                                    break;
                                }
                                case OBJECT: {
                                    child0 = FunctionUtils.getObjectConstructorContext(ctx, (ObjectNode)context);
                                    expr = new MappingExpressionParser.PathContext(ctx);
                                    for (int i = 0; i < ctx.children.size(); ++i) {
                                        expr.children.add(ctx.children.get(i));
                                    }
                                    expr.children.set(0, child0);
                                    result = this.visit(expr);
                                    break;
                                }
                                default: {
                                    token = CommonTokenFactory.DEFAULT.create(14, context.asText());
                                    TerminalNodeImpl tn = new TerminalNodeImpl(token);
                                    MappingExpressionParser.StringContext sc = new MappingExpressionParser.StringContext(ctx);
                                    sc.children.set(0, tn);
                                    result = this.visit(sc);
                                    break;
                                }
                            }
                        }
                    } else {
                        result = context;
                    }
                }
            } else {
                result = this.visit(child0);
            }
        }
        this.lastVisited = "visitContext_ref";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitContext_ref", result == null ? "null" : result.toString());
        }
        return result;
    }

    @Override
    public JsonNode visitDescendant(MappingExpressionParser.DescendantContext ctx) {
        String METHOD = "visitDescendant";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitDescendant", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        ArrayNode resultArray = new ArrayNode(JsonNodeFactory.instance);
        JsonNode descendants = this.getDescendants();
        if (descendants == null) {
            resultArray = null;
        } else if (!descendants.isArray()) {
            resultArray.add(descendants);
        } else {
            Iterator<JsonNode> it = ((ArrayNode)descendants).iterator();
            while (it.hasNext()) {
                resultArray.add(it.next());
            }
        }
        result = resultArray == null || resultArray.size() == 0 ? null : ExpressionsVisitor.unwrapArray(resultArray);
        this.lastVisited = "visitDescendant";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitDescendant", result == null ? "null" : result.toString());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode visitFct_chain(MappingExpressionParser.Fct_chainContext ctx) {
        String METHOD = "visitFct_chain";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitFct_chain", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        MappingExpressionParser.ExprContext exprObj = ctx.expr(1);
        if (exprObj instanceof MappingExpressionParser.Function_callContext) {
            JsonNode test = this.visit(ctx.expr(0));
            this._environment.pushContext(test);
            result = this.visit(ctx.expr(1));
            this._environment.popContext();
        } else {
            if (!(exprObj instanceof MappingExpressionParser.Var_recallContext)) throw new EvaluateRuntimeException("Expected a function but got " + ctx.expr(1).getText());
            String fctName = ((MappingExpressionParser.Var_recallContext)exprObj).VAR_ID().getText();
            DeclaredFunction declFct = this.getDeclaredFunction(fctName);
            if (declFct == null) {
                Function function = this.getJsonataFunction(fctName);
                if (function == null) {
                    function = Constants.FUNCTIONS.get(fctName);
                }
                if (function == null) throw new EvaluateRuntimeException("Unknown function: " + fctName);
                result = function.invoke(this, (MappingExpressionParser.Function_callContext)ctx.expr(1));
            } else {
                result = declFct.invoke(this, ctx.expr(1));
            }
        }
        this.lastVisited = "visitFct_chain";
        if (!LOG.isLoggable(Level.FINEST)) return result;
        LOG.exiting(CLASS, "visitFct_chain", result == null ? "null" : result.toString());
        return result;
    }

    @Override
    public JsonNode visitField_values(MappingExpressionParser.Field_valuesContext ctx) {
        String METHOD = "visitField_values";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitField_values", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        ArrayNode resultArray = new ArrayNode(JsonNodeFactory.instance);
        ArrayNode valArray = new ArrayNode(JsonNodeFactory.instance);
        if (!this._environment.isEmptyContext()) {
            JsonNode elt = this._environment.peekContext();
            if (elt == null || !(elt.isObject() || elt.isArray())) {
                result = null;
            } else {
                Iterator<JsonNode> it2;
                if (elt.isObject()) {
                    Iterator<Object> it = ((ObjectNode)elt).fieldNames();
                    while (it.hasNext()) {
                        JsonNode value = ((ObjectNode)elt).get((String)it.next());
                        if (value.isArray()) {
                            value = ExpressionsVisitor.flatten(value, null);
                            it2 = ((ArrayNode)value).iterator();
                            while (it2.hasNext()) {
                                valArray.add(it2.next());
                            }
                            continue;
                        }
                        valArray.add(value);
                    }
                } else {
                    for (JsonNode value : (ArrayNode)elt) {
                        if (value.isArray()) {
                            value = ExpressionsVisitor.flatten(value, null);
                            it2 = ((ArrayNode)value).iterator();
                            while (it2.hasNext()) {
                                valArray.add(it2.next());
                            }
                            continue;
                        }
                        valArray.add(value);
                    }
                }
                for (JsonNode value : valArray) {
                    resultArray.add(value);
                }
            }
            result = resultArray.size() == 0 ? null : ExpressionsVisitor.unwrapArray(resultArray);
        }
        this.lastVisited = "visitField_values";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitField_values", result == null ? "null" : result.toString());
        }
        return result;
    }

    @Override
    public JsonNode visitFieldList(MappingExpressionParser.FieldListContext ctx) {
        JsonNode elt;
        String METHOD = "visitFieldList";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitFieldList", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        ObjectNode resultObject = new ObjectNode(JsonNodeFactory.instance);
        if (!this._environment.isEmptyContext() && (elt = this._environment.peekContext()) != null && elt.isObject()) {
            String key = "";
            JsonNode value = null;
            for (int i = 0; i < ctx.getChildCount(); i += 4) {
                key = ExpressionsVisitor.sanitise(((TerminalNodeImpl)ctx.getChild(i)).getText());
                value = this.visit(ctx.getChild(i + 2));
                if (value == null) continue;
                resultObject.set(key, value);
            }
            if (resultObject.size() > 0) {
                result = resultObject;
            }
        }
        this.lastVisited = "visitFieldList";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitFieldList", result == null ? "null" : result.toString());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode visitFunction_call(MappingExpressionParser.Function_callContext ctx) {
        String METHOD = "visitFunction_call";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitFunction_call", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        String functionName = ctx.VAR_ID().getText();
        DeclaredFunction declFct = this.getDeclaredFunction(functionName);
        if (declFct == null) {
            Function function = this.getJsonataFunction(functionName);
            if (function == null) {
                function = Constants.FUNCTIONS.get(functionName);
            }
            if (function == null) throw new EvaluateRuntimeException("Unknown function: " + functionName);
            result = function.invoke(this, ctx);
        } else {
            result = declFct.invoke(this, ctx);
        }
        this.lastVisited = "visitFunction_call";
        if (!LOG.isLoggable(Level.FINEST)) return result;
        LOG.exiting(CLASS, "visitFunction_call", result == null ? "null" : result.toString());
        return result;
    }

    @Override
    public JsonNode visitFunction_decl(MappingExpressionParser.Function_declContext ctx) {
        String METHOD = "visitFunction_decl";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitFunction_decl", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        String fctName = ctx.FUNCTIONID().getText();
        RuleContext expr = ctx.getRuleContext();
        MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)expr;
        MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
        MappingExpressionParser.ExprListContext exprList = fctDeclCtx.exprList();
        DeclaredFunction fct = new DeclaredFunction(varList, exprList);
        this.setDeclaredFunction(fctName, fct);
        this.lastVisited = "visitFunction_decl";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitFunction_decl", result == null ? "null" : result.toString());
        }
        return result;
    }

    @Override
    public JsonNode visitFunction_exec(MappingExpressionParser.Function_execContext ctx) {
        int exprListCount;
        String METHOD = "visitFunction_exec";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitFunction_exec", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        List<TerminalNode> varListCtx = ctx.varList().VAR_ID();
        List<MappingExpressionParser.ExprContext> exprValuesCtx = ctx.exprValues().exprList().expr();
        int varListCount = varListCtx.size();
        if (varListCount != (exprListCount = exprValuesCtx.size())) {
            throw new EvaluateRuntimeException("Expected equal counts for varibles (" + varListCount + ") and values (" + exprListCount + ")");
        }
        for (int i = 0; i < varListCount; ++i) {
            String varID = varListCtx.get(i).getText();
            JsonNode value = this.visit(exprValuesCtx.get(i));
            this.setVariable(varID, value);
        }
        MappingExpressionParser.ExprListContext exprListCtx = ctx.exprList();
        result = this.visit(exprListCtx);
        this.lastVisited = "visitFunction_exec";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitFunction_exec", result == null ? "null" : result.toString());
        }
        return result;
    }

    @Override
    public JsonNode visitId(MappingExpressionParser.IdContext ctx) {
        String METHOD = "visitId";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitId", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        if (!this._environment.isEmptyContext()) {
            JsonNode context = this._environment.peekContext();
            String id = ExpressionsVisitor.sanitise(ctx.ID().getText());
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.entering(CLASS, "visitId", new Object[]{ctx.getText(), id, "(stack: " + context + ")"});
            }
            result = context == null ? null : this.lookup(context, id);
        }
        this.lastVisited = "visitId";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitId", result == null ? "null" : result.toString());
        }
        return result;
    }

    @Override
    public JsonNode visitLogand(MappingExpressionParser.LogandContext ctx) {
        String METHOD = "visitLogand";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitLogand", new Object[]{ctx.expr(0) == null ? "null" : ctx.expr(0).getText(), ctx.expr(1) == null ? "null" : ctx.expr(1).getText(), ctx.depth()});
        }
        BooleanNode result = null;
        JsonNode left = this.visit(ctx.expr(0));
        JsonNode right = this.visit(ctx.expr(1));
        result = BooleanUtils.convertJsonNodeToBoolean(left) && BooleanUtils.convertJsonNodeToBoolean(right) ? BooleanNode.TRUE : BooleanNode.FALSE;
        this.lastVisited = "visitLogand";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitLogand", result == null ? "null" : ((JsonNode)result).toString());
        }
        return result;
    }

    @Override
    public JsonNode visitLogor(MappingExpressionParser.LogorContext ctx) {
        String METHOD = "visitLogor";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitLogor", new Object[]{ctx.expr(0) == null ? "null" : ctx.expr(0).getText(), ctx.expr(1) == null ? "null" : ctx.expr(1).getText(), ctx.depth()});
        }
        BooleanNode result = null;
        JsonNode left = this.visit(ctx.expr(0));
        JsonNode right = this.visit(ctx.expr(1));
        result = BooleanUtils.convertJsonNodeToBoolean(left) || BooleanUtils.convertJsonNodeToBoolean(right) ? BooleanNode.TRUE : BooleanNode.FALSE;
        this.lastVisited = "visitLogor";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitLogor", result == null ? "null" : ((JsonNode)result).toString());
        }
        return result;
    }

    @Override
    public JsonNode visitMembership(MappingExpressionParser.MembershipContext ctx) {
        String METHOD = "visitMembership";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitMembership", new Object[]{ctx.expr(0) == null ? "null" : ctx.expr(0).getText(), ctx.expr(1) == null ? "null" : ctx.expr(1).getText(), ctx.depth()});
        }
        BooleanNode result = null;
        JsonNode left = this.visit(ctx.expr(0));
        JsonNode right = this.visit(ctx.expr(1));
        if (left != null && right != null) {
            right = ExpressionsVisitor.ensureArray(right);
            left = ExpressionsVisitor.unwrapArray(left);
            result = BooleanNode.FALSE;
            Iterator<JsonNode> elements = right.elements();
            while (elements.hasNext()) {
                JsonNode curElement = elements.next();
                if (!ExpressionsVisitor.areJsonNodesEqual(left, curElement)) continue;
                result = BooleanNode.TRUE;
                break;
            }
        }
        this.lastVisited = "visitMembership";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitMembership", result == null ? "null" : ((JsonNode)result).toString());
        }
        return result;
    }

    @Override
    public JsonNode visitMuldiv_op(MappingExpressionParser.Muldiv_opContext ctx) {
        String METHOD = "visitMuldiv_op";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitMuldiv_op", new Object[]{ctx.expr(0) == null ? "null" : ctx.expr(0).getText(), ctx.expr(1) == null ? "null" : ctx.expr(1).getText(), ctx.depth()});
        }
        JsonNode result = null;
        JsonNode leftNode = this.visit(ctx.expr(0));
        JsonNode rightNode = this.visit(ctx.expr(1));
        if (leftNode != null && rightNode != null) {
            if (!leftNode.isNumber() || !rightNode.isNumber()) {
                throw new EvaluateRuntimeException(ctx.op.getText() + " expects two numeric arguments");
            }
            double left = leftNode.asDouble();
            double right = rightNode.asDouble();
            Double dresult = 0.0;
            if (ctx.op.getType() == 29) {
                dresult = left * right;
            } else if (ctx.op.getType() == 30) {
                if (right == 0.0) {
                    result = new DoubleNode(Double.POSITIVE_INFINITY);
                } else {
                    dresult = left / right;
                }
            } else if (ctx.op.getType() == 33) {
                if (right == 0.0) {
                    result = new DoubleNode(Double.NaN);
                } else {
                    dresult = left % right;
                }
            } else {
                throw new EvaluateRuntimeException("Unrecognised token " + ctx.op.getText());
            }
            if (result == null) {
                if (dresult.isInfinite() || dresult.isNaN()) {
                    throw new EvaluateRuntimeException("Number out of range: \"null\"");
                }
                result = ExpressionsVisitor.isWholeNumber(dresult) ? new LongNode(dresult.longValue()) : new DoubleNode(dresult);
            }
        }
        this.lastVisited = "visitMuldiv_op";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitMuldiv_op", result == null ? "null" : result.toString());
        }
        return result;
    }

    @Override
    public JsonNode visitNull(MappingExpressionParser.NullContext ctx) {
        String METHOD = "visitNull";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitNull", new Object[]{ctx.getText(), ctx.depth()});
        }
        NullNode result = NullNode.getInstance();
        this.lastVisited = "visitNull";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitNull", result == null ? "null" : ((JsonNode)result).toString());
        }
        return result;
    }

    @Override
    public JsonNode visitNumber(MappingExpressionParser.NumberContext ctx) {
        String METHOD = "visitNumber";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitNumber", new Object[]{ctx.getText(), ctx.depth()});
        }
        ValueNode result = NumberUtils.convertNumberToValueNode(ctx.NUMBER().getText());
        this.lastVisited = "visitNumber";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitNumber", result == null ? "null" : ((JsonNode)result).toString());
        }
        return result;
    }

    @Override
    public JsonNode visitObject_constructor(MappingExpressionParser.Object_constructorContext ctx) {
        String METHOD = "visitObject_constructor";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitObject_constructor", new Object[]{ctx.getText(), ctx.depth()});
        }
        ObjectNode result = null;
        ObjectNode object = this.factory.objectNode();
        if (ctx.fieldList() == null) {
            result = object;
        } else {
            List<TerminalNode> keyNodes = ctx.fieldList().STRING();
            List<MappingExpressionParser.ExprContext> valueNodes = ctx.fieldList().expr();
            if (keyNodes.size() != valueNodes.size()) {
                throw new EvaluateRuntimeException("Object key/value count mismatch!");
            }
            MappingExpressionParser.ExprContext valueNode = null;
            JsonNode value = null;
            String fctName = null;
            String key = "";
            for (int i = 0; i < keyNodes.size(); ++i) {
                key = keyNodes.get(i).getText();
                key = ExpressionsVisitor.sanitise(key);
                valueNode = valueNodes.get(i);
                if (valueNode instanceof MappingExpressionParser.Function_declContext) {
                    this.visit(valueNode);
                    fctName = ((MappingExpressionParser.Function_declContext)valueNode).FUNCTIONID().getText();
                    if (this.getDeclaredFunction(fctName) != null) {
                        value = new TextNode("");
                    }
                } else if (valueNode instanceof MappingExpressionParser.Var_recallContext) {
                    value = this.visit(valueNode);
                    if (value == null) {
                        Function fct;
                        String varName = ((MappingExpressionParser.Var_recallContext)valueNode).VAR_ID().getText();
                        DeclaredFunction declFct = this.getDeclaredFunction(varName);
                        value = declFct != null ? new TextNode("") : ((fct = this.getJsonataFunction(varName)) != null ? new TextNode("") : null);
                    }
                } else {
                    Double d;
                    value = this.visit(valueNode);
                    if (value != null && value.isDouble() && (Double.isNaN(d = Double.valueOf(value.asDouble())) || Double.isInfinite(d))) {
                        throw new EvaluateRuntimeException("Number out of range: null");
                    }
                }
                if (value == null) continue;
                object.set(key, value);
            }
            result = object;
        }
        this.lastVisited = "visitObject_constructor";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitObject_constructor", result == null ? "null" : ((JsonNode)result).toString());
        }
        return result;
    }

    @Override
    public JsonNode visitParens(MappingExpressionParser.ParensContext ctx) {
        String METHOD = "visitParens";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitParens", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        FrameEnvironment oldEnvironment = this._environment;
        this._environment = new FrameEnvironment(this._environment);
        List<MappingExpressionParser.ExprContext> expressions = ctx.expr();
        try {
            for (int i = 0; i < expressions.size(); ++i) {
                result = this.visit(ctx.expr(i));
            }
        }
        catch (Exception e) {
            this._environment = oldEnvironment;
            throw e;
        }
        if (result instanceof SelectorArrayNode) {
            ArrayNode newResult = this.factory.arrayNode();
            newResult.addAll((SelectorArrayNode)result);
            result = newResult;
        }
        this._environment = oldEnvironment;
        this.lastVisited = "visitParens";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitParens", result == null ? "null" : result.toString());
        }
        return result;
    }

    @Override
    public JsonNode visitPath(MappingExpressionParser.PathContext ctx) {
        String METHOD = "visitPath";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitPath", new Object[]{ctx.expr(0) == null ? "null" : ctx.expr(0).getText(), ctx.expr(1) == null ? "null" : ctx.expr(1).getText(), ctx.depth()});
        }
        JsonNode result = null;
        MappingExpressionParser.ExprContext lhsCtx = ctx.expr(0);
        MappingExpressionParser.ExprContext rhsCtx = ctx.expr(1);
        if (lhsCtx instanceof MappingExpressionParser.NullContext || rhsCtx instanceof MappingExpressionParser.NullContext) {
            throw new EvaluateRuntimeException(String.format("The literal value %s cannot be used as a step within a path expression", "null"));
        }
        JsonNode lhs = null;
        if (lhsCtx instanceof MappingExpressionParser.StringContext) {
            CommonToken token = CommonTokenFactory.DEFAULT.create(42, this.visit(lhsCtx).asText());
            TerminalNodeImpl node = new TerminalNodeImpl(token);
            MappingExpressionParser.IdContext idCtx = new MappingExpressionParser.IdContext(lhsCtx);
            idCtx.addChild(node);
            lhs = this.visit(idCtx);
        } else {
            lhs = this.visit(lhsCtx);
        }
        if (lhs != null && !lhs.isNull()) {
            switch (lhs.getNodeType()) {
                case NUMBER: {
                    break;
                }
                case BOOLEAN: 
                case NULL: {
                    throw new EvaluateRuntimeException(String.format("The literal value %s cannot be used as a step within a path expression", lhs.toString()));
                }
            }
            if (rhsCtx == null) {
                result = lhs;
            } else {
                JsonNode rhs = null;
                if (rhsCtx instanceof MappingExpressionParser.StringContext) {
                    CommonToken token = CommonTokenFactory.DEFAULT.create(42, this.visit(rhsCtx).asText());
                    TerminalNodeImpl node = new TerminalNodeImpl(token);
                    MappingExpressionParser.IdContext idCtx = new MappingExpressionParser.IdContext(rhsCtx);
                    idCtx.addChild(node);
                    rhs = this.resolvePath(lhs, idCtx);
                } else {
                    if (rhsCtx instanceof MappingExpressionParser.NumberContext) {
                        throw new EvaluateRuntimeException("The literal value " + this.visit(rhsCtx) + " cannot be used as a step within a path expression");
                    }
                    rhs = this.resolvePath(lhs, rhsCtx);
                }
                if (rhs == null) {
                    result = null;
                } else if (rhs instanceof SelectorArrayNode) {
                    if (rhs.size() == 0) {
                        result = null;
                    } else if (this.firstStepCons && this.firstStep || this.lastStep && this.lastStepCons) {
                        List<JsonNode> cells = ((SelectorArrayNode)rhs).getSelectionGroups();
                        result = new ArrayNode(JsonNodeFactory.instance);
                        for (JsonNode cell : cells) {
                            if (!cell.isArray() || "visitArray_constructor".equals(this.lastVisited)) {
                                ((ArrayNode)result).add(cell);
                                continue;
                            }
                            for (JsonNode elt : cell) {
                                ((ArrayNode)result).add(elt);
                            }
                        }
                        if (!this.keepArray && result.size() == 1) {
                            result = result.get(0);
                        }
                        this.firstStepCons = false;
                    } else {
                        result = this.keepArray ? rhs : (rhs.size() == 1 ? rhs.get(0) : rhs);
                    }
                } else {
                    result = rhs;
                }
            }
        }
        this.lastVisited = "visitPath";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitPath", result == null ? "null" : result.toString());
        }
        return result;
    }

    @Override
    public JsonNode visitRoot_path(MappingExpressionParser.Root_pathContext ctx) {
        String METHOD = "visitRoot_path";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitRoot_path", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        LinkedList<JsonNode> tmpStack = new LinkedList<JsonNode>();
        JsonNode tmpNode = null;
        for (int stackSize = this._environment.sizeContext(); stackSize > 1; --stackSize) {
            tmpNode = this._environment.popContext();
            if (tmpNode == null) continue;
            tmpStack.push(tmpNode);
        }
        try {
            result = this._environment.peekContext();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            while (!tmpStack.isEmpty()) {
                this._environment.pushContext((JsonNode)tmpStack.pop());
            }
        }
        this.lastVisited = "visitRoot_path";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitRoot_path", result == null ? "null" : result.toString());
        }
        return result;
    }

    @Override
    public JsonNode visitSeq(MappingExpressionParser.SeqContext ctx) {
        String METHOD = "visitSeq";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitSeq", new Object[]{ctx.expr(0) == null ? "null" : ctx.expr(0).getText(), ctx.expr(1) == null ? "null" : ctx.expr(1).getText(), ctx.depth()});
        }
        ArrayNode result = null;
        JsonNode start = this.visit(ctx.expr(0));
        JsonNode end = this.visit(ctx.expr(1));
        if (start != null && !ExpressionsVisitor.isWholeNumber(start)) {
            throw new EvaluateRuntimeException(ERR_SEQ_LHS_INTEGER);
        }
        if (end != null && !ExpressionsVisitor.isWholeNumber(end)) {
            throw new EvaluateRuntimeException(ERR_SEQ_RHS_INTEGER);
        }
        result = this.factory.arrayNode();
        if (start != null && end != null) {
            int iStart = start.asInt();
            int iEnd = end.asInt();
            int count = iEnd - iStart + 1;
            if (iEnd > iStart && count > 10000000) {
                throw new EvaluateRuntimeException(ERR_TOO_BIG + count + ".");
            }
            for (int i = start.asInt(); i <= end.asInt(); ++i) {
                result.add(new LongNode(i));
            }
        }
        this.lastVisited = "visitSeq";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitSeq", result == null ? "null" : ((JsonNode)result).toString());
        }
        return result;
    }

    @Override
    public JsonNode visitString(MappingExpressionParser.StringContext ctx) {
        String METHOD = "visitString";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitString", new Object[]{ctx.getText(), ctx.depth()});
        }
        TextNode result = null;
        String val = ctx.getText();
        val = ExpressionsVisitor.sanitise(val);
        result = TextNode.valueOf(val);
        this.lastVisited = "visitString";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitString", result == null ? "null" : ((JsonNode)result).toString());
        }
        return result;
    }

    @Override
    public JsonNode visitTo_array(MappingExpressionParser.To_arrayContext ctx) {
        String METHOD = "visitTo_array";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitTo_array", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        this.keepArray = true;
        MappingExpressionParser.ExprContext expr = ctx.expr();
        if (expr instanceof MappingExpressionParser.PathContext || expr instanceof MappingExpressionParser.Context_refContext) {
            JsonNode tmpResult = this.visit(expr);
            if (tmpResult instanceof SelectorArrayNode) {
                result = tmpResult;
            } else {
                result = this.visit(expr);
                result = ExpressionsVisitor.ensureSelectorNodeArray(result);
            }
        } else {
            result = this.visit(expr);
        }
        this.keepArray = false;
        this.lastVisited = "visitTo_array";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitTo_array", result == null ? "null" : result.toString());
        }
        return result;
    }

    public JsonNode visitTree(ParseTree tree) {
        Double d;
        ParseTree lastStep;
        JsonNode result = null;
        int treeSize = tree.getChildCount();
        this.steps.clear();
        for (int i = 0; i < treeSize; ++i) {
            this.steps.add(tree.getChild(i));
        }
        if (tree.getChild(0) instanceof MappingExpressionParser.Array_constructorContext) {
            this.firstStepCons = true;
        }
        if ((lastStep = tree.getChild(treeSize - 1)) instanceof MappingExpressionParser.Array_constructorContext) {
            this.lastStepCons = true;
        }
        this.firstStep = tree.equals(this.steps.get(0));
        this.lastVisited = "";
        result = this.visit(tree);
        if (result != null && result.isDouble() && (Double.isInfinite(d = Double.valueOf(result.asDouble())) || Double.isNaN(d))) {
            result = JsonNodeFactory.instance.nullNode();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode visitUnary_op(MappingExpressionParser.Unary_opContext ctx) {
        void var3_12;
        String METHOD = "visitUnary_op";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitUnary_op", new Object[]{ctx.getText(), ctx.depth()});
        }
        Object var3_3 = null;
        JsonNode operand = this.visit(ctx.expr());
        if (ctx.op.getType() == 32) {
            if (operand == null) {
                Object var3_4 = null;
            } else if (operand.isFloatingPointNumber()) {
                DoubleNode doubleNode = new DoubleNode(-operand.asDouble());
            } else if (operand.isDouble()) {
                DoubleNode doubleNode = new DoubleNode(-operand.asDouble());
            } else if (operand.isIntegralNumber()) {
                if (operand.asLong() == Long.MAX_VALUE) {
                    LongNode longNode = new LongNode(-operand.asLong() - 1L);
                } else {
                    LongNode longNode = new LongNode(-operand.asLong());
                }
            } else {
                if (!operand.isLong()) throw new EvaluateRuntimeException(ERR_NEGATE_NON_NUMERIC);
                if (operand.asLong() == Long.MAX_VALUE) {
                    LongNode longNode = new LongNode(-operand.asLong() - 1L);
                } else {
                    LongNode longNode = new LongNode(-operand.asLong());
                }
            }
        } else {
            Object var3_11 = null;
        }
        this.lastVisited = "visitUnary_op";
        if (!LOG.isLoggable(Level.FINEST)) return var3_12;
        LOG.exiting(CLASS, "visitUnary_op", var3_12 == null ? "null" : var3_12.toString());
        return var3_12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode visitVar_assign(MappingExpressionParser.Var_assignContext ctx) {
        String METHOD = "visitVar_assign";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitVar_assign", new Object[]{ctx.getText(), ctx.depth()});
        }
        JsonNode result = null;
        String varName = ctx.VAR_ID().getText();
        MappingExpressionParser.ExprContext expr = ctx.expr();
        if (expr instanceof MappingExpressionParser.Function_declContext) {
            MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)expr;
            MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
            MappingExpressionParser.ExprListContext exprList = fctDeclCtx.exprList();
            DeclaredFunction fct = new DeclaredFunction(varList, exprList);
            this.setDeclaredFunction(varName, fct);
        } else if (expr instanceof MappingExpressionParser.Function_callContext) {
            MappingExpressionParser.Function_callContext fctCallCtx = (MappingExpressionParser.Function_callContext)expr;
            String functionName = fctCallCtx.VAR_ID().getText();
            DeclaredFunction declFct = this.getDeclaredFunction(functionName);
            if (declFct == null) {
                Function function = this.getJsonataFunction(functionName);
                if (function == null) throw new EvaluateRuntimeException("Unknown function: " + functionName);
                this.setJsonataFunction(varName, function);
            } else {
                this.setDeclaredFunction(varName, declFct);
            }
            result = this.visit(expr);
            this.setVariable(varName, result);
        } else if (expr instanceof MappingExpressionParser.Fct_chainContext) {
            MappingExpressionParser.ExprContext exprCtx = ((MappingExpressionParser.Fct_chainContext)expr).expr(0);
            if (exprCtx instanceof MappingExpressionParser.Var_recallContext) {
                String fctName = exprCtx.getText();
                DeclaredFunction declFct = this.getDeclaredFunction(fctName);
                if (declFct != null) {
                    this.setDeclaredFunction(varName, declFct);
                    result = this.visit(((MappingExpressionParser.Fct_chainContext)expr).expr(1));
                } else {
                    Function fct = this.getJsonataFunction(fctName);
                    if (fct != null) {
                        this.setJsonataFunction(varName, fct);
                        result = this.visit(((MappingExpressionParser.Fct_chainContext)expr).expr(1));
                    } else {
                        result = null;
                    }
                }
            }
        } else {
            result = this.visit(expr);
            this.setVariable(varName, result);
        }
        this.lastVisited = "visitVar_assign";
        if (!LOG.isLoggable(Level.FINEST)) return result;
        LOG.exiting(CLASS, "visitVar_assign", result == null ? "null" : result.toString());
        return result;
    }

    @Override
    public JsonNode visitVar_recall(MappingExpressionParser.Var_recallContext ctx) {
        String METHOD = "visitVar_assign";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitVar_assign", new Object[]{ctx.getText(), ctx.depth()});
        }
        String varName = ctx.getText();
        JsonNode result = this.getVariable(varName);
        this.lastVisited = "visitVar_assign";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitVar_assign", result == null ? "null" : result.toString());
        }
        return result;
    }

    public static class SelectorArrayNode
    extends ArrayNode {
        private static final long serialVersionUID = -641395411309729158L;
        private List<JsonNode> selectionGroups = new ArrayList<JsonNode>();

        public SelectorArrayNode(JsonNodeFactory nc) {
            super(nc);
        }

        public void addAsSelectionGroup(JsonNode group) {
            if (group.isArray()) {
                this.addAll((ArrayNode)group);
            } else {
                this.add(group);
            }
            this.selectionGroups.add(group);
        }

        public List<JsonNode> getSelectionGroups() {
            return Collections.unmodifiableList(this.selectionGroups);
        }
    }
}

