/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.FrameEnvironment;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.Constants;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class DeclaredFunction {
    MappingExpressionParser.VarListContext _varList;
    MappingExpressionParser.ExprListContext _exprList;

    public DeclaredFunction(MappingExpressionParser.VarListContext varList, MappingExpressionParser.ExprListContext exprList) {
        if (varList == null) {
            throw new EvaluateRuntimeException("VarListContext passed is null.");
        }
        if (exprList == null) {
            throw new EvaluateRuntimeException("ExprListContext passed is null.");
        }
        this._varList = varList;
        this._exprList = exprList;
    }

    public MappingExpressionParser.ExprListContext getExpressionList() {
        return this._exprList;
    }

    public List<TerminalNode> getVariables() {
        List<TerminalNode> variables = this._varList.getTokens(41);
        if (variables == null) {
            variables = new ArrayList<TerminalNode>();
        }
        return variables;
    }

    public int getVariableCount() {
        return this.getVariables().size();
    }

    public int getMaxArgs() {
        return this.getVariableCount();
    }

    public int getMinArgs() {
        return this.getVariableCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, ParserRuleContext ruleValues) {
        FrameEnvironment oldEnvironment = expressionVisitor.setNewEnvironment();
        JsonNode result = null;
        MappingExpressionParser.ExprValuesContext exprValues = null;
        MappingExpressionParser.Function_callContext fctCallValues = null;
        if (ruleValues instanceof MappingExpressionParser.ExprValuesContext) {
            int exprListCount;
            int varListCount;
            exprValues = (MappingExpressionParser.ExprValuesContext)ruleValues;
            List<TerminalNode> varListCtx = this._varList.VAR_ID();
            List<Object> exprValuesCtx = new ArrayList();
            if (exprValues != null) {
                exprValuesCtx = exprValues.exprList().expr();
            }
            if ((varListCount = varListCtx.size()) != (exprListCount = exprValuesCtx.size())) {
                // empty if block
            }
            for (int i = 0; i < varListCount; ++i) {
                String varID = varListCtx.get(i).getText();
                JsonNode value = expressionVisitor.visit((ParseTree)exprValuesCtx.get(i));
                expressionVisitor.setVariable(varID, value);
            }
            result = expressionVisitor.visit(this._exprList);
        } else if (ruleValues instanceof MappingExpressionParser.Function_callContext) {
            int exprListCount;
            int varListCount;
            fctCallValues = (MappingExpressionParser.Function_callContext)ruleValues;
            List<TerminalNode> varListCtx = this._varList.VAR_ID();
            exprValues = fctCallValues.exprValues();
            List<Object> exprValuesCtx = new ArrayList();
            if (exprValues != null) {
                exprValuesCtx = exprValues.exprList().expr();
            }
            if ((varListCount = varListCtx.size()) != (exprListCount = exprValuesCtx.size())) {
                throw new EvaluateRuntimeException("Expected equal counts for varibles (" + varListCount + ") and values (" + exprListCount + ")");
            }
            for (int i = 0; i < varListCount; ++i) {
                String varID = varListCtx.get(i).getText();
                JsonNode value = expressionVisitor.visit((ParseTree)exprValuesCtx.get(i));
                expressionVisitor.setVariable(varID, value);
            }
            result = expressionVisitor.visit(this._exprList);
        } else if (ruleValues instanceof MappingExpressionParser.Var_recallContext) {
            String fctName = ((MappingExpressionParser.Var_recallContext)ruleValues).VAR_ID().getText();
            DeclaredFunction declFct = expressionVisitor.getDeclaredFunction(fctName);
            if (declFct == null) {
                Function function = expressionVisitor.getJsonataFunction(fctName);
                if (function == null) {
                    function = Constants.FUNCTIONS.get(fctName);
                }
                if (function == null) throw new EvaluateRuntimeException("Unknown function: " + fctName);
                result = function.invoke(expressionVisitor, (MappingExpressionParser.Function_callContext)ruleValues.getRuleContext());
            } else {
                for (int i = 0; i < declFct.getVariableCount(); ++i) {
                    String varID = declFct._varList.VAR_ID().get(i).getText();
                    JsonNode value = expressionVisitor.visit(this._exprList.expr().get(i));
                    expressionVisitor.setVariable(varID, value);
                }
                result = expressionVisitor.visit(declFct._exprList);
            }
        } else {
            result = expressionVisitor.visit(this._exprList);
        }
        expressionVisitor.resetOldEnvironment(oldEnvironment);
        return result;
    }
}

