/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import org.antlr.v4.runtime.tree.ParseTree;

public class ErrorFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$lowercase");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$lowercase");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$lowercase");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode result = null;
        NullNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = ErrorFunction.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            if (argString != null && !argString.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount == 1) {
            if (!useContext) {
                argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if (argString == null) {
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
            if (argString.isTextual()) {
                String str = argString.textValue();
                throw new EvaluateRuntimeException(str);
            }
            throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        }
        if (argCount == 2) {
            if (!useContext) {
                throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            }
            MappingExpressionParser.ExprListContext value = ctx.exprValues().exprList();
            result = expressionVisitor.visit((ParseTree)value);
            if (result != null && result.isTextual()) {
                throw new EvaluateRuntimeException(result.textValue());
            }
            throw new EvaluateRuntimeException("$error() function evaluated");
        }
        throw new EvaluateRuntimeException(argCount == 0 ? "$error() function evaluated" : ERR_ARG2BADTYPE);
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<s-:x>";
    }
}

