/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ReduceFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$reduce");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$reduce");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$reduce");
    public static String ERR_ARG1_MUST_BE_ARRAY_OF_OBJECTS = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$reduce");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        MappingExpressionParser.ExprContext varid;
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        JsonNode arrNode = null;
        MappingExpressionParser.ExprValuesContext valuesCtx = ctx.exprValues();
        MappingExpressionParser.ExprListContext exprList = valuesCtx.exprList();
        int argCount = ReduceFunction.getArgumentCount(ctx);
        if (useContext) {
            arrNode = FunctionUtils.getContextVariable(expressionVisitor);
            if (arrNode != null && !arrNode.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        JsonNode prevResult = null;
        if (argCount != 2 && argCount != 3) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        if (!useContext) {
            arrNode = expressionVisitor.visit(exprList.expr(0));
        }
        if (arrNode == null) {
            return null;
        }
        arrNode = ExpressionsVisitor.ensureArray(arrNode);
        ArrayNode mapArray = (ArrayNode)arrNode;
        int startIndex = 1;
        MappingExpressionParser.NumberContext init = null;
        prevResult = mapArray.get(0);
        MappingExpressionParser.ExprContext initCtx = exprList.expr(useContext ? 1 : 2);
        if (initCtx != null) {
            init = (MappingExpressionParser.NumberContext)initCtx;
            prevResult = expressionVisitor.visit(init);
            startIndex = 0;
        }
        if ((varid = exprList.expr(useContext ? 0 : 1)) instanceof MappingExpressionParser.Var_recallContext) {
            TerminalNode VAR_ID = ((MappingExpressionParser.Var_recallContext)varid).VAR_ID();
            String varID = varid.getText();
            DeclaredFunction fct = expressionVisitor.getDeclaredFunction(varID);
            int maxArgs = 0;
            if (fct != null) {
                int fctVarCount = fct.getMaxArgs();
                for (int i = startIndex; i < mapArray.size(); ++i) {
                    JsonNode element = mapArray.get(i);
                    MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                    maxArgs = fct.getMaxArgs();
                    evc = maxArgs <= 2 ? FunctionUtils.fillExprVarContext(fctVarCount, ctx, prevResult, element) : (maxArgs == 3 ? FunctionUtils.fillExprVarContext(fctVarCount, ctx, prevResult, element, JsonNodeFactory.instance.numberNode(i)) : (maxArgs == 4 ? FunctionUtils.fillExprVarContext(fctVarCount, ctx, prevResult, element, JsonNodeFactory.instance.numberNode(i), mapArray) : FunctionUtils.fillExprVarContext(fctVarCount, ctx, prevResult, element, JsonNodeFactory.instance.numberNode(i), mapArray)));
                    prevResult = fct.invoke(expressionVisitor, evc);
                }
                return prevResult;
            } else {
                Function function = expressionVisitor.getJsonataFunction(varid.getText());
                if (function == null) throw new EvaluateRuntimeException("Expected function variable reference " + varID + " to resolve to a declared nor Jsonata function.");
                for (int i = startIndex; i < mapArray.size(); ++i) {
                    MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                    JsonNode element = mapArray.get(i);
                    int optionalArgs = FunctionUtils.getOptionalArgCount(function.getSignature());
                    maxArgs = function.getMaxArgs() - optionalArgs;
                    prevResult = maxArgs <= 2 ? FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, prevResult, element) : (maxArgs == 3 ? FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, prevResult, element, JsonNodeFactory.instance.numberNode(i)) : FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, prevResult, element, JsonNodeFactory.instance.numberNode(i), mapArray));
                }
            }
            return prevResult;
        } else {
            if (!(varid instanceof MappingExpressionParser.Function_declContext)) return prevResult;
            MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)exprList.expr(useContext ? 0 : 1);
            MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
            if (varList.getChildCount() < 5) {
                throw new EvaluateRuntimeException("The second argument of reduce function must be a function with at least two arguments");
            }
            MappingExpressionParser.ExprListContext fctBody = fctDeclCtx.exprList();
            DeclaredFunction fct = new DeclaredFunction(varList, fctBody);
            int fctVarCount = fct.getMaxArgs();
            int maxArgs = 0;
            for (int i = startIndex; i < mapArray.size(); ++i) {
                JsonNode element = mapArray.get(i);
                MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                maxArgs = fct.getMaxArgs();
                evc = maxArgs <= 2 ? FunctionUtils.fillExprVarContext(fctVarCount, ctx, prevResult, element) : (maxArgs == 3 ? FunctionUtils.fillExprVarContext(fctVarCount, ctx, prevResult, element, JsonNodeFactory.instance.numberNode(i)) : (maxArgs == 4 ? FunctionUtils.fillExprVarContext(fctVarCount, ctx, prevResult, element, JsonNodeFactory.instance.numberNode(i), mapArray) : FunctionUtils.fillExprVarContext(fctVarCount, ctx, prevResult, element, JsonNodeFactory.instance.numberNode(i), mapArray)));
                prevResult = fct.invoke(expressionVisitor, evc);
            }
        }
        return prevResult;
    }

    @Override
    public int getMaxArgs() {
        return 3;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<afj?:j";
    }

    public void addObject(ArrayNode result, ObjectNode obj) {
        Iterator<String> it = obj.fieldNames();
        while (it.hasNext()) {
            String key = it.next();
            ObjectNode cell = JsonNodeFactory.instance.objectNode();
            cell.set(key, obj.get(key));
            result.add(cell);
        }
    }
}

