/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Signature {
    static ObjectNode s_arraySignatureMapping = new ObjectNode(JsonNodeFactory.instance);
    ObjectNode _param = JsonNodeFactory.instance.objectNode();
    ArrayNode _params = JsonNodeFactory.instance.arrayNode();
    ObjectNode _prevParam = this._param;
    Pattern _regex = null;
    String _signature = "";

    public Signature(String signature) {
        this.parseSignature(signature);
    }

    int findClosingBracket(String str, int start, char openSymbol, char closeSymbol) {
        int depth = 1;
        int position = start;
        while (position < str.length()) {
            char symbol;
            if ((symbol = str.charAt(++position)) == closeSymbol) {
                if (--depth != 0) continue;
                break;
            }
            if (symbol != openSymbol) continue;
            ++depth;
        }
        return position;
    }

    String getSymbol(Object value) {
        String symbol;
        if (value == null) {
            symbol = "m";
        } else if (value instanceof DeclaredFunction || value instanceof Function) {
            symbol = "f";
        } else if (value instanceof JsonNode) {
            switch (((JsonNode)value).getNodeType()) {
                case STRING: {
                    symbol = "s";
                    break;
                }
                case NUMBER: {
                    symbol = "n";
                    break;
                }
                case BOOLEAN: {
                    symbol = "b";
                    break;
                }
                case NULL: {
                    symbol = "l";
                    break;
                }
                case ARRAY: {
                    symbol = "a";
                    break;
                }
                case OBJECT: {
                    symbol = "o";
                    break;
                }
                default: {
                    symbol = "m";
                    break;
                }
            }
        } else {
            symbol = "m";
        }
        return symbol;
    }

    void next() {
        this._params.add(this._param);
        this._prevParam = this._param;
        this._param = JsonNodeFactory.instance.objectNode();
    }

    Pattern parseSignature(String signature) {
        char symbol;
        block13: for (int position = 1; position < signature.length() && (symbol = signature.charAt(position)) != ':'; ++position) {
            switch (symbol) {
                case 'b': 
                case 'l': 
                case 'n': 
                case 'o': 
                case 's': {
                    this._param.put("regex", "[" + symbol + "m]");
                    this._param.put("type", symbol);
                    this.next();
                    continue block13;
                }
                case 'a': {
                    this._param.put("regex", "[asnblfom]");
                    this._param.put("type", symbol);
                    this._param.put("array", true);
                    this.next();
                    continue block13;
                }
                case 'f': {
                    this._param.put("regex", "f");
                    this._param.put("type", symbol);
                    this.next();
                    continue block13;
                }
                case 'j': {
                    this._param.put("regex", "[asnblom]");
                    this._param.put("type", symbol);
                    this.next();
                    continue block13;
                }
                case 'x': {
                    this._param.put("regex", "[asnblfom]");
                    this._param.put("type", symbol);
                    this.next();
                    continue block13;
                }
                case '-': {
                    this._prevParam.put("context", true);
                    this._prevParam.put("regex", this._prevParam.get("regex").asText() + "?");
                    continue block13;
                }
                case '+': 
                case '?': {
                    this._prevParam.put("regex", this._prevParam.get("regex").asText() + symbol);
                    continue block13;
                }
                case '(': {
                    int endParen = this.findClosingBracket(signature, position, '(', ')');
                    String choice = signature.substring(position + 1, endParen);
                    if (choice.indexOf("<") != -1) {
                        throw new EvaluateRuntimeException("Choice groups containing parameterized types are not supported");
                    }
                    this._param.put("regex", "[" + choice + "m]");
                    this._param.put("type", "(" + choice + ")");
                    position = endParen;
                    this.next();
                    continue block13;
                }
                case '<': {
                    JsonNode test = this._prevParam.get("type");
                    if (test != null) {
                        String type = test.asText();
                        if (type.equals("a") || type.equals("f")) {
                            int endPos = this.findClosingBracket(signature, position, '<', '>');
                            this._prevParam.put("subtype", signature.substring(position + 1, endPos));
                            position = endPos;
                            continue block13;
                        }
                        throw new EvaluateRuntimeException("Type parameters can only be applied to functions and arrays");
                    }
                    throw new EvaluateRuntimeException("Type parameters can only be applied to functions and arrays");
                }
            }
        }
        String regexStr = "^";
        for (ObjectNode param : this._params) {
            regexStr = regexStr + "(" + param.get("regex").asText() + ")";
        }
        regexStr = regexStr + "$";
        this._regex = null;
        try {
            this._regex = Pattern.compile(regexStr);
            this._signature = regexStr;
        }
        catch (PatternSyntaxException pse) {
            throw new EvaluateRuntimeException(pse.getLocalizedMessage());
        }
        return this._regex;
    }

    void throwValidationError(MappingExpressionParser.ExprListContext badArgs, String badSig, String functionName) {
        String partialPattern = "^";
        int goodTo = 0;
        for (int index = 0; index < this._params.size(); ++index) {
            Pattern tester = Pattern.compile(partialPattern = partialPattern + ((ObjectNode)this._params.get(index)).get("regex"));
            Matcher match = tester.matcher(badSig);
            if (!match.matches()) {
                throw new EvaluateRuntimeException("Argument \"" + (goodTo + 1) + "\" of function \"" + functionName + "\" does not match function signature");
            }
            goodTo = match.end();
        }
        throw new EvaluateRuntimeException("Argument \"" + (goodTo + 1) + "\" of function \"" + functionName + "\" does not match function signature");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ArrayNode validate(String functionName, MappingExpressionParser.ExprListContext args, ExpressionsVisitor expressionVisitor) {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        String suppliedSig = "";
        for (MappingExpressionParser.ExprContext arg : args.expr()) {
            suppliedSig = suppliedSig + this.getSymbol(arg);
        }
        Matcher isValid = this._regex.matcher(suppliedSig);
        if (isValid != null) {
            ArrayNode validatedArgs = JsonNodeFactory.instance.arrayNode();
            int argIndex = 0;
            int index = 0;
            for (ObjectNode param : this._params) {
                JsonNode arg = expressionVisitor.visit(args.expr(argIndex));
                String match = isValid.group(index + 1);
                if ("".equals(match)) {
                    boolean useContext;
                    boolean bl = useContext = param.get("context") != null && param.get("context").asBoolean();
                    if (useContext) {
                        JsonNode context = expressionVisitor.getVariable("$");
                        String contextType = this.getSymbol(context);
                        if (!Pattern.matches(param.get("regex").asText(), contextType)) throw new EvaluateRuntimeException("Context value is not a compatible type with argument \"" + argIndex + 1 + "\" of function \"" + functionName + "\"");
                        validatedArgs.add(context);
                    } else {
                        validatedArgs.add(arg);
                        ++argIndex;
                    }
                } else {
                    String[] singles;
                    for (String single : singles = match.split("")) {
                        if ("a".equals(param.get("type").asText())) {
                            if ("m".equals(single)) {
                                arg = null;
                            } else {
                                arg = expressionVisitor.visit(args.expr(argIndex));
                                boolean arrayOK = true;
                                String subtype = "undefined";
                                JsonNode testSubType = param.get("subtype");
                                if (testSubType != null) {
                                    ArrayNode argArray;
                                    subtype = testSubType.asText();
                                    if (!"a".equals(single) && !match.equals(subtype)) {
                                        arrayOK = false;
                                    } else if ("a".equals(single) && (argArray = (ArrayNode)arg).size() > 0) {
                                        String itemType = this.getSymbol(argArray.get(0));
                                        if (!itemType.equals(subtype)) {
                                            arrayOK = false;
                                        } else {
                                            ArrayNode differentItems = JsonNodeFactory.instance.arrayNode();
                                            for (JsonNode val : argArray) {
                                                if (itemType.equals(this.getSymbol(val))) continue;
                                                differentItems.add(expressionVisitor.visit((MappingExpressionParser.ExprListContext)((Object)val)));
                                            }
                                            boolean bl = arrayOK = differentItems.size() == 0;
                                        }
                                    }
                                }
                                if (!arrayOK) {
                                    JsonNode type = s_arraySignatureMapping.get(subtype);
                                    if (type != null) throw new EvaluateRuntimeException("Argument \"" + (argIndex + 1) + "\" of function \"" + functionName + "\" must be an array of \"" + type.asText() + "\"");
                                    type = JsonNodeFactory.instance.nullNode();
                                    throw new EvaluateRuntimeException("Argument \"" + (argIndex + 1) + "\" of function \"" + functionName + "\" must be an array of \"" + type.asText() + "\"");
                                }
                                if (!"a".equals(single)) {
                                    ArrayNode wrappedArg = JsonNodeFactory.instance.arrayNode();
                                    wrappedArg.add(arg);
                                    arg = wrappedArg;
                                }
                            }
                            validatedArgs.add(arg);
                            ++argIndex;
                            continue;
                        }
                        validatedArgs.add(arg);
                        ++argIndex;
                    }
                }
                ++index;
            }
            return validatedArgs;
        }
        this.throwValidationError(args, suppliedSig, functionName);
        return result;
    }

    static {
        s_arraySignatureMapping.put("a", "arrays");
        s_arraySignatureMapping.put("b", "booleans");
        s_arraySignatureMapping.put("f", "functions");
        s_arraySignatureMapping.put("n", "numbers");
        s_arraySignatureMapping.put("o", "objects");
        s_arraySignatureMapping.put("s", "strings");
    }
}

