/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.Constants;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;

public class FormatNumberFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = 6183052815295323040L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$formatNumber");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$formatNumber");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$formatNumber");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$formatNumber");
    public static String ERR_ARG4BADTYPE = String.format("Argument 4 of function %s does not match function signature", "$formatNumber");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        JsonNode argNumber = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = FormatNumberFunction.getArgumentCount(ctx);
        if (useContext) {
            argNumber = FunctionUtils.getContextVariable(expressionVisitor);
            if (argNumber != null && !argNumber.isNull()) {
                if (!argNumber.isNumber()) {
                    throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
                }
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 2 && argCount != 3) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : (argCount == 1 ? ERR_ARG2BADTYPE : ERR_ARG4BADTYPE));
        if (!useContext) {
            argNumber = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argNumber == null) {
            return null;
        }
        double number = argNumber.isNumber() ? argNumber.asDouble() : Double.NaN;
        JsonNode argPicture = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
        if (argPicture == null) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        if (!argPicture.isTextual()) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        String picture = argPicture.textValue();
        DecimalFormatSymbols symbols = Constants.DEFAULT_DECIMAL_FORMAT_SYMBOLS;
        if (argCount == 3) {
            JsonNode argOptions = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 1 : 2);
            if (argOptions == null) throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
            if (!argOptions.isObject()) throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
            symbols = this.processOptionsArg(argOptions);
        }
        DecimalFormat formatter = new DecimalFormat();
        formatter.setDecimalFormatSymbols(symbols);
        String fixedPicture = picture.replaceAll("9", "0");
        formatter.applyLocalizedPattern(fixedPicture);
        return new TextNode(formatter.format(number));
    }

    private DecimalFormatSymbols processOptionsArg(JsonNode argOptions) {
        DecimalFormatSymbols symbols = (DecimalFormatSymbols)Constants.DEFAULT_DECIMAL_FORMAT_SYMBOLS.clone();
        Iterator<String> fieldNames = argOptions.fieldNames();
        block24: while (fieldNames.hasNext()) {
            String fieldName = fieldNames.next();
            JsonNode valueNode = argOptions.get(fieldName);
            switch (fieldName) {
                case "decimal-separator": {
                    String value = this.getFormattingCharacter(valueNode, "decimal-separator", true);
                    symbols.setDecimalSeparator(value.charAt(0));
                    continue block24;
                }
                case "grouping-separator": {
                    String value = this.getFormattingCharacter(valueNode, "grouping-separator", true);
                    symbols.setGroupingSeparator(value.charAt(0));
                    continue block24;
                }
                case "infinity": {
                    String value = this.getFormattingCharacter(valueNode, "infinity", false);
                    symbols.setInfinity(value);
                    continue block24;
                }
                case "minus-sign": {
                    String value = this.getFormattingCharacter(valueNode, "minus-sign", true);
                    symbols.setMinusSign(value.charAt(0));
                    continue block24;
                }
                case "NaN": {
                    String value = this.getFormattingCharacter(valueNode, "NaN", false);
                    symbols.setNaN(value);
                    continue block24;
                }
                case "percent": {
                    String value = this.getFormattingCharacter(valueNode, "percent", true);
                    symbols.setPercent(value.charAt(0));
                    continue block24;
                }
                case "per-mille": {
                    String value = this.getFormattingCharacter(valueNode, "per-mille", true);
                    symbols.setPerMill(value.charAt(0));
                    continue block24;
                }
                case "zero-digit": {
                    String value = this.getFormattingCharacter(valueNode, "zero-digit", true);
                    symbols.setZeroDigit(value.charAt(0));
                    continue block24;
                }
                case "digit": {
                    String value = this.getFormattingCharacter(valueNode, "digit", true);
                    symbols.setDigit(value.charAt(0));
                    continue block24;
                }
                case "pattern-separator": {
                    String value = this.getFormattingCharacter(valueNode, "pattern-separator", true);
                    symbols.setPatternSeparator(value.charAt(0));
                    continue block24;
                }
            }
            String msg = String.format("Argument 3 of function %s is invalid. %s is not a valid property name", "$formatNumber", fieldName);
            throw new EvaluateRuntimeException(msg);
        }
        return symbols;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFormattingCharacter(JsonNode valueNode, String propertyName, boolean isChar) {
        String formattingChar = null;
        if (valueNode != null && valueNode.isTextual()) {
            String value = valueNode.textValue();
            if (value != null && !value.isEmpty()) {
                if (!isChar) return value;
                if (value.length() == 1) {
                    return value;
                }
                String msg = String.format("Argument 3 of function %s is invalid. The value of the %s property must be a single character", "$formatNumber", propertyName);
                throw new EvaluateRuntimeException(msg);
            }
            String msgTemplate = isChar ? "Argument 3 of function %s is invalid. The value of the %s property must be a single character" : "Argument 3 of function %s is invalid. The value of the %s property must be a string";
            String msg = String.format(msgTemplate, "$formatNumber", propertyName);
            throw new EvaluateRuntimeException(msg);
        }
        String msgTemplate = isChar ? "Argument 3 of function %s is invalid. The value of the %s property must be a single character" : "Argument 3 of function %s is invalid. The value of the %s property must be a string";
        String msg = String.format(msgTemplate, "$formatNumber", propertyName);
        throw new EvaluateRuntimeException(msg);
    }

    @Override
    public int getMaxArgs() {
        return 3;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<n-so?:s>";
    }
}

