/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.DateTimeUtils;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;

public class FromMillisFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = -8678149963930460618L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$fromMillis");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$fromMillis");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$fromMillis");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        JsonNode argNumber = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = FromMillisFunction.getArgumentCount(ctx);
        if (useContext) {
            argNumber = FunctionUtils.getContextVariable(expressionVisitor);
            if (argNumber != null && !argNumber.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount < 1) throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
        if (argCount > 3) throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
        if (!useContext) {
            argNumber = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        JsonNode picture = JsonNodeFactory.instance.nullNode();
        if (argCount >= 2) {
            picture = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 1);
        }
        JsonNode timezone = JsonNodeFactory.instance.nullNode();
        if (argCount == 3) {
            timezone = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 2);
        }
        if (argNumber == null) {
            return null;
        }
        if (!argNumber.isNumber()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        Long millis = argNumber.asLong();
        String pictureStr = null;
        if (picture != null && !picture.isNull()) {
            pictureStr = picture.asText();
        }
        String timezoneStr = null;
        if (timezone == null) return new TextNode(DateTimeUtils.formatDateTime(millis, pictureStr, timezoneStr));
        if (timezone.isNull()) return new TextNode(DateTimeUtils.formatDateTime(millis, pictureStr, timezoneStr));
        timezoneStr = timezone.asText();
        return new TextNode(DateTimeUtils.formatDateTime(millis, pictureStr, timezoneStr));
    }

    @Override
    public int getMaxArgs() {
        return 3;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<n-s?s?:s>";
    }
}

