/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;

public class LowercaseFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = 7939773729531364779L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$lowercase");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$lowercase");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$lowercase");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode result = null;
        JsonNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = LowercaseFunction.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            if (argString != null && !argString.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount == 1) {
            if (!useContext) {
                argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if (argString == null) {
                return null;
            }
            if (!argString.isTextual()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            String str = argString.textValue();
            return new TextNode(str.toLowerCase());
        }
        if (argCount != 2) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        if (!useContext) {
            throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        }
        MappingExpressionParser.ExprListContext value = ctx.exprValues().exprList();
        result = expressionVisitor.visit(value);
        if (result == null) return result;
        if (!result.isTextual()) return result;
        return new TextNode(result.textValue().toLowerCase());
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<s-:s>";
    }
}

