/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.JS4JDate;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.DateTimeUtils;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;

public class ToMillisFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = 4484749083861634204L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$toMillis");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$toMillis");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$toMillis");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        LongNode result = null;
        JsonNode argTimestamp = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = ToMillisFunction.getArgumentCount(ctx);
        if (useContext) {
            argTimestamp = FunctionUtils.getContextVariable(expressionVisitor);
            if (argTimestamp != null && !argTimestamp.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount < 1) throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
        if (argCount > 2) throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
        if (!useContext) {
            argTimestamp = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        JsonNode picture = JsonNodeFactory.instance.nullNode();
        if (argCount == 2) {
            picture = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 1);
        }
        if (argTimestamp == null) {
            return null;
        }
        if (!argTimestamp.isTextual()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        try {
            Long millis = picture != null && !picture.isNull() ? DateTimeUtils.parseDateTime(argTimestamp.asText(), picture.asText()) : Long.valueOf(OffsetDateTime.parse(argTimestamp.asText()).toInstant().toEpochMilli());
            if (millis != null) return new LongNode(millis);
            return null;
        }
        catch (DateTimeParseException e) {
            JS4JDate testDate = new JS4JDate();
            try {
                testDate = new JS4JDate(argTimestamp.asText());
            }
            catch (Exception e1) {
                String msg = String.format("The argument for the $toMillis function must be an ISO 8601 format datetime string: \"%s\"", argTimestamp.asText());
                throw new EvaluateRuntimeException(msg);
            }
            Long millis = testDate.getTime();
            return new LongNode(millis);
        }
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<s-s?:n>";
    }
}

