/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.api.jsonata4java.expressions.utils.NumberUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ValueNode;

public class NumberFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = 5495142821729936220L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$number");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$number");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$number");

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        void var3_11;
        Object var3_3 = null;
        NullNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = NumberFunction.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            if (argString != null && !argString.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 1 && !useContext) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        if (!useContext) {
            argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argString == null) {
            return null;
        }
        if (argString.isObject()) {
            throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        }
        if (argString.isTextual()) {
            ValueNode valueNode = NumberUtils.convertNumberToValueNode(argString.asText());
            return var3_11;
        } else if (argString.isNumber()) {
            if (!argString.isIntegralNumber()) {
                Double ceil = argString.doubleValue();
                if (ceil - (double)ceil.longValue() == 0.0) {
                    LongNode longNode = new LongNode(ceil.longValue());
                    return var3_11;
                } else {
                    DoubleNode doubleNode = new DoubleNode(ceil.doubleValue());
                }
                return var3_11;
            } else if (argString.isLong()) {
                double ceil = argString.doubleValue();
                LongNode longNode = new LongNode((long)ceil);
                return var3_11;
            } else {
                NullNode nullNode = argString;
            }
            return var3_11;
        } else {
            if (argString.isArray()) {
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
            if (!argString.isBoolean()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            LongNode longNode = argString.asBoolean() ? new LongNode(1L) : new LongNode(0L);
        }
        return var3_11;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<(nsb)-:n>";
    }
}

