/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.DateTimeUtils;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import java.time.Instant;

public class NowFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = 5607559377364554518L;
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$now");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        int argCount = NowFunction.getArgumentCount(ctx);
        JsonNode picture = JsonNodeFactory.instance.nullNode();
        if (argCount >= 1) {
            picture = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        JsonNode timezone = JsonNodeFactory.instance.nullNode();
        if (argCount == 2) {
            timezone = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 1);
        }
        String pictureStr = null;
        if (picture != null && !picture.isNull()) {
            pictureStr = picture.asText();
        }
        String timezoneStr = null;
        if (timezone != null && !timezone.isNull()) {
            timezoneStr = timezone.asText();
        }
        result = new TextNode(DateTimeUtils.formatDateTime(Instant.now().toEpochMilli(), pictureStr, timezoneStr));
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<s?s?:s>";
    }
}

