/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions;

import com.api.jsonata4java.expressions.BufferingErrorListener;
import com.api.jsonata4java.expressions.EvaluateException;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.FrameEnvironment;
import com.api.jsonata4java.expressions.ParseException;
import com.api.jsonata4java.expressions.generated.MappingExpressionLexer;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.tree.ErrorNodeImpl;
import org.antlr.v4.runtime.tree.ParseTree;

public class Expressions
implements Serializable {
    private static final long serialVersionUID = -2995139816481454905L;
    ParseTree _tree = null;
    String _expression = null;
    ExpressionsVisitor _eval = new ExpressionsVisitor(null, new FrameEnvironment(null));

    public static List<String> getRefsInExpression(Pattern refPattern, String expression) {
        Matcher matcher = refPattern.matcher(expression);
        LinkedList<String> matches = new LinkedList<String>();
        while (matcher.find()) {
            matches.add(matcher.group(1));
        }
        return matches;
    }

    public Expressions(ParseTree aTree, String anExpression) {
        this._tree = aTree;
        this._expression = anExpression;
    }

    public static Expressions parse(String mappingExpression) throws ParseException, IOException {
        ByteArrayInputStream targetStream = new ByteArrayInputStream(mappingExpression.getBytes(StandardCharsets.UTF_8));
        CharStream input = CharStreams.fromStream(targetStream, StandardCharsets.UTF_8);
        MappingExpressionLexer lexer = new MappingExpressionLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        MappingExpressionParser parser = new MappingExpressionParser(tokens);
        MappingExpressionParser.Expr_to_eofContext tree = null;
        MappingExpressionParser.ExprContext newTree = null;
        BufferingErrorListener errorListener = new BufferingErrorListener();
        try {
            parser.removeErrorListeners();
            lexer.removeErrorListeners();
            parser.addErrorListener(errorListener);
            lexer.addErrorListener(errorListener);
            tree = parser.expr_to_eof();
            if (errorListener.heardErrors()) {
                ParseTree error;
                if (tree != null && tree.getChildCount() > 0 && (error = tree.getChild(0)) instanceof ErrorNodeImpl && ((ErrorNodeImpl)error).getSymbol().getType() == 25) {
                    throw new EvaluateRuntimeException("The symbol \"~>\" cannot be used as a unary operator");
                }
                throw new ParseException(errorListener.getErrorsAsString());
            }
            newTree = tree.expr();
        }
        catch (RecognitionException e) {
            throw new ParseException(e.getMessage());
        }
        return new Expressions(newTree, mappingExpression);
    }

    public JsonNode evaluate(JsonNode rootContext, long timeoutMS, int maxDepth) throws EvaluateException {
        JsonNode result = null;
        this._eval.setRootContext(rootContext);
        if (timeoutMS <= 0L) {
            throw new EvaluateException("The timeoutMS must be a positive number. Received " + timeoutMS);
        }
        if (maxDepth <= 0) {
            throw new EvaluateException("The maxDepth must be a positive number. Received " + maxDepth);
        }
        this._eval.timeboxExpression(timeoutMS, maxDepth);
        try {
            result = this._eval.visitTree(this._tree);
        }
        catch (EvaluateRuntimeException e) {
            throw new EvaluateException(e.getMessage(), e);
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    public JsonNode evaluate(JsonNode rootContext) throws EvaluateException {
        JsonNode result = null;
        this._eval.setRootContext(rootContext);
        try {
            result = this._eval.visitTree(this._tree);
        }
        catch (EvaluateRuntimeException e) {
            throw new EvaluateException(e.getMessage(), e);
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    public FrameEnvironment getEnvironment() {
        return this._eval.getEnvironment();
    }

    public ExpressionsVisitor getExpr() {
        return this._eval;
    }

    public void setExpr(ExpressionsVisitor expr) {
        this._eval = expr;
    }

    public ParseTree getTree() {
        return this._tree;
    }

    public void setTree(ParseTree parsetree) {
        this._tree = parsetree;
    }

    public void timeboxExpression(long timeoutMS, int maxDepth) {
        this._eval.timeboxExpression(timeoutMS, maxDepth);
    }

    public String toString() {
        return this._expression;
    }
}

