/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.issues;

import com.api.jsonata4java.expressions.BufferingErrorListener;
import com.api.jsonata4java.expressions.EvaluateException;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.Expressions;
import com.api.jsonata4java.expressions.ParseException;
import com.api.jsonata4java.expressions.generated.MappingExpressionLexer;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.issues.TreeUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.tree.ErrorNodeImpl;
import org.antlr.v4.runtime.tree.ParseTree;

public class Issue180 {
    public static void main(String[] args) {
        Expressions expr = null;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonObj = null;
        String json = "{\n  \"NotificationData\" : {\n    \"notificationType\" : \"DEPARTUREPREP\",\n    \"notificationLanguage\" : \"ES\",\n    \"emailaddress\" : [ \"MAROJAS44@GMAIL.COM\", \"MAROJAS44@GMAIL.COM\", \"MAROJAS44@GMAIL.COM\", \"MAROJAS44@GMAIL.COM\", \"MAROJAS44@GMAIL.COM\", \"MAROJAS44@GMAIL.COM\", \"MAROJAS44@GMAIL.COM\", \"MAROJAS44@GMAIL.COM\" ],\n    \"dynamicData\" : {\n      \"currentDatetime\" : \"Wednesday, December 15, 2021 11:13 AM\",\n      \"currentDatetimeStd\" : \"2021-12-15T11:13:46.731-05:00\",\n      \"reservation\" : \"ALNJMP\",\n      \"reservationDetails\" : {\n        \"issueDate\" : \"2021-10-03\",\n        \"ticketStatus\" : \"3\",\n        \"ticketType\" : \"eTicket\"\n      },\n      \"passengers\" : [ {\n        \"givenName\" : \"MANUELMR\",\n        \"surname\" : \"ROJAS\",\n        \"frequentFlyerNumber\" : \"266336503\",\n        \"type\" : \"ADT\",\n        \"key\" : \"1.1\",\n        \"nvPair\" : [ {\n          \"name\" : \"bagsAllowedCount\",\n          \"value\" : \"\"\n        } ]\n      }, {\n        \"givenName\" : \"ROSARIOMRS\",\n        \"surname\" : \"ROJAS\",\n        \"type\" : \"ADT\",\n        \"key\" : \"2.2\",\n        \"nvPair\" : [ {\n          \"name\" : \"bagsAllowedCount\",\n          \"value\" : \"\"\n        } ]\n      } ],\n      \"flights\" : [ {\n        \"operatingAirlineCode\" : \"CM\",\n        \"flightNumber\" : \"827\",\n        \"isFinalDestination\" : \"false\",\n        \"fareFamily\" : \"Economy Classic\",\n        \"status\" : \"26\",\n        \"departure\" : [ {\n          \"date\" : \"2021-12-27\",\n          \"time\" : \"7:11 AM\",\n          \"datetimeStd\" : \"2021-12-27T07:11:00.000-05:00\",\n          \"airportCode\" : \"BAQ\",\n          \"city\" : \"Barranquilla\",\n          \"nvPair\" : [ {\n            \"name\" : \"countryCode\",\n            \"value\" : \"CO\"\n          } ]\n        } ],\n        \"arrival\" : [ {\n          \"date\" : \"2021-12-27\",\n          \"time\" : \"8:34 AM\",\n          \"datetimeStd\" : \"2021-12-27T08:34:00.000-05:00\",\n          \"airportCode\" : \"PTY\",\n          \"city\" : \"Panama\",\n          \"nvPair\" : [ {\n            \"name\" : \"countryCode\",\n            \"value\" : \"PA\"\n          } ]\n        } ],\n        \"flightDuration\" : \"1h 23m\",\n        \"layover\" : \"10h 20m\",\n        \"key\" : \"3\",\n        \"nvPair\" : [ {\n          \"name\" : \"bookingClass\",\n          \"value\" : \"E\"\n        } ]\n      }, {\n        \"operatingAirlineCode\" : \"CM\",\n        \"flightNumber\" : \"285\",\n        \"isFinalDestination\" : \"true\",\n        \"status\" : \"26\",\n        \"departure\" : [ {\n          \"date\" : \"2021-12-27\",\n          \"time\" : \"6:54 PM\",\n          \"datetimeStd\" : \"2021-12-27T18:54:00.000-05:00\",\n          \"airportCode\" : \"PTY\",\n          \"city\" : \"Panama\",\n          \"nvPair\" : [ {\n            \"name\" : \"countryCode\",\n            \"value\" : \"PA\"\n          } ]\n        } ],\n        \"arrival\" : [ {\n          \"date\" : \"2021-12-27\",\n          \"time\" : \"10:25 PM\",\n          \"datetimeStd\" : \"2021-12-27T22:25:00.000-05:00\",\n          \"airportCode\" : \"MCO\",\n          \"city\" : \"Orlando\",\n          \"nvPair\" : [ {\n            \"name\" : \"countryCode\",\n            \"value\" : \"US\"\n          } ]\n        } ],\n        \"flightDuration\" : \"3h 31m\",\n        \"key\" : \"4\",\n        \"nvPair\" : [ {\n          \"name\" : \"bookingClass\",\n          \"value\" : \"E\"\n        } ]\n      } ]\n    },\n    \"message\" : {\n      \"restrictions\" : [ {\n        \"countryCode\" : \"PS\",\n        \"countryName\" : {\n          \"en\" : \"\",\n          \"es\" : \"\",\n          \"pt\" : \"\"\n        },\n        \"url\" : \"\"\n      }, {\n        \"countryCode\" : \"US\",\n        \"countryName\" : {\n          \"en\" : \"United States\",\n          \"es\" : \"Estados Unidos\",\n          \"pt\" : \"Estados Unidos\"\n        },\n        \"url\" : \"\"\n      } ]\n    }\n  },\n  \"UUID\" : \"5644006e-8c9b-4f3d-9c8f-af976eff5199\",\n  \"LangURLs\" : [ {\n    \"Lang\" : \"EN\",\n    \"LangURL\" : \"\"\n  }, {\n    \"Lang\" : \"ES\",\n    \"LangURL\" : \"\"\n  }, {\n    \"Lang\" : \"PT\",\n    \"LangURL\" : \"\"\n  } ],\n  \"dateTranslation\" : {\n    \"es\" : [ {\n      \"key\" : \"monday\",\n      \"value\" : \"Lunes\"\n    }, {\n      \"key\" : \"tuesday\",\n      \"value\" : \"Martes\"\n    }, {\n      \"key\" : \"wednesday\",\n      \"value\" : \"Mi\u00e9rcoles\"\n    }, {\n      \"key\" : \"thursday\",\n      \"value\" : \"Jueves\"\n    }, {\n      \"key\" : \"friday\",\n      \"value\" : \"Viernes\"\n    }, {\n      \"key\" : \"saturday\",\n      \"value\" : \"S\u00e1bado\"\n    }, {\n      \"key\" : \"sunday\",\n      \"value\" : \"Domingo\"\n    }, {\n      \"key\" : \"mon\",\n      \"value\" : \"Lun\"\n    }, {\n      \"key\" : \"tue\",\n      \"value\" : \"Mar\"\n    }, {\n      \"key\" : \"wed\",\n      \"value\" : \"Mi\u00e9\"\n    }, {\n      \"key\" : \"thu\",\n      \"value\" : \"Jue\"\n    }, {\n      \"key\" : \"fri\",\n      \"value\" : \"Vie\"\n    }, {\n      \"key\" : \"sat\",\n      \"value\" : \"Sab\"\n    }, {\n      \"key\" : \"sun\",\n      \"value\" : \"Dom\"\n    }, {\n      \"key\" : \"january\",\n      \"value\" : \"Enero\"\n    }, {\n      \"key\" : \"february\",\n      \"value\" : \"Febrero\"\n    }, {\n      \"key\" : \"march\",\n      \"value\" : \"Marzo\"\n    }, {\n      \"key\" : \"april\",\n      \"value\" : \"Abril\"\n    }, {\n      \"key\" : \"june\",\n      \"value\" : \"Junio\"\n    }, {\n      \"key\" : \"july\",\n      \"value\" : \"Julio\"\n    }, {\n      \"key\" : \"august\",\n      \"value\" : \"Agosto\"\n    }, {\n      \"key\" : \"september\",\n      \"value\" : \"Septiembre\"\n    }, {\n      \"key\" : \"october\",\n      \"value\" : \"Octubre\"\n    }, {\n      \"key\" : \"november\",\n      \"value\" : \"Noviembre\"\n    }, {\n      \"key\" : \"december\",\n      \"value\" : \"Diciembre\"\n    }, {\n      \"key\" : \"jan\",\n      \"value\" : \"Ene\"\n    }, {\n      \"key\" : \"feb\",\n      \"value\" : \"Feb\"\n    }, {\n      \"key\" : \"mar\",\n      \"value\" : \"Mar\"\n    }, {\n      \"key\" : \"apr\",\n      \"value\" : \"Abr\"\n    }, {\n      \"key\" : \"may\",\n      \"value\" : \"May\"\n    }, {\n      \"key\" : \"jun\",\n      \"value\" : \"Jun\"\n    }, {\n      \"key\" : \"jul\",\n      \"value\" : \"Jul\"\n    }, {\n      \"key\" : \"aug\",\n      \"value\" : \"Ago\"\n    }, {\n      \"key\" : \"sep\",\n      \"value\" : \"Sep\"\n    }, {\n      \"key\" : \"oct\",\n      \"value\" : \"Oct\"\n    }, {\n      \"key\" : \"nov\",\n      \"value\" : \"Nov\"\n    }, {\n      \"key\" : \"dec\",\n      \"value\" : \"Dic\"\n    } ],\n    \"pt\" : [ {\n      \"key\" : \"monday\",\n      \"value\" : \"Segunda-feira\"\n    }, {\n      \"key\" : \"tuesday\",\n      \"value\" : \"Ter\u00e7a\"\n    }, {\n      \"key\" : \"wednesday\",\n      \"value\" : \"Quarta-feira\"\n    }, {\n      \"key\" : \"thursday\",\n      \"value\" : \"Quinta-feira\"\n    }, {\n      \"key\" : \"friday\",\n      \"value\" : \"Sexta-feira\"\n    }, {\n      \"key\" : \"saturday\",\n      \"value\" : \"S\u00e1bado\"\n    }, {\n      \"key\" : \"sunday\",\n      \"value\" : \"Domingo\"\n    }, {\n      \"key\" : \"mon\",\n      \"value\" : \"Seg\"\n    }, {\n      \"key\" : \"tue\",\n      \"value\" : \"Ter\"\n    }, {\n      \"key\" : \"wed\",\n      \"value\" : \"Qua\"\n    }, {\n      \"key\" : \"thu\",\n      \"value\" : \"Qui\"\n    }, {\n      \"key\" : \"fri\",\n      \"value\" : \"Sex\"\n    }, {\n      \"key\" : \"sat\",\n      \"value\" : \"S\u00e1b\"\n    }, {\n      \"key\" : \"sun\",\n      \"value\" : \"Dom\"\n    }, {\n      \"key\" : \"january\",\n      \"value\" : \"Janeiro\"\n    }, {\n      \"key\" : \"february\",\n      \"value\" : \"Fevereiro\"\n    }, {\n      \"key\" : \"march\",\n      \"value\" : \"Marcha\"\n    }, {\n      \"key\" : \"april\",\n      \"value\" : \"Abril\"\n    }, {\n      \"key\" : \"june\",\n      \"value\" : \"Junho\"\n    }, {\n      \"key\" : \"july\",\n      \"value\" : \"Julho\"\n    }, {\n      \"key\" : \"august\",\n      \"value\" : \"Agosto\"\n    }, {\n      \"key\" : \"september\",\n      \"value\" : \"Setembro\"\n    }, {\n      \"key\" : \"october\",\n      \"value\" : \"Outubro\"\n    }, {\n      \"key\" : \"november\",\n      \"value\" : \"Novembro\"\n    }, {\n      \"key\" : \"december\",\n      \"value\" : \"Dezembro\"\n    }, {\n      \"key\" : \"jan\",\n      \"value\" : \"Jan\"\n    }, {\n      \"key\" : \"feb\",\n      \"value\" : \"Fev\"\n    }, {\n      \"key\" : \"mar\",\n      \"value\" : \"Mar\"\n    }, {\n      \"key\" : \"apr\",\n      \"value\" : \"Abr\"\n    }, {\n      \"key\" : \"may\",\n      \"value\" : \"Maio\"\n    }, {\n      \"key\" : \"jun\",\n      \"value\" : \"Jun\"\n    }, {\n      \"key\" : \"jul\",\n      \"value\" : \"Jul\"\n    }, {\n      \"key\" : \"aug\",\n      \"value\" : \"Ago\"\n    }, {\n      \"key\" : \"sep\",\n      \"value\" : \"Set\"\n    }, {\n      \"key\" : \"oct\",\n      \"value\" : \"Oct\"\n    }, {\n      \"key\" : \"nov\",\n      \"value\" : \"Nov\"\n    }, {\n      \"key\" : \"dec\",\n      \"value\" : \"Dez\"\n    } ]\n  }\n}";
        String expression = "{\n    \"enCurrentDatetime\" : (\n        $in := $toMillis($now())\n          ~> $fromMillis('[FNn], [MNn] [D1], [Y0001] [h01]:[m01]', '-0500');\n        $p := $toMillis($now())\n          ~> $fromMillis(' [P]') ~> $uppercase();\n       \n        $return:= $in & $p;\n    ),\n    \"esCurrentDatetime\" : (\n     $in := $toMillis($now())\n          ~> $fromMillis('[FNn], [MNn] [D1], [Y0001] [h01]:[m01]', '-0500');\n     $p := $toMillis($now())\n          ~> $fromMillis(' [P]') ~> $uppercase();\n\n     $day := $trim($substringBefore($in,','));\n     $esDay := $.dateTranslation.es[$lowercase(key)=$lowercase($day)].value;\n    \n     $month := $trim($substringBefore($substringAfter($in, ', '),' '));\n     $esMonth := $.dateTranslation.es[$lowercase(key)=$lowercase($month)].value;\n\n     $return := $replace($in, $day, $esDay) ~> $replace($month, $esMonth);\n     $return & $p;\n    ),\n\n    \"ptCurrentDatetime\" : (\n     $in := $toMillis($now())\n          ~> $fromMillis('[FNn], [MNn] [D1], [Y0001] [h01]:[m01]', '-0500');\n\n     $p := $toMillis($now())\n          ~> $fromMillis(' [P]') ~> $uppercase();\n\n     $day := $trim($substringBefore($in,','));\n     $ptDay := $.dateTranslation.pt[$lowercase(key)=$lowercase($day)].value;\n    \n     $month := $trim($substringBefore($substringAfter($in, ', '),' '));\n     $ptMonth := $.dateTranslation.pt[$lowercase(key)=$lowercase($month)].value;\n\n     $return := $replace($in, $day, $ptDay) ~> $replace($month, $ptMonth);\n     $return & $p;\n\n    ),\n    \"reservation\" : $.NotificationData.dynamicData.reservation,\n    \"reservationDetails\":{\n\t\"issueDate\": $.NotificationData.dynamicData.reservationDetails.issueDate,\n\t\"ticketStatus\":$.NotificationData.dynamicData.reservationDetails.ticketStatus,\n\t\"ticketType\":$.NotificationData.dynamicData.reservationDetails.ticketType,\n\t\"economyBasicFare\":$.isBasicEconomyPNR\n},\n    \"translations\" : {\n        \"enUrl\" : $.LangURLs[Lang=\"EN\"].LangURL,\n        \"esUrl\" : $.LangURLs[Lang=\"ES\"].LangURL,\n        \"ptUrl\" : $.LangURLs[Lang=\"PT\"].LangURL\n    },\n    \n    \"passengers\" : $.NotificationData.dynamicData.passengers,\n    \"flights\" : [ $map($.NotificationData.dynamicData.flights, function($v, $i, $a){\n                {\n                    \"operatingAirlineCode\" : $v.operatingAirlineCode,\n                    \n                    \"flightNumber\": $v.flightNumber,\n                    \"isFinalDestination\":$v.isFinalDestination=\"true\",\n\t\t\t\t\t\"fareFamily\":$v.fareFamily,\n\t\t\t\t\t\"bookingClass\" : $v.nvPair[$lowercase(name)=$lowercase('bookingClass')].value,\n                    \"status\": $v.status,\n                    \"departure\" : {\n                        \"enDate\" : (\n                                $dt := $toMillis($v.departure.datetimeStd) ~> $fromMillis('[FNn,*-3], [D1] [MNn,*-3]')\n                                \n                            ),\n                        \"esDate\" : (\n                                $dt := $toMillis($v.departure.datetimeStd) ~> $fromMillis('[FNn,*-3], [D1] [MNn,*-3]');\n                                $date := $substringBefore($dt, ',');\n                                $month:=$toMillis($v.departure.datetimeStd) ~> $fromMillis('[MNn]');\n                                $esDate := $.dateTranslation.es[$lowercase(key)=$lowercase($date)].value;\n                                $esMonth:=$.dateTranslation.es[$lowercase(key)=$lowercase($month)].value;\n                                \n                                $replace($dt, $date, $esDate) ~> $replace($month,$esMonth);\n                                \n                            ),\n                        \"ptDate\" : (\n                                $dt := $toMillis($v.departure.datetimeStd) ~> $fromMillis('[FNn,*-3], [D1] [MNn,*-3]');\n                                $date := $substringBefore($dt, ',');\n                                $month := $toMillis($v.departure.datetimeStd) ~> $fromMillis('[MNn,*-3]');\n                                $ptDate := $.dateTranslation.pt[$lowercase(key)=$lowercase($date)].value;\n                                $ptMonth := $.dateTranslation.pt[$lowercase(key)=$lowercase($month)].value;\n                                $replace($dt, $date, $ptDate) ~> $replace($month,$ptMonth);\n                            ),\n                        \"dateFormat2\" : {\n                            \"en\" : (\n                                $dt := $toMillis($v.departure.datetimeStd) ~> $fromMillis('[MNn,*-3] [D1]');\n                                 $dt ? $dt : ' '\n\n                            ),\n                            \"es\" : (\n                                $dt := $toMillis($v.departure.datetimeStd) ~> $fromMillis('[MNn,*-3] [D1], [Y0001]');\n \n                                $date := $substringBefore($substringAfter($dt, ' '), ',');\n                                $month := $substringBefore($dt, ' ');\n                                $year := $substringAfter($dt, ',') ~> $trim();\n \n                                $esMonth := $.dateTranslation.es[$lowercase(key)=$lowercase($month)].value;\n \n                                $esMonth & ' ' & $date \n                            ),\n                            \"pt\" : (\n                                $dt := $toMillis($v.departure.datetimeStd) ~> $fromMillis('[MNn,*-3] [D1], [Y0001]');\n \n                                $date := $substringBefore($substringAfter($dt, ' '), ',');\n                                $month := $substringBefore($dt, ' ');\n                                $year := $substringAfter($dt, ',') ~> $trim();\n \n                                $ptMonth := $.dateTranslation.pt[$lowercase(key)=$lowercase($month)].value;\n \n                                $ptMonth& ' ' &$date\n                            )\n \n                      \n                            },\n                        \"time\" : $v.departure.time,\n                        \"airportCode\" : $v.departure.airportCode,\n                        \"city\" : $v.departure.city,\n                        \"datetimeStd\" : $v.departure.datetimeStd,\n\t\t\t\t\t\t\"countryCode\": $lowercase($v.departure.nvPair[$lowercase(name)=$lowercase('countryCode')].value)\n                    },\n                    \"arrival\" : {\n                        \"enDate\" : (\n                                $dt := $toMillis($v.arrival.datetimeStd) ~> $fromMillis('[FNn,*-3], [D1] [MNn,*-3]')\n                                \n                            ),\n                        \"esDate\" : (\n                                $dt := $toMillis($v.arrival.datetimeStd) ~> $fromMillis('[FNn,*-3], [D1] [MNn,*-3]');\n                                $date := $substringBefore($dt, ',');\n                                $month:=$toMillis($v.arrival.datetimeStd) ~> $fromMillis('[MNn]');\n                                $esDate := $.dateTranslation.es[$lowercase(key)=$lowercase($date)].value;\n                                $esMonth:=$.dateTranslation.es[$lowercase(key)=$lowercase($month)].value;\n                                \n                                $replace($dt, $date, $esDate) ~> $replace($month,$esMonth);\n                                \n                            ),\n                        \"ptDate\" : (\n                                $dt := $toMillis($v.arrival.datetimeStd) ~> $fromMillis('[FNn,*-3], [D1] [MNn,*-3]');\n                                $date := $substringBefore($dt, ',');\n                                $month := $toMillis($v.arrival.datetimeStd) ~> $fromMillis('[MNn]');\n                                $ptDate := $.dateTranslation.pt[$lowercase(key)=$lowercase($date)].value;\n                                $ptMonth := $.dateTranslation.pt[$lowercase(key)=$lowercase($month)].value;\n                                $replace($dt, $date, $ptDate) ~> $replace($month,$ptMonth);\n                            ),\n                        \"dateFormat2\" : {\n                            \"en\" : (\n                                $dt := $toMillis($v.arrival.datetimeStd) ~> $fromMillis('[MNn,*-3] [D1]');\n                                 $dt ? $dt : ' '\n\n                            ),\n                            \"es\" : (\n                                $dt := $toMillis($v.arrival.datetimeStd) ~> $fromMillis('[MNn,*-3] [D1], [Y0001]');\n \n                                $date := $substringBefore($substringAfter($dt, ' '), ',');\n                                $month := $substringBefore($dt, ' ');\n                                $year := $substringAfter($dt, ',') ~> $trim();\n \n                                $esMonth := $.dateTranslation.es[$lowercase(key)=$lowercase($month)].value;\n \n                                $esMonth & ' ' & $date \n                            ),\n                            \"pt\" : (\n                                $dt := $toMillis($v.arrival.datetimeStd) ~> $fromMillis('[MNn,*-3] [D1], [Y0001]');\n \n                                $date := $substringBefore($substringAfter($dt, ' '), ',');\n                                $month := $substringBefore($dt, ' ');\n                                $year := $substringAfter($dt, ',') ~> $trim();\n \n                                $ptMonth := $.dateTranslation.pt[$lowercase(key)=$lowercase($month)].value;\n \n                                $ptMonth& ' ' &$date\n                            )\n \n                        },\n                        \"time\" : $v.arrival.time,\n                        \"airportCode\" : $v.arrival.airportCode,\n                        \"city\" : $v.arrival.city,\n                        \"datetimeStd\" : $v.arrival.datetimeStd,\n\t\t\t\t\t\t\"countryCode\": $lowercase($v.arrival.nvPair[$lowercase(name)=$lowercase('countryCode')].value)\n                    },\n                    \"flightDuration\" : $v.flightDuration,\n\t\t\t\t\t\"layover\":$v.layover,\n                    \"key\" : $v.key\n                    \n                }\n\n            })],\n            \"notificationData\" : $.NotificationData.message\n       \n          \n}";
        try {
            jsonObj = mapper.readTree(json);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            System.out.println("Using json:\n" + mapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObj));
            System.out.println("expression=" + expression);
            ByteArrayInputStream targetStream = new ByteArrayInputStream(expression.getBytes(StandardCharsets.UTF_8));
            CharStream input = CharStreams.fromStream(targetStream, StandardCharsets.UTF_8);
            MappingExpressionLexer lexer = new MappingExpressionLexer(input);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            MappingExpressionParser parser = new MappingExpressionParser(tokens);
            MappingExpressionParser.Expr_to_eofContext tree = null;
            MappingExpressionParser.ExprContext newTree = null;
            BufferingErrorListener errorListener = new BufferingErrorListener();
            try {
                parser.removeErrorListeners();
                lexer.removeErrorListeners();
                parser.addErrorListener(errorListener);
                lexer.addErrorListener(errorListener);
                tree = parser.expr_to_eof();
                if (errorListener.heardErrors()) {
                    ParseTree error;
                    if (tree != null && tree.getChildCount() > 0 && (error = tree.getChild(0)) instanceof ErrorNodeImpl && ((ErrorNodeImpl)error).getSymbol().getType() == 25) {
                        throw new EvaluateRuntimeException("The symbol \"~>\" cannot be used as a unary operator");
                    }
                    throw new ParseException(errorListener.getErrorsAsString());
                }
                newTree = tree.expr();
                List<String> ruleNamesList = Arrays.asList(parser.getRuleNames());
                String prettyTree = TreeUtils.toPrettyTree(newTree, ruleNamesList);
                System.out.println(prettyTree);
            }
            catch (RecognitionException e) {
                throw new ParseException(e.getMessage());
            }
            expr = Expressions.parse(expression);
        }
        catch (ParseException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (EvaluateRuntimeException ere) {
            System.out.println(ere.getLocalizedMessage());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            System.out.println("evaluate returns:");
            JsonNode result = expr.evaluate(jsonObj);
            if (result == null) {
                System.out.println("** no match **");
            } else {
                System.out.println("" + mapper.writerWithDefaultPrettyPrinter().writeValueAsString(result));
            }
        }
        catch (EvaluateException | JsonProcessingException e) {
            System.err.println(e.getLocalizedMessage());
        }
    }
}

