/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;

public class AbsFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = -7061181042065058523L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$abs");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$abs");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$abs");

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        Object var3_3 = null;
        JsonNode argNumber = null;
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = AbsFunction.getArgumentCount(ctx);
        if (useContext) {
            argNumber = FunctionUtils.getContextVariable(expressionVisitor);
            if (argNumber != null && !argNumber.isNull()) {
                ++argCount;
                if (!argNumber.isNumber()) {
                    throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                }
            } else {
                useContext = false;
            }
        }
        if (argCount == 1) {
            void var3_10;
            if (!useContext) {
                argNumber = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if (argNumber == null) {
                return null;
            }
            if (!argNumber.isNumber()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            if (argNumber.isInt()) {
                int number = argNumber.intValue();
                IntNode intNode = new IntNode(Math.abs(number));
                return var3_10;
            } else if (argNumber.isLong()) {
                long number = argNumber.longValue();
                if (number == Long.MIN_VALUE) {
                    LongNode longNode = new LongNode(Long.MAX_VALUE);
                    return var3_10;
                } else {
                    LongNode longNode = new LongNode(Math.abs(number));
                }
                return var3_10;
            } else if (argNumber.isFloat()) {
                float number = argNumber.floatValue();
                FloatNode floatNode = new FloatNode(Math.abs(number));
                return var3_10;
            } else {
                if (!argNumber.isDouble()) return var3_10;
                double number = argNumber.doubleValue();
                DoubleNode doubleNode = new DoubleNode(Math.abs(number));
            }
            return var3_10;
        } else {
            if (!(ctx.getParent() instanceof MappingExpressionParser.Fct_chainContext)) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
            if (argNumber != null) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            return null;
        }
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<n-:n>";
    }
}

