/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.RegularExpression;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MatchFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = 1917070534153592299L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$match");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$match");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$match");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$match");
    public static String ERR_ARG4BADTYPE = String.format("Argument 4 of function %s does not match function signature", "$match");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ExpressionsVisitor.SelectorArrayNode result = null;
        JsonNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = MatchFunction.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            if (argString != null && !argString.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 2 && argCount != 3) throw new EvaluateRuntimeException(argCount <= 1 ? ERR_ARG1BADTYPE : ERR_ARG4BADTYPE);
        if (!useContext) {
            argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        JsonNode argPattern = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
        int limit = -1;
        if (argString == null) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        if (!argString.isTextual()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        if (argString.asText().isEmpty()) {
            throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        }
        if (argPattern != null && (argPattern.isTextual() || argPattern instanceof POJONode) && !argPattern.asText().isEmpty()) {
            JsonNode argLimit;
            RegularExpression regex = null;
            if (argPattern instanceof POJONode) {
                regex = (RegularExpression)((POJONode)argPattern).getPojo();
            }
            Pattern regexPattern = regex != null ? regex.getPattern() : Pattern.compile(Pattern.quote(argPattern.textValue()));
            String str = argString.textValue();
            if (argCount == 3 && (argLimit = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 1 : 2)) != null) {
                if (!argLimit.isNumber()) throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
                if (argLimit.asInt() < 0) throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
                limit = argLimit.asInt();
            }
            Matcher matcher = regexPattern.matcher(str);
            result = new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance);
            if (limit == -1) {
                while (matcher.find()) {
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.put("match", str.substring(matcher.start(), matcher.end()));
                    obj.put("index", new Long(matcher.start()));
                    ArrayNode groups = JsonNodeFactory.instance.arrayNode();
                    obj.set("groups", groups);
                    int groupCount = matcher.groupCount();
                    for (int i = 1; i <= groupCount; ++i) {
                        groups.add(matcher.group(i));
                    }
                    result.add(obj);
                }
                return result;
            }
            if (limit <= 0) return null;
            int count = 0;
            while (matcher.find()) {
                if (count >= limit) return result;
                ++count;
                ObjectNode obj = JsonNodeFactory.instance.objectNode();
                obj.put("match", str.substring(matcher.start(), matcher.end()));
                obj.put("index", new Long(matcher.start()));
                ArrayNode groups = JsonNodeFactory.instance.arrayNode();
                obj.set("groups", groups);
                int groupCount = matcher.groupCount();
                for (int i = 1; i <= groupCount; ++i) {
                    groups.add(matcher.group(i));
                }
                result.add(obj);
            }
            return result;
        }
        MappingExpressionParser.ExprContext exprCtx = ctx.exprValues().exprList().expr(useContext ? 0 : 1);
        if (!(exprCtx instanceof MappingExpressionParser.Function_callContext)) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        MappingExpressionParser.Function_callContext fctCallCtx = (MappingExpressionParser.Function_callContext)exprCtx;
        String fctName = fctCallCtx.VAR_ID().getText();
        DeclaredFunction declFct = expressionVisitor.getDeclaredFunction(fctName);
        if (declFct != null) return (ExpressionsVisitor.SelectorArrayNode)declFct.invoke(expressionVisitor, fctCallCtx);
        Function function = expressionVisitor.getJsonataFunction(fctName);
        if (function == null) throw new EvaluateRuntimeException("Unknown function: " + fctName);
        return (ExpressionsVisitor.SelectorArrayNode)function.invoke(expressionVisitor, fctCallCtx);
    }

    @Override
    public int getMaxArgs() {
        return 3;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<s-f<s:o>n?:a<o>>";
    }
}

