/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;

public class AbsFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = -7061181042065058523L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$abs");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$abs");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$abs");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        IntNode result = null;
        JsonNode argNumber = null;
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = AbsFunction.getArgumentCount(ctx);
        if (useContext) {
            argNumber = FunctionUtils.getContextVariable(expressionVisitor);
            if (argNumber != null && !argNumber.isNull()) {
                ++argCount;
                if (!argNumber.isNumber()) {
                    throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                }
            } else {
                useContext = false;
            }
        }
        if (argCount == 1) {
            if (!useContext) {
                argNumber = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if (argNumber == null) {
                return null;
            }
            if (!argNumber.isNumber()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            if (argNumber.isInt()) {
                int number = argNumber.intValue();
                return new IntNode(Math.abs(number));
            }
            if (argNumber.isLong()) {
                long number = argNumber.longValue();
                if (number != Long.MIN_VALUE) return new LongNode(Math.abs(number));
                return new LongNode(Long.MAX_VALUE);
            }
            if (argNumber.isFloat()) {
                float number = argNumber.floatValue();
                return new FloatNode(Math.abs(number));
            }
            if (!argNumber.isDouble()) return result;
            double number = argNumber.doubleValue();
            return new DoubleNode(Math.abs(number));
        }
        if (!(ctx.getParent() instanceof MappingExpressionParser.Fct_chainContext)) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        if (argNumber != null) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        return null;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<n-:n>";
    }
}

