/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import org.antlr.v4.runtime.tree.TerminalNode;

public class MapFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$map");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$map");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$map");
    public static String ERR_ARG1_MUST_BE_ARRAY_OF_OBJECTS = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$map");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ExpressionsVisitor.SelectorArrayNode resultArray = new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance);
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        JsonNode arrNode = null;
        int argCount = MapFunction.getArgumentCount(ctx);
        if (useContext) {
            arrNode = FunctionUtils.getContextVariable(expressionVisitor);
            if (arrNode != null && !arrNode.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 2) throw new EvaluateRuntimeException(argCount <= 1 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        MappingExpressionParser.ExprListContext exprList = ctx.exprValues().exprList();
        if (!useContext) {
            arrNode = expressionVisitor.visit(exprList.expr(0));
        }
        if (arrNode == null) {
            return null;
        }
        MappingExpressionParser.ExprContext varid = exprList.expr(useContext ? 0 : 1);
        if (varid instanceof MappingExpressionParser.Var_recallContext) {
            TerminalNode VAR_ID = ((MappingExpressionParser.Var_recallContext)varid).VAR_ID();
            String varID = varid.getText();
            DeclaredFunction fct = expressionVisitor.getDeclaredFunction(varID);
            if (fct != null) {
                int fctVarCount;
                int varCount = fct.getVariableCount();
                if (varCount > (fctVarCount = fct.getMaxArgs())) {
                    varCount = fctVarCount;
                }
                if (arrNode.isArray()) {
                    ArrayNode mapArray = (ArrayNode)arrNode;
                    for (int i = 0; i < mapArray.size(); ++i) {
                        JsonNode element = mapArray.get(i);
                        MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                        switch (varCount) {
                            case 1: {
                                evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                                break;
                            }
                            case 2: {
                                evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                                evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                                break;
                            }
                            case 3: {
                                evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                                evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                                evc = FunctionUtils.addArrayExprVarContext(ctx, evc, mapArray);
                            }
                        }
                        resultArray.add(fct.invoke(expressionVisitor, evc));
                    }
                    return resultArray;
                } else {
                    JsonNode element = arrNode;
                    int i = 0;
                    MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                    switch (varCount) {
                        case 1: {
                            evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                            break;
                        }
                        case 2: {
                            evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                            evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                            break;
                        }
                        case 3: {
                            evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                            evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                            evc = FunctionUtils.addObjectExprVarContext(ctx, evc, (ObjectNode)arrNode);
                        }
                    }
                    resultArray.add(fct.invoke(expressionVisitor, evc));
                }
                return resultArray;
            } else {
                FunctionBase function = expressionVisitor.getJsonataFunction(varid.getText());
                if (function == null) throw new EvaluateRuntimeException("Expected function variable reference " + varID + " to resolve to a declared nor Jsonata function.");
                int optionalArgs = FunctionUtils.getOptionalArgCount(function.getSignature());
                int maxArgs = function.getMaxArgs() - optionalArgs;
                if (arrNode.isArray()) {
                    ArrayNode mapArray = (ArrayNode)arrNode;
                    for (int i = 0; i < mapArray.size(); ++i) {
                        MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                        JsonNode element = mapArray.get(i);
                        if (maxArgs <= 1) {
                            resultArray.add(FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, element));
                            continue;
                        }
                        if (maxArgs == 2) {
                            resultArray.add(FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, element, JsonNodeFactory.instance.numberNode(i)));
                            continue;
                        }
                        resultArray.add(FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, element, JsonNodeFactory.instance.numberNode(i), mapArray));
                    }
                    return resultArray;
                } else {
                    JsonNode element = arrNode;
                    int i = 0;
                    MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                    if (maxArgs <= 1) {
                        resultArray.add(FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, element));
                        return resultArray;
                    } else if (maxArgs == 2) {
                        resultArray.add(FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, element, JsonNodeFactory.instance.numberNode(i)));
                        return resultArray;
                    } else {
                        resultArray.add(FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, element, JsonNodeFactory.instance.numberNode(i), (ObjectNode)element));
                    }
                }
            }
            return resultArray;
        } else {
            int fctVarCount;
            MappingExpressionParser.ExprListContext fctBody;
            if (!(varid instanceof MappingExpressionParser.Function_declContext)) return resultArray;
            MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)exprList.expr(useContext ? 0 : 1);
            MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
            DeclaredFunction fct = new DeclaredFunction(varList, fctBody = fctDeclCtx.exprList());
            int varCount = fct.getVariableCount();
            if (varCount > (fctVarCount = fct.getMaxArgs())) {
                varCount = fctVarCount;
            }
            if (arrNode.isArray()) {
                ArrayNode mapArray = (ArrayNode)arrNode;
                for (int i = 0; i < mapArray.size(); ++i) {
                    JsonNode element = mapArray.get(i);
                    MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                    switch (varCount) {
                        case 1: {
                            evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                            break;
                        }
                        case 2: {
                            evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                            evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                            break;
                        }
                        case 3: {
                            evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                            evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                            evc = FunctionUtils.addArrayExprVarContext(ctx, evc, mapArray);
                        }
                    }
                    JsonNode fctResult = fct.invoke(expressionVisitor, evc);
                    if (fctResult == null) continue;
                    resultArray.add(fctResult);
                }
                return resultArray;
            } else {
                JsonNode element = arrNode;
                int i = 0;
                MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                switch (varCount) {
                    case 1: {
                        evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                        break;
                    }
                    case 2: {
                        evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                        evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                        break;
                    }
                    case 3: {
                        evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                        evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                        evc = FunctionUtils.addObjectExprVarContext(ctx, evc, (ObjectNode)element);
                    }
                }
                JsonNode fctResult = fct.invoke(expressionVisitor, evc);
                if (fctResult == null) return resultArray;
                resultArray.add(fctResult);
            }
        }
        return resultArray;
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 2;
    }

    @Override
    public String getSignature() {
        return "<af>";
    }

    public void addObject(ExpressionsVisitor.SelectorArrayNode result, ObjectNode obj) {
        Iterator<String> it = obj.fieldNames();
        while (it.hasNext()) {
            String key = it.next();
            ObjectNode cell = JsonNodeFactory.instance.objectNode();
            cell.set(key, obj.get(key));
            result.add(cell);
        }
    }
}

