/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.utils;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;

public class FunctionUtils
implements Serializable {
    private static final long serialVersionUID = -3388958465533493227L;

    public static MappingExpressionParser.ExprValuesContext addArrayExprVarContext(MappingExpressionParser.ExprContext ctx, MappingExpressionParser.ExprValuesContext evc, ArrayNode arrayNode) {
        if (evc == null) {
            evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
        }
        MappingExpressionParser.ExprListContext elc = (MappingExpressionParser.ExprListContext)evc.getChild(evc.getChildCount() - 2);
        CommonToken token = (CommonToken)CommonTokenFactory.DEFAULT.create(3, ",");
        TerminalNodeImpl comma = new TerminalNodeImpl((Token)token);
        elc.addChild((TerminalNode)comma);
        MappingExpressionParser.Array_constructorContext arrayCtx = FunctionUtils.getArrayConstructorContext(ctx, arrayNode);
        elc.addAnyChild((ParseTree)arrayCtx);
        return evc;
    }

    public static MappingExpressionParser.ExprValuesContext addIndexExprVarContext(MappingExpressionParser.ExprContext ctx, MappingExpressionParser.ExprValuesContext evc, Integer index) {
        if (evc == null) {
            evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
        }
        MappingExpressionParser.ExprListContext elc = (MappingExpressionParser.ExprListContext)evc.getChild(evc.getChildCount() - 2);
        CommonToken token = (CommonToken)CommonTokenFactory.DEFAULT.create(3, ",");
        TerminalNodeImpl comma = new TerminalNodeImpl((Token)token);
        elc.addChild((TerminalNode)comma);
        token = (CommonToken)CommonTokenFactory.DEFAULT.create(24, index.toString());
        TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
        MappingExpressionParser.NumberContext nc = new MappingExpressionParser.NumberContext(ctx);
        nc.addAnyChild((ParseTree)tn);
        elc.addAnyChild((ParseTree)nc);
        return evc;
    }

    public static MappingExpressionParser.ExprValuesContext addObjectExprVarContext(MappingExpressionParser.ExprContext ctx, MappingExpressionParser.ExprValuesContext evc, ObjectNode object) {
        if (evc == null) {
            evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
        }
        MappingExpressionParser.ExprListContext elc = (MappingExpressionParser.ExprListContext)evc.getChild(evc.getChildCount() - 2);
        CommonToken token = (CommonToken)CommonTokenFactory.DEFAULT.create(3, ",");
        TerminalNodeImpl comma = new TerminalNodeImpl((Token)token);
        elc.addChild((TerminalNode)comma);
        elc.addAnyChild((ParseTree)FunctionUtils.getObjectConstructorContext(ctx, object));
        return evc;
    }

    public static MappingExpressionParser.ExprValuesContext addStringExprVarContext(MappingExpressionParser.ExprContext ctx, MappingExpressionParser.ExprValuesContext evc, String string) {
        if (evc == null) {
            evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
        }
        MappingExpressionParser.ExprListContext elc = (MappingExpressionParser.ExprListContext)evc.getChild(evc.getChildCount() - 2);
        CommonToken token = (CommonToken)CommonTokenFactory.DEFAULT.create(3, ",");
        TerminalNodeImpl comma = new TerminalNodeImpl((Token)token);
        elc.addChild((TerminalNode)comma);
        token = (CommonToken)CommonTokenFactory.DEFAULT.create(15, string);
        TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
        MappingExpressionParser.StringContext sc = new MappingExpressionParser.StringContext(ctx);
        sc.addAnyChild((ParseTree)tn);
        elc.addAnyChild((ParseTree)sc);
        return evc;
    }

    public static MappingExpressionParser.ExprValuesContext fillExprVarContext(int fctVarCount, MappingExpressionParser.ExprContext ctx, JsonNode ... elements) {
        MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
        MappingExpressionParser.ExprListContext elc = new MappingExpressionParser.ExprListContext(ctx.getParent(), ctx.invokingState);
        evc.addAnyChild((ParseTree)new TerminalNodeImpl(CommonTokenFactory.DEFAULT.create(2, "(")));
        CommonToken token = null;
        block8: for (int i = 0; i < elements.length && i <= fctVarCount; ++i) {
            TerminalNodeImpl tn;
            JsonNode element = elements[i];
            if (i > 1) {
                token = (CommonToken)CommonTokenFactory.DEFAULT.create(3, ",");
                tn = new TerminalNodeImpl((Token)token);
                elc.addAnyChild((ParseTree)tn);
            }
            switch (element.getNodeType()) {
                case BINARY: 
                case POJO: {
                    continue block8;
                }
                case BOOLEAN: {
                    token = element.asBoolean() ? (CommonToken)CommonTokenFactory.DEFAULT.create(13, element.asText()) : (CommonToken)CommonTokenFactory.DEFAULT.create(14, element.asText());
                    tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.BooleanContext bc = new MappingExpressionParser.BooleanContext(ctx);
                    bc.op = token;
                    bc.addAnyChild((ParseTree)tn);
                    elc.addAnyChild((ParseTree)bc);
                    continue block8;
                }
                case MISSING: 
                case NULL: {
                    token = (CommonToken)CommonTokenFactory.DEFAULT.create(16, null);
                    tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.ExprContext nc = new MappingExpressionParser.NullContext(ctx);
                    nc.addAnyChild((ParseTree)tn);
                    elc.addAnyChild((ParseTree)nc);
                    continue block8;
                }
                case NUMBER: {
                    token = (CommonToken)CommonTokenFactory.DEFAULT.create(24, element.asText());
                    tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.ExprContext nc = new MappingExpressionParser.NumberContext(ctx);
                    nc.addAnyChild((ParseTree)tn);
                    elc.addAnyChild((ParseTree)nc);
                    continue block8;
                }
                case OBJECT: {
                    elc.addAnyChild((ParseTree)FunctionUtils.getObjectConstructorContext(ctx, (ObjectNode)element));
                    continue block8;
                }
                case ARRAY: {
                    elc.addAnyChild((ParseTree)FunctionUtils.getArrayConstructorContext(ctx, (ArrayNode)element));
                    continue block8;
                }
                default: {
                    token = (CommonToken)CommonTokenFactory.DEFAULT.create(15, element.toString());
                    tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.StringContext sc = new MappingExpressionParser.StringContext(ctx);
                    sc.addAnyChild((ParseTree)tn);
                    elc.addAnyChild((ParseTree)sc);
                    continue block8;
                }
            }
        }
        evc.addAnyChild((ParseTree)elc);
        evc.addAnyChild((ParseTree)new TerminalNodeImpl(CommonTokenFactory.DEFAULT.create(4, ")")));
        return evc;
    }

    public static MappingExpressionParser.Array_constructorContext getArrayConstructorContext(MappingExpressionParser.ExprContext ctx, ArrayNode array) {
        MappingExpressionParser.Array_constructorContext arrayObj = new MappingExpressionParser.Array_constructorContext(ctx);
        MappingExpressionParser.ExprOrSeqListContext eosListCtx = new MappingExpressionParser.ExprOrSeqListContext(ctx.getParent(), ctx.invokingState);
        MappingExpressionParser.ExprOrSeqContext eosCtx = new MappingExpressionParser.ExprOrSeqContext(eosListCtx.getParent(), eosListCtx.invokingState);
        eosListCtx.addAnyChild((ParseTree)eosCtx);
        List children = arrayObj.children;
        children.add(new TerminalNodeImpl(CommonTokenFactory.DEFAULT.create(17, "[")));
        CommonToken token = null;
        block8: for (int i = 0; i < array.size(); ++i) {
            if (i > 0) {
                token = (CommonToken)CommonTokenFactory.DEFAULT.create(3, ",");
                TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                eosCtx.addAnyChild((ParseTree)tn);
            }
            JsonNode element = array.get(i);
            switch (element.getNodeType()) {
                case BINARY: 
                case POJO: {
                    continue block8;
                }
                case ARRAY: {
                    eosCtx.addAnyChild((ParseTree)FunctionUtils.getArrayConstructorContext(ctx, (ArrayNode)element));
                    continue block8;
                }
                case BOOLEAN: {
                    token = element.asBoolean() ? (CommonToken)CommonTokenFactory.DEFAULT.create(13, element.asText()) : (CommonToken)CommonTokenFactory.DEFAULT.create(14, element.asText());
                    TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.BooleanContext bc = new MappingExpressionParser.BooleanContext(ctx);
                    bc.op = token;
                    bc.addAnyChild((ParseTree)tn);
                    eosCtx.addAnyChild((ParseTree)bc);
                    continue block8;
                }
                case MISSING: 
                case NULL: {
                    token = (CommonToken)CommonTokenFactory.DEFAULT.create(16, null);
                    TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.ExprContext nc = new MappingExpressionParser.NullContext(ctx);
                    nc.addAnyChild((ParseTree)tn);
                    eosCtx.addAnyChild((ParseTree)nc);
                    continue block8;
                }
                case NUMBER: {
                    token = (CommonToken)CommonTokenFactory.DEFAULT.create(24, element.asText());
                    TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.ExprContext nc = new MappingExpressionParser.NumberContext(ctx);
                    nc.addAnyChild((ParseTree)tn);
                    eosCtx.addAnyChild((ParseTree)nc);
                    continue block8;
                }
                case OBJECT: {
                    eosCtx.addAnyChild((ParseTree)FunctionUtils.getObjectConstructorContext(ctx, (ObjectNode)element));
                    continue block8;
                }
                default: {
                    token = (CommonToken)CommonTokenFactory.DEFAULT.create(15, element.toString());
                    TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.StringContext sc = new MappingExpressionParser.StringContext(ctx);
                    sc.addAnyChild((ParseTree)tn);
                    eosCtx.addAnyChild((ParseTree)sc);
                    continue block8;
                }
            }
        }
        if (eosListCtx.exprOrSeq().size() > 0) {
            children.add(eosListCtx);
        }
        children.add(new TerminalNodeImpl(CommonTokenFactory.DEFAULT.create(18, "]")));
        return arrayObj;
    }

    public static JsonNode getContextVariable(ExpressionsVisitor exprVisitor) {
        JsonNode result = null;
        if (!exprVisitor.getContextStack().isEmpty()) {
            result = exprVisitor.getContextStack().pop();
            exprVisitor.getContextStack().push(result);
        }
        return result;
    }

    public static JsonNode getContextVariableOrNullNode(ExpressionsVisitor exprVisitor) {
        JsonNode result = FunctionUtils.getContextVariable(exprVisitor);
        if (result == null) {
            result = JsonNodeFactory.instance.nullNode();
        }
        return result;
    }

    public static MappingExpressionParser.Object_constructorContext getObjectConstructorContext(MappingExpressionParser.ExprContext ctx, ObjectNode object) {
        MappingExpressionParser.Object_constructorContext obj = new MappingExpressionParser.Object_constructorContext(ctx);
        List children = obj.children;
        children.add(new TerminalNodeImpl(CommonTokenFactory.DEFAULT.create(19, "{")));
        MappingExpressionParser.FieldListContext flc = new MappingExpressionParser.FieldListContext(obj.getParent(), obj.invokingState);
        int count = 0;
        CommonToken token = null;
        TerminalNodeImpl tn = null;
        Iterator it = object.fields();
        block8: while (it.hasNext()) {
            Map.Entry field = (Map.Entry)it.next();
            if (++count > 1) {
                token = (CommonToken)CommonTokenFactory.DEFAULT.create(3, ",");
                tn = new TerminalNodeImpl((Token)token);
                flc.addAnyChild((ParseTree)tn);
            }
            token = (CommonToken)CommonTokenFactory.DEFAULT.create(15, (String)field.getKey());
            tn = new TerminalNodeImpl((Token)token);
            flc.addAnyChild((ParseTree)tn);
            token = (CommonToken)CommonTokenFactory.DEFAULT.create(6, ":");
            tn = new TerminalNodeImpl((Token)token);
            flc.addAnyChild((ParseTree)tn);
            JsonNode fieldObj = (JsonNode)field.getValue();
            switch (fieldObj.getNodeType()) {
                case BINARY: 
                case POJO: {
                    continue block8;
                }
                case ARRAY: {
                    flc.addAnyChild((ParseTree)FunctionUtils.getArrayConstructorContext(ctx, (ArrayNode)fieldObj));
                    continue block8;
                }
                case BOOLEAN: {
                    token = fieldObj.asBoolean() ? (CommonToken)CommonTokenFactory.DEFAULT.create(13, fieldObj.asText()) : (CommonToken)CommonTokenFactory.DEFAULT.create(14, fieldObj.asText());
                    tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.BooleanContext bc = new MappingExpressionParser.BooleanContext(ctx);
                    bc.op = token;
                    bc.addAnyChild((ParseTree)tn);
                    flc.addAnyChild((ParseTree)bc);
                    continue block8;
                }
                case MISSING: 
                case NULL: {
                    token = (CommonToken)CommonTokenFactory.DEFAULT.create(16, null);
                    tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.ExprContext nc = new MappingExpressionParser.NullContext(ctx);
                    nc.addAnyChild((ParseTree)tn);
                    flc.addAnyChild((ParseTree)nc);
                    continue block8;
                }
                case NUMBER: {
                    token = (CommonToken)CommonTokenFactory.DEFAULT.create(24, fieldObj.asText());
                    tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.ExprContext nc = new MappingExpressionParser.NumberContext(ctx);
                    nc.addAnyChild((ParseTree)tn);
                    flc.addAnyChild((ParseTree)nc);
                    continue block8;
                }
                case OBJECT: {
                    flc.addAnyChild((ParseTree)FunctionUtils.getObjectConstructorContext(ctx, (ObjectNode)fieldObj));
                    continue block8;
                }
            }
            token = (CommonToken)CommonTokenFactory.DEFAULT.create(15, fieldObj.toString());
            tn = new TerminalNodeImpl((Token)token);
            MappingExpressionParser.StringContext sc = new MappingExpressionParser.StringContext(ctx);
            sc.addAnyChild((ParseTree)tn);
            flc.addAnyChild((ParseTree)sc);
        }
        if (flc.children != null && flc.children.size() > 0) {
            children.add(flc);
        }
        children.add(new TerminalNodeImpl(CommonTokenFactory.DEFAULT.create(20, "}")));
        return obj;
    }

    public static JsonNode getValuesListExpression(ExpressionsVisitor exprVisitor, MappingExpressionParser.Function_callContext ctx, int index) {
        DoubleNode result;
        block4: {
            result = null;
            try {
                if (ctx != null && ctx.exprValues() != null) {
                    MappingExpressionParser.ExprContext exprCtx = ctx.exprValues().exprList().expr(index);
                    result = exprVisitor.visit((ParseTree)exprCtx);
                }
            }
            catch (IndexOutOfBoundsException exprCtx) {
            }
            catch (ArithmeticException e) {
                if (!e.getMessage().equals("/ by zero") && !e.getMessage().equals("divide by zero")) break block4;
                result = new DoubleNode(Double.POSITIVE_INFINITY);
            }
        }
        return result;
    }

    public static void validateArguments(String possibleException, ExpressionsVisitor exprVisitor, MappingExpressionParser.Function_callContext ctx, int index, String signature) {
        try {
            MappingExpressionParser.ExprContext exprCtx;
            if (ctx != null && ctx.exprValues() != null && FunctionUtils.checkArgument(exprVisitor, exprCtx = ctx.exprValues().exprList().expr(index), signature)) {
                return;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        throw new EvaluateRuntimeException(possibleException);
    }

    public static boolean checkArgument(ExpressionsVisitor exprVisitor, MappingExpressionParser.ExprContext exprCtx, String signature) {
        boolean result = false;
        switch (signature) {
            case "<a<n>-:n>": 
            case "<a<n>:n>": {
                if (exprCtx instanceof MappingExpressionParser.Array_constructorContext) {
                    ParseTree seqCtx;
                    ParseTree test;
                    ParseTree ruleCtx = exprCtx.getChild(MappingExpressionParser.ExprOrSeqListContext.class, 0);
                    if (ruleCtx == null) {
                        return true;
                    }
                    if ((ruleCtx = ((MappingExpressionParser.ExprOrSeqListContext)ruleCtx).getChild(MappingExpressionParser.ExprOrSeqContext.class, 0)) != null) {
                        test = ((MappingExpressionParser.ExprOrSeqContext)ruleCtx).getChild(MappingExpressionParser.Context_refContext.class, 0);
                        if (test != null) {
                            return true;
                        }
                        test = ((MappingExpressionParser.ExprOrSeqContext)ruleCtx).getChild(MappingExpressionParser.NumberContext.class, 0);
                        if (test != null) {
                            return true;
                        }
                    }
                    if (ruleCtx instanceof MappingExpressionParser.Array_constructorContext && (ruleCtx = ((MappingExpressionParser.Array_constructorContext)ruleCtx).getPayload()) instanceof MappingExpressionParser.Context_refContext) {
                        return true;
                    }
                    if (ruleCtx instanceof MappingExpressionParser.ExprOrSeqContext && (seqCtx = ((MappingExpressionParser.ExprOrSeqContext)ruleCtx).getChild(MappingExpressionParser.SeqContext.class, 0)) != null) {
                        return true;
                    }
                    test = exprVisitor.visit(ruleCtx);
                    if (!test.isNumber()) break;
                    return true;
                }
                if (exprCtx instanceof MappingExpressionParser.NumberContext || exprCtx instanceof MappingExpressionParser.Unary_opContext) {
                    return true;
                }
                if (exprCtx instanceof MappingExpressionParser.PathContext) {
                    return true;
                }
                if (!(exprCtx instanceof MappingExpressionParser.IdContext)) break;
                return true;
            }
        }
        return result;
    }

    public static JsonNode getValuesListExpressionOrNullNode(ExpressionsVisitor exprVisitor, MappingExpressionParser.Function_callContext ctx, int index) {
        JsonNode result = FunctionUtils.getValuesListExpression(exprVisitor, ctx, index);
        if (result == null) {
            result = JsonNodeFactory.instance.nullNode();
        }
        return result;
    }

    public static JsonNode processVariablesCallFunction(ExpressionsVisitor exprVisitor, FunctionBase function, TerminalNode varid, MappingExpressionParser.Function_callContext ctx, JsonNode ... elements) {
        MappingExpressionParser.ExprListContext elc = new MappingExpressionParser.ExprListContext(ctx.getParent(), ctx.invokingState);
        MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx.getParent(), ctx.invokingState);
        evc.addAnyChild((ParseTree)new TerminalNodeImpl(CommonTokenFactory.DEFAULT.create(2, "(")));
        CommonToken token = null;
        block8: for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                token = (CommonToken)CommonTokenFactory.DEFAULT.create(3, ",");
                TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                elc.addAnyChild((ParseTree)tn);
            }
            JsonNode element = elements[i];
            switch (element.getNodeType()) {
                case BINARY: 
                case POJO: {
                    continue block8;
                }
                case BOOLEAN: {
                    token = element.asBoolean() ? (CommonToken)CommonTokenFactory.DEFAULT.create(13, element.asText()) : (CommonToken)CommonTokenFactory.DEFAULT.create(14, element.asText());
                    TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.BooleanContext bc = new MappingExpressionParser.BooleanContext(ctx);
                    bc.op = token;
                    bc.addAnyChild((ParseTree)tn);
                    elc.addAnyChild((ParseTree)bc);
                    continue block8;
                }
                case MISSING: 
                case NULL: {
                    token = (CommonToken)CommonTokenFactory.DEFAULT.create(16, null);
                    TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.ExprContext nc = new MappingExpressionParser.NullContext(ctx);
                    nc.addAnyChild((ParseTree)tn);
                    elc.addAnyChild((ParseTree)nc);
                    continue block8;
                }
                case NUMBER: {
                    token = (CommonToken)CommonTokenFactory.DEFAULT.create(24, element.asText());
                    TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.ExprContext nc = new MappingExpressionParser.NumberContext(ctx);
                    nc.addAnyChild((ParseTree)tn);
                    elc.addAnyChild((ParseTree)nc);
                    continue block8;
                }
                case OBJECT: {
                    elc.addAnyChild((ParseTree)FunctionUtils.getObjectConstructorContext(ctx, (ObjectNode)element));
                    continue block8;
                }
                case ARRAY: {
                    elc.addAnyChild((ParseTree)FunctionUtils.getArrayConstructorContext(ctx, (ArrayNode)element));
                    continue block8;
                }
                default: {
                    token = (CommonToken)CommonTokenFactory.DEFAULT.create(15, element.toString());
                    TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.StringContext sc = new MappingExpressionParser.StringContext(ctx);
                    sc.addAnyChild((ParseTree)tn);
                    elc.addAnyChild((ParseTree)sc);
                    continue block8;
                }
            }
        }
        evc.addAnyChild((ParseTree)elc);
        evc.addAnyChild((ParseTree)new TerminalNodeImpl(CommonTokenFactory.DEFAULT.create(4, ")")));
        ctx.addAnyChild((ParseTree)varid);
        ctx.addAnyChild((ParseTree)evc);
        return function.invoke(exprVisitor, ctx);
    }

    public static JsonNode processFctCallVariables(ExpressionsVisitor exprVisitor, FunctionBase function, TerminalNode varid, MappingExpressionParser.Function_callContext ctx, JsonNode value, String key, ObjectNode object) {
        MappingExpressionParser.StringContext sc;
        TerminalNodeImpl tn;
        MappingExpressionParser.ExprListContext elc = new MappingExpressionParser.ExprListContext(ctx.getParent(), ctx.invokingState);
        MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx.getParent(), ctx.invokingState);
        evc.addAnyChild((ParseTree)new TerminalNodeImpl(CommonTokenFactory.DEFAULT.create(2, "(")));
        CommonToken token = null;
        int fctVarCount = function.getMaxArgs();
        JsonNode element = value;
        switch (element.getNodeType()) {
            case BINARY: 
            case POJO: {
                break;
            }
            case BOOLEAN: {
                token = element.asBoolean() ? (CommonToken)CommonTokenFactory.DEFAULT.create(13, element.asText()) : (CommonToken)CommonTokenFactory.DEFAULT.create(14, element.asText());
                tn = new TerminalNodeImpl((Token)token);
                MappingExpressionParser.BooleanContext bc = new MappingExpressionParser.BooleanContext(ctx);
                bc.op = token;
                bc.addAnyChild((ParseTree)tn);
                elc.addAnyChild((ParseTree)bc);
                break;
            }
            case MISSING: 
            case NULL: {
                token = (CommonToken)CommonTokenFactory.DEFAULT.create(16, null);
                tn = new TerminalNodeImpl((Token)token);
                MappingExpressionParser.ExprContext nc = new MappingExpressionParser.NullContext(ctx);
                nc.addAnyChild((ParseTree)tn);
                elc.addAnyChild((ParseTree)nc);
                break;
            }
            case NUMBER: {
                token = (CommonToken)CommonTokenFactory.DEFAULT.create(24, element.asText());
                tn = new TerminalNodeImpl((Token)token);
                MappingExpressionParser.ExprContext nc = new MappingExpressionParser.NumberContext(ctx);
                nc.addAnyChild((ParseTree)tn);
                elc.addAnyChild((ParseTree)nc);
                break;
            }
            case OBJECT: {
                elc.addAnyChild((ParseTree)FunctionUtils.getObjectConstructorContext(ctx, (ObjectNode)element));
                break;
            }
            case ARRAY: {
                elc.addAnyChild((ParseTree)FunctionUtils.getArrayConstructorContext(ctx, (ArrayNode)element));
                break;
            }
            default: {
                token = (CommonToken)CommonTokenFactory.DEFAULT.create(15, element.toString());
                tn = new TerminalNodeImpl((Token)token);
                sc = new MappingExpressionParser.StringContext(ctx);
                sc.addAnyChild((ParseTree)tn);
                elc.addAnyChild((ParseTree)sc);
                break;
            }
        }
        if (fctVarCount > 1) {
            token = (CommonToken)CommonTokenFactory.DEFAULT.create(3, ",");
            tn = new TerminalNodeImpl((Token)token);
            elc.addAnyChild((ParseTree)tn);
            token = (CommonToken)CommonTokenFactory.DEFAULT.create(15, key);
            tn = new TerminalNodeImpl((Token)token);
            sc = new MappingExpressionParser.StringContext(ctx);
            sc.addAnyChild((ParseTree)tn);
            elc.addAnyChild((ParseTree)sc);
        }
        if (fctVarCount > 2) {
            token = (CommonToken)CommonTokenFactory.DEFAULT.create(3, ",");
            tn = new TerminalNodeImpl((Token)token);
            elc.addAnyChild((ParseTree)tn);
            elc.addAnyChild((ParseTree)FunctionUtils.getObjectConstructorContext(ctx, object));
        }
        evc.addAnyChild((ParseTree)elc);
        evc.addAnyChild((ParseTree)new TerminalNodeImpl(CommonTokenFactory.DEFAULT.create(4, ")")));
        ctx.addAnyChild((ParseTree)varid);
        ctx.addAnyChild((ParseTree)evc);
        return function.invoke(exprVisitor, ctx);
    }

    public static boolean useContextVariable(FunctionBase fct, MappingExpressionParser.Function_callContext ctx, String signature) {
        int max;
        if (ctx == null) {
            return false;
        }
        int argCount = FunctionBase.getArgumentCount(ctx);
        if (argCount == 0) {
            return true;
        }
        ParserRuleContext prc = ctx.getParent();
        if (prc != null && prc instanceof MappingExpressionParser.Fct_chainContext) {
            for (int i = 0; i < prc.children.size(); ++i) {
                if (prc.getChild(i) != ctx) continue;
                if (i <= 0) break;
                return true;
            }
        }
        int optional = FunctionUtils.getOptionalArgCount(signature);
        int min = fct.getMinArgs();
        if (min == (max = fct.getMaxArgs())) {
            return argCount < min;
        }
        if (argCount < max - optional) {
            return true;
        }
        return signature.indexOf("-") >= 0 && prc != null && prc instanceof MappingExpressionParser.PathContext;
    }

    public static int getOptionalArgCount(String signature) {
        int optional = 0;
        int optionIndex = signature.indexOf("?");
        while (optionIndex != -1) {
            ++optional;
            signature = signature.substring(optionIndex + 1);
            optionIndex = signature.indexOf("?");
        }
        return optional;
    }

    public static DeclaredFunction getFunctionArgFromCtx(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx, boolean useContext) {
        if (ctx.exprValues() == null || ctx.exprValues().exprList() == null || ctx.exprValues().exprList().expr() == null || ctx.exprValues().exprList().expr().size() == 0) {
            return null;
        }
        MappingExpressionParser.ExprContext varid = ctx.exprValues().exprList().expr(useContext ? 0 : 1);
        if (varid instanceof MappingExpressionParser.Var_recallContext) {
            return expressionVisitor.getDeclaredFunction(ctx.exprValues().exprList().expr(0).getText());
        }
        if (varid instanceof MappingExpressionParser.Function_declContext) {
            MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)ctx.exprValues().exprList().expr(useContext ? 0 : 1);
            return new DeclaredFunction(fctDeclCtx.varList(), fctDeclCtx.exprList());
        }
        return null;
    }
}

