/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.StringJoiner;

public class JoinFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$join");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$join");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$join");
    public static String ERR_MSG_ARG1_ARR_STR = String.format("Argument 1 of function %s must be an array of strings", "$join");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        StringJoiner stringJoiner;
        TextNode result = null;
        JsonNode argArray = null;
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = JoinFunction.getArgumentCount(ctx);
        if (useContext) {
            argArray = FunctionUtils.getContextVariable(expressionVisitor);
            if (argArray != null && !argArray.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount == 1 || argCount == 2) {
            JsonNode argSeparator;
            if (!useContext) {
                argArray = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if (argArray == null) {
                return null;
            }
            if (!argArray.isArray()) {
                if (!argArray.isTextual()) {
                    throw new EvaluateRuntimeException(ERR_MSG_ARG1_ARR_STR);
                }
                ArrayNode newArray = JsonNodeFactory.instance.arrayNode();
                newArray.add(argArray);
                argArray = newArray;
            }
            String separator = "";
            if (argCount == 2 && (argSeparator = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1)) != null) {
                if (argSeparator.isTextual()) {
                    separator = argSeparator.textValue();
                } else {
                    throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
                }
            }
            stringJoiner = new StringJoiner(separator);
            Iterator<JsonNode> elements = ((ArrayNode)argArray).elements();
            while (elements.hasNext()) {
                JsonNode element = elements.next();
                if (element.isTextual()) {
                    stringJoiner.add(element.asText());
                    continue;
                }
                if (element.isArray()) {
                    Iterator<JsonNode> it = ((ArrayNode)element).iterator();
                    while (it.hasNext()) {
                        stringJoiner.add(it.next().textValue());
                    }
                    continue;
                }
                throw new EvaluateRuntimeException(ERR_MSG_ARG1_ARR_STR);
            }
        } else {
            if (argCount != 0 && argArray == null) {
                return null;
            }
            throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : (argCount == 1 ? ERR_MSG_ARG1_ARR_STR : ERR_ARG3BADTYPE));
        }
        result = new TextNode(stringJoiner.toString());
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<a<s>s?:s>";
    }
}

